/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.numbers;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.utils.internal.numbers.AbstractFloatingPointNumber;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NonFiniteNumberException;
import org.kingdoms.utils.internal.numbers.NumberType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0012H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0012H\u0096\u0002J\t\u0010\u0019\u001a\u00020\u0012H\u0096\u0002J\t\u0010\u001a\u001a\u00020\u0012H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002J\u0011\u0010 \u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002J\u0011\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0019\u0010\u0011\u001a\u00020\u0003*\u00020\u00128\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/kingdoms/utils/internal/numbers/_Float;", "Lorg/kingdoms/utils/internal/numbers/AbstractFloatingPointNumber;", "value", "", "<init>", "(F)V", "getValue", "()Ljava/lang/Float;", "type", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "getType", "()Lorg/kingdoms/utils/internal/numbers/NumberType;", "isNegative", "", "()Z", "isPositive", "isZero", "convert", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "getConvert", "(Lorg/kingdoms/utils/internal/numbers/AnyNumber;)F", "constructNew", "", "unaryMinus", "unaryPlus", "inc", "dec", "plus", "other", "minus", "times", "div", "rem", "compareTo", "", "shared"})
@SourceDebugExtension(value={"SMAP\nNumberImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberImpl.kt\norg/kingdoms/utils/internal/numbers/_Float\n+ 2 AnyNumber.kt\norg/kingdoms/utils/internal/numbers/AbstractFloatingPointNumber\n*L\n1#1,109:1\n65#1:114\n65#1:115\n65#1:116\n65#1:117\n65#1:118\n65#1:119\n90#2,2:110\n90#2,2:112\n*S KotlinDebug\n*F\n+ 1 NumberImpl.kt\norg/kingdoms/utils/internal/numbers/_Float\n*L\n73#1:114\n74#1:115\n75#1:116\n76#1:117\n77#1:118\n79#1:119\n61#1:110,2\n62#1:112,2\n*E\n"})
public final class _Float
extends AbstractFloatingPointNumber {
    private final float value;
    @NotNull
    private final NumberType type;

    public _Float(float value) {
        this.value = value;
        this.type = NumberType.FLOAT;
        AbstractFloatingPointNumber abstractFloatingPointNumber = this;
        boolean requirement$iv = !Float.isNaN(this.getValue().floatValue());
        boolean $i$f$requireFinite = false;
        if (!requirement$iv) {
            boolean bl = false;
            String string = "Value is not finite, but NaN: " + this.getValue().floatValue();
            throw new NonFiniteNumberException(string);
        }
        AbstractFloatingPointNumber this_$iv = this;
        requirement$iv = !Float.isInfinite(this.getValue().floatValue());
        $i$f$requireFinite = false;
        if (!requirement$iv) {
            boolean bl = false;
            String string = "Value is not finite, but Infinity: " + this.getValue().floatValue();
            throw new NonFiniteNumberException(string);
        }
    }

    @Override
    @NotNull
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    @NotNull
    public NumberType getType() {
        return this.type;
    }

    @Override
    public boolean isNegative() {
        return this.getValue().floatValue() < 0.0f;
    }

    @Override
    public boolean isPositive() {
        return this.getValue().floatValue() > 0.0f;
    }

    @Override
    public boolean isZero() {
        return this.getValue().floatValue() == 0.0f;
    }

    private final float getConvert(AnyNumber $this$convert) {
        boolean $i$f$getConvert = false;
        return $this$convert.getValue().floatValue();
    }

    @Override
    @NotNull
    public AnyNumber constructNew(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new _Float(value.floatValue());
    }

    @Override
    @NotNull
    public AnyNumber unaryMinus() {
        return this.constructNew(Float.valueOf(-this.getValue().floatValue()));
    }

    @Override
    @NotNull
    public AnyNumber unaryPlus() {
        return this.constructNew(Float.valueOf(this.getValue().floatValue()));
    }

    @Override
    @NotNull
    public AnyNumber inc() {
        return this.constructNew(Float.valueOf(this.getValue().floatValue() + 1.0f));
    }

    @Override
    @NotNull
    public AnyNumber dec() {
        return this.constructNew(Float.valueOf(this.getValue().floatValue() - 1.0f));
    }

    @Override
    @NotNull
    public AnyNumber plus(@NotNull AnyNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        _Float _Float2 = this;
        AnyNumber $this$convert$iv = other;
        boolean $i$f$getConvert = false;
        return this.constructNew(Float.valueOf(this.getValue().floatValue() + $this$convert$iv.getValue().floatValue()));
    }

    @Override
    @NotNull
    public AnyNumber minus(@NotNull AnyNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        _Float _Float2 = this;
        AnyNumber $this$convert$iv = other;
        boolean $i$f$getConvert = false;
        return this.constructNew(Float.valueOf(this.getValue().floatValue() - $this$convert$iv.getValue().floatValue()));
    }

    @Override
    @NotNull
    public AnyNumber times(@NotNull AnyNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        _Float _Float2 = this;
        AnyNumber $this$convert$iv = other;
        boolean $i$f$getConvert = false;
        return this.constructNew(Float.valueOf(this.getValue().floatValue() * $this$convert$iv.getValue().floatValue()));
    }

    @Override
    @NotNull
    public AnyNumber div(@NotNull AnyNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        _Float _Float2 = this;
        AnyNumber $this$convert$iv = other;
        boolean $i$f$getConvert = false;
        return this.constructNew(Float.valueOf(this.getValue().floatValue() / $this$convert$iv.getValue().floatValue()));
    }

    @Override
    @NotNull
    public AnyNumber rem(@NotNull AnyNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        _Float _Float2 = this;
        AnyNumber $this$convert$iv = other;
        boolean $i$f$getConvert = false;
        return this.constructNew(Float.valueOf(this.getValue().floatValue() % $this$convert$iv.getValue().floatValue()));
    }

    @Override
    public int compareTo(@NotNull AnyNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        _Float _Float2 = this;
        AnyNumber $this$convert$iv = other;
        boolean $i$f$getConvert = false;
        return Float.compare(this.getValue().floatValue(), $this$convert$iv.getValue().floatValue());
    }
}

