/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.numbers;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.internal.numbers.AnyNumber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B1\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fj\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006 "}, d2={"Lorg/kingdoms/utils/internal/numbers/NumberType;", "", "jvmClass", "Ljava/lang/Class;", "", "minValue", "maxValue", "byteSize", "", "<init>", "(Ljava/lang/String;ILjava/lang/Class;Ljava/lang/Number;Ljava/lang/Number;I)V", "getJvmClass", "()Ljava/lang/Class;", "getMinValue", "()Ljava/lang/Number;", "getMaxValue", "getByteSize", "()I", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "parseString", "isFloatingPoint", "", "()Z", "shared"})
public abstract class NumberType
extends Enum<NumberType> {
    @NotNull
    private final Class<? extends Number> jvmClass;
    @NotNull
    private final Number minValue;
    @NotNull
    private final Number maxValue;
    private final int byteSize;
    public static final /* enum */ NumberType BYTE = new BYTE("BYTE", 0);
    public static final /* enum */ NumberType SHORT = new SHORT("SHORT", 1);
    public static final /* enum */ NumberType INT = new INT("INT", 2);
    public static final /* enum */ NumberType LONG = new LONG("LONG", 3);
    public static final /* enum */ NumberType FLOAT = new FLOAT("FLOAT", 4);
    public static final /* enum */ NumberType DOUBLE = new DOUBLE("DOUBLE", 5);
    private static final /* synthetic */ NumberType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private NumberType(Class<? extends Number> jvmClass, Number minValue, Number maxValue, int byteSize) {
        this.jvmClass = jvmClass;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.byteSize = byteSize;
    }

    @NotNull
    public final Class<? extends Number> getJvmClass() {
        return this.jvmClass;
    }

    @NotNull
    public final Number getMinValue() {
        return this.minValue;
    }

    @NotNull
    public final Number getMaxValue() {
        return this.maxValue;
    }

    public final int getByteSize() {
        return this.byteSize;
    }

    @NotNull
    protected abstract AnyNumber parseStringRaw(@NotNull String var1);

    @Nullable
    public final AnyNumber parseString(@NotNull String string) {
        AnyNumber anyNumber;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        try {
            anyNumber = this.parseStringRaw(string);
        }
        catch (NumberFormatException ignored) {
            anyNumber = null;
        }
        return anyNumber;
    }

    public final boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public static NumberType[] values() {
        return (NumberType[])$VALUES.clone();
    }

    public static NumberType valueOf(String value) {
        return Enum.valueOf(NumberType.class, value);
    }

    @NotNull
    public static EnumEntries<NumberType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ NumberType(String $enum$name, int $enum$ordinal, Class jvmClass, Number minValue, Number maxValue, int byteSize, DefaultConstructorMarker $constructor_marker) {
        this(jvmClass, minValue, maxValue, byteSize);
    }

    static {
        $VALUES = numberTypeArray = new NumberType[]{NumberType.BYTE, NumberType.SHORT, NumberType.INT, NumberType.LONG, NumberType.FLOAT, NumberType.DOUBLE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"org/kingdoms/utils/internal/numbers/NumberType.BYTE", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "shared"})
    static final class BYTE
    extends NumberType {
        /*
         * WARNING - void declaration
         */
        BYTE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected AnyNumber parseStringRaw(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return AnyNumber.Companion.of((Number)Byte.parseByte(string));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"org/kingdoms/utils/internal/numbers/NumberType.DOUBLE", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "shared"})
    static final class DOUBLE
    extends NumberType {
        /*
         * WARNING - void declaration
         */
        DOUBLE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected AnyNumber parseStringRaw(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return AnyNumber.Companion.of(Double.parseDouble(string));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"org/kingdoms/utils/internal/numbers/NumberType.FLOAT", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "shared"})
    static final class FLOAT
    extends NumberType {
        /*
         * WARNING - void declaration
         */
        FLOAT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected AnyNumber parseStringRaw(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return AnyNumber.Companion.of(Float.parseFloat(string));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"org/kingdoms/utils/internal/numbers/NumberType.INT", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "shared"})
    static final class INT
    extends NumberType {
        /*
         * WARNING - void declaration
         */
        INT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected AnyNumber parseStringRaw(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return AnyNumber.Companion.of(Integer.parseInt(string));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"org/kingdoms/utils/internal/numbers/NumberType.LONG", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "shared"})
    static final class LONG
    extends NumberType {
        /*
         * WARNING - void declaration
         */
        LONG() {
            void var1_1;
        }

        @Override
        @NotNull
        protected AnyNumber parseStringRaw(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return AnyNumber.Companion.of(Long.parseLong(string));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"org/kingdoms/utils/internal/numbers/NumberType.SHORT", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "parseStringRaw", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "string", "", "shared"})
    static final class SHORT
    extends NumberType {
        /*
         * WARNING - void declaration
         */
        SHORT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected AnyNumber parseStringRaw(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return AnyNumber.Companion.of((Number)Short.parseShort(string));
        }
    }
}

