/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.nonnull;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.CollectionToArray;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableSet;
import org.kingdoms.utils.internal.nonnull.Nullability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0016\u0010\u0017\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\t\u0010\u001d\u001a\u00020\rH\u0096\u0001J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0096\u0003R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/kingdoms/utils/internal/nonnull/NonNullSet;", "V", "", "set", "<init>", "(Ljava/util/Set;)V", "getSet", "()Ljava/util/Set;", "size", "", "getSize", "()I", "addAll", "", "elements", "", "add", "element", "(Ljava/lang/Object;)Z", "remove", "contains", "containsAll", "retainAll", "removeAll", "hashCode", "toString", "", "clear", "", "isEmpty", "iterator", "", "shared"})
public final class NonNullSet<V>
implements Set<V>,
KMutableSet {
    @NotNull
    private final Set<V> set;
    private final int size;

    public NonNullSet(@NotNull Set<V> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.set = set;
        this.size = this.set.size();
    }

    public /* synthetic */ NonNullSet(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new HashSet();
        }
        this(set);
    }

    @NotNull
    public final Set<V> getSet() {
        return this.set;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.set.addAll(Nullability.assertNonNullElements(elements));
    }

    @Override
    public boolean add(V element) {
        return this.set.add(Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean remove(Object element) {
        return this.set.remove(Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean contains(Object element) {
        return this.set.contains(Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.set.containsAll(Nullability.assertNonNullElements(elements));
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.set.retainAll(CollectionsKt.toSet((Iterable)Nullability.assertNonNullElements(elements)));
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.set.removeAll(CollectionsKt.toSet((Iterable)Nullability.assertNonNullElements(elements)));
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("Hashcodes are not supported for this implementation");
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.set + ')';
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.set.iterator();
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public NonNullSet() {
        this(null, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

