/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.nonnull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.CollectionToArray;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableList;
import org.kingdoms.utils.internal.nonnull.Nullability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010)\n\u0000\n\u0002\u0010+\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001e\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0016\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0015\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0016\u0010\u001f\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0016\u0010 \u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0014H\u0096\u0001J\u0016\u0010%\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0007H\u0096\u0003\u00a2\u0006\u0002\u0010&J\t\u0010'\u001a\u00020\u0012H\u0096\u0001J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0096\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0001J\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+2\u0006\u0010\u000e\u001a\u00020\u0007H\u0096\u0001J\u0016\u0010,\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010&J\u001f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0007H\u0096\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00060"}, d2={"Lorg/kingdoms/utils/internal/nonnull/NonNullList;", "V", "", "list", "<init>", "(Ljava/util/List;)V", "size", "", "(I)V", "getList", "()Ljava/util/List;", "getSize", "()I", "set", "index", "element", "(ILjava/lang/Object;)Ljava/lang/Object;", "add", "", "(Ljava/lang/Object;)Z", "", "(ILjava/lang/Object;)V", "addAll", "elements", "", "remove", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "contains", "containsAll", "retainAll", "removeAll", "hashCode", "toString", "", "clear", "get", "(I)Ljava/lang/Object;", "isEmpty", "iterator", "", "listIterator", "", "removeAt", "subList", "fromIndex", "toIndex", "shared"})
public final class NonNullList<V>
implements List<V>,
KMutableList {
    @NotNull
    private final List<V> list;
    private final int size;

    public NonNullList(@NotNull List<V> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.list = list;
        this.size = this.list.size();
    }

    @NotNull
    public final List<V> getList() {
        return this.list;
    }

    public int getSize() {
        return this.size;
    }

    public NonNullList(int size) {
        this(new ArrayList(size));
    }

    @Override
    public V set(int index, V element) {
        return this.list.set(index, Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean add(V element) {
        return this.list.add(Nullability.assertNonNull(this, element));
    }

    @Override
    public void add(int index, V element) {
        this.list.add(index, Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.addAll(index, Nullability.assertNonNullElements(elements));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.addAll(Nullability.assertNonNullElements(elements));
    }

    @Override
    public boolean remove(Object element) {
        return this.list.remove(Nullability.assertNonNull(this, element));
    }

    @Override
    public int indexOf(Object element) {
        return this.list.indexOf(Nullability.assertNonNull(this, element));
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.list.lastIndexOf(Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean contains(Object element) {
        return this.list.contains(Nullability.assertNonNull(this, element));
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.containsAll(Nullability.assertNonNullElements(elements));
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.retainAll(CollectionsKt.toSet((Iterable)Nullability.assertNonNullElements(elements)));
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.list.removeAll(CollectionsKt.toSet((Iterable)Nullability.assertNonNullElements(elements)));
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("Hashcodes are not supported for this implementation");
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.list + ')';
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public V removeAt(int index) {
        return this.list.remove(index);
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return this.list.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    @NotNull
    public List<V> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.list.iterator();
    }

    @Override
    public V get(int index) {
        return this.list.get(index);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

