/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.hash;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public final class EntityWeakHashMap<E extends Entity, V>
extends EntityHashMap<EntityWeakHashMap<E, V>, E, V> {
    private final Map<E, V> map;

    protected EntityWeakHashMap(Class<E> entityClass, int size, BiConsumer<EntityWeakHashMap<E, V>, E> leaveHandle, BiConsumer<EntityWeakHashMap<E, V>, E> deathHandle) {
        super(entityClass, leaveHandle, deathHandle);
        this.map = NonNullMap.of(new WeakHashMap(size));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(((Player)key).getEntityId());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NotNull Map m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<E, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V put(E entity2, V value) {
        return this.map.put(entity2, value);
    }

    @Override
    public V remove(E entity2) {
        return this.map.remove(entity2);
    }

    @Override
    public boolean containsKey(E entity2) {
        return this.map.containsKey(entity2);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super E, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super E, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
    }

    @Override
    @Nullable
    public V putIfAbsent(E key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(E key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public V replace(E key, V value) {
        return this.map.replace(key, value);
    }

    @Override
    public V computeIfAbsent(E key, @NotNull Function<? super E, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(E key, @NotNull BiFunction<? super E, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent(key, remappingFunction);
    }

    @Override
    public V compute(E key, @NotNull BiFunction<? super E, ? super V, ? extends V> remappingFunction) {
        return this.map.compute(key, remappingFunction);
    }

    @Override
    public V merge(E key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.map + ')';
    }
}

