/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.hash;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.entity.Entity;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.internal.nonnull.NonNullSet;

public class EntityUUIDHashSet<E extends Entity>
extends EntityHashSet<EntityUUIDHashSet<E>, E> {
    private final Set<UUID> set;

    protected EntityUUIDHashSet(Class<E> entityClass, int size, BiConsumer<EntityUUIDHashSet<E>, E> leaveHandle, BiConsumer<EntityUUIDHashSet<E>, E> deathHandle) {
        super(entityClass, leaveHandle, deathHandle);
        this.set = new NonNullSet(new HashSet(size));
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(EntityUUIDHashSet.convert(o));
    }

    private static UUID convert(Object o) {
        if (o instanceof Entity) {
            return ((Entity)o).getUniqueId();
        }
        if (o instanceof UUID) {
            return (UUID)o;
        }
        throw new IllegalArgumentException("Invalid key type: " + o);
    }

    @Override
    public boolean contains(UUID uuid) {
        return this.set.contains(uuid);
    }

    @Override
    public boolean contains(E o) {
        return this.set.contains(o.getUniqueId());
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(UUID entity2) {
        return this.set.add(entity2);
    }

    @Override
    public boolean add(E entity2) {
        return this.set.add(entity2.getUniqueId());
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(EntityUUIDHashSet.convert(o));
    }

    @Override
    public boolean remove(UUID o) {
        return this.set.remove(o);
    }

    @Override
    public boolean remove(E o) {
        return this.set.remove(o.getUniqueId());
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<E> stream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<E> parallelStream() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.set + ')';
    }
}

