/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.hash;

import java.util.Set;
import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;
import org.kingdoms.utils.hash.EntityHashContainer;
import org.kingdoms.utils.hash.EntityUUIDHashSet;
import org.kingdoms.utils.hash.EntityWeakHashSet;

public abstract class EntityHashSet<C extends EntityHashSet<C, E>, E extends Entity>
extends EntityHashContainer<C, E>
implements Set<E> {
    protected EntityHashSet(Class<E> entityClass, BiConsumer<C, E> leaveHandle, BiConsumer<C, E> deathHandle) {
        super(entityClass, leaveHandle, deathHandle);
    }

    public static <E extends Entity> WeakBuilder<E> weakBuilder(Class<E> entityClass) {
        return new WeakBuilder<E>(entityClass);
    }

    public static <E extends Entity> UUIDBuilder<E> uuidBuilder(Class<E> entityClass) {
        return new UUIDBuilder<E>(entityClass);
    }

    @Override
    public abstract boolean add(E var1);

    @Override
    public abstract boolean remove(E var1);

    @Override
    public abstract boolean contains(E var1);

    public static final class WeakBuilder<E extends Entity>
    extends Builder<EntityWeakHashSet<E>, E> {
        protected WeakBuilder(Class<E> entityClass) {
            super(entityClass);
        }

        public WeakBuilder<E> size(int size) {
            super.size(size);
            return this;
        }

        public WeakBuilder<E> onLeave(BiConsumer<EntityWeakHashSet<E>, E> handle2) {
            super.onLeave(handle2);
            return this;
        }

        public WeakBuilder<E> onDeath(BiConsumer<EntityWeakHashSet<E>, E> handle2) {
            super.onDeath(handle2);
            return this;
        }

        public EntityWeakHashSet<E> build() {
            return new EntityWeakHashSet(this.entityClass, this.size, this.leaveHandle, this.deathHandle);
        }
    }

    public static final class UUIDBuilder<E extends Entity>
    extends Builder<EntityUUIDHashSet<E>, E> {
        protected UUIDBuilder(Class<E> entityClass) {
            super(entityClass);
        }

        public UUIDBuilder<E> size(int size) {
            super.size(size);
            return this;
        }

        public UUIDBuilder<E> onLeave(BiConsumer<EntityUUIDHashSet<E>, E> handle2) {
            super.onLeave(handle2);
            return this;
        }

        public UUIDBuilder<E> onDeath(BiConsumer<EntityUUIDHashSet<E>, E> handle2) {
            super.onDeath(handle2);
            return this;
        }

        public EntityUUIDHashSet<E> build() {
            return new EntityUUIDHashSet(this.entityClass, this.size, this.leaveHandle, this.deathHandle);
        }
    }

    public static abstract class Builder<C extends EntityHashSet<C, E>, E extends Entity> {
        protected BiConsumer<C, E> leaveHandle;
        protected BiConsumer<C, E> deathHandle;
        protected final Class<E> entityClass;
        protected int size;

        protected Builder(Class<E> entityClass) {
            this.entityClass = entityClass;
        }

        public Builder<C, E> size(int size) {
            this.size = size;
            return this;
        }

        public Builder<C, E> onLeave(BiConsumer<C, E> handle2) {
            this.leaveHandle = handle2;
            return this;
        }

        public Builder<C, E> onDeath(BiConsumer<C, E> handle2) {
            this.deathHandle = handle2;
            return this;
        }

        public abstract EntityHashSet<C, E> build();
    }
}

