/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.hash;

import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;
import org.kingdoms.utils.hash.EntityHashContainer;
import org.kingdoms.utils.hash.EntityWeakHashMap;

public abstract class EntityHashMap<M extends EntityHashMap<M, E, V>, E extends Entity, V>
extends EntityHashContainer<M, E>
implements Map<E, V> {
    protected EntityHashMap(Class<E> entityClass, BiConsumer<M, E> leaveHandle, BiConsumer<M, E> deathHandle) {
        super(entityClass, leaveHandle, deathHandle);
    }

    public static <E extends Entity, V> WeakBuilder<E, V> weakBuilder(Class<E> entityClass) {
        return new WeakBuilder(entityClass);
    }

    @Override
    public abstract V put(E var1, V var2);

    @Override
    public abstract V remove(E var1);

    @Override
    public abstract boolean containsKey(E var1);

    public static final class WeakBuilder<E extends Entity, V>
    extends Builder<EntityWeakHashMap<E, V>, E, V> {
        protected WeakBuilder(Class<E> entityClass) {
            super(entityClass);
        }

        public WeakBuilder<E, V> size(int size) {
            super.size(size);
            return this;
        }

        public WeakBuilder<E, V> onLeave(BiConsumer<EntityWeakHashMap<E, V>, E> handle2) {
            this.leaveHandle = handle2;
            return this;
        }

        public WeakBuilder<E, V> onDeath(BiConsumer<EntityWeakHashMap<E, V>, E> handle2) {
            super.onDeath(handle2);
            return this;
        }

        @Override
        public EntityWeakHashMap<E, V> build() {
            return new EntityWeakHashMap(this.entityClass, this.size, this.leaveHandle, this.deathHandle);
        }
    }

    public static abstract class Builder<M extends EntityHashMap<M, E, V>, E extends Entity, V> {
        protected BiConsumer<M, E> leaveHandle;
        protected BiConsumer<M, E> deathHandle;
        protected final Class<E> entityClass;
        protected int size;

        protected Builder(Class<E> entityClass) {
            this.entityClass = entityClass;
        }

        public Builder<M, E, V> size(int size) {
            this.size = size;
            return this;
        }

        public Builder<M, E, V> onLeave(BiConsumer<M, E> handle2) {
            this.leaveHandle = handle2;
            return this;
        }

        public Builder<M, E, V> onDeath(BiConsumer<M, E> handle2) {
            this.deathHandle = handle2;
            return this;
        }

        public abstract M build();
    }
}

