/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.hash;

import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.hash.EntityHashContainer;
import org.kingdoms.utils.internal.reflection.Reflect;

public final class EntityHashHandler
implements Listener {
    private static final Cache<EntityHashContainer, Boolean> HANDLERS = CacheHandler.newBuilder().weakKeys().build();

    public EntityHashHandler(Kingdoms plugin) {
        if (Reflect.classExists("org.bukkit.event.entity.EntityRemoveEvent")) {
            plugin.registerEvent(new EntityRemoval());
        }
    }

    protected static void register(EntityHashContainer map) {
        HANDLERS.put((Object)map, (Object)true);
    }

    private static void handle(Entity entity2, boolean death) {
        Class entityClass = entity2.getClass();
        for (EntityHashContainer handler : HANDLERS.asMap().keySet()) {
            BiConsumer handle2;
            if (!handler.entityClass.isAssignableFrom(entityClass) || (handle2 = death ? handler.deathHandle : handler.leaveHandle) == null) continue;
            handle2.accept(handler, entity2);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDeath(EntityDeathEvent event) {
        EntityHashHandler.handle((Entity)event.getEntity(), true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        EntityHashHandler.handle((Entity)event.getPlayer(), false);
    }

    private static final class EntityRemoval
    implements Listener {
        private EntityRemoval() {
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onRemove(EntityRemoveEvent event) {
            EntityHashHandler.handle(event.getEntity(), false);
        }
    }
}

