/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.fs.walker.visitors;

import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.fs.walker.FileTreeWalker;
import org.kingdoms.utils.fs.walker.visitors.PathVisit;
import org.kingdoms.utils.fs.walker.visitors.PathVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/utils/fs/walker/visitors/CollectorPathVisitor;", "Lorg/kingdoms/utils/fs/walker/visitors/PathVisitor;", "root", "Ljava/nio/file/Path;", "visitor", "<init>", "(Ljava/nio/file/Path;Lorg/kingdoms/utils/fs/walker/visitors/PathVisitor;)V", "getRoot", "()Ljava/nio/file/Path;", "getVisitor", "()Lorg/kingdoms/utils/fs/walker/visitors/PathVisitor;", "list", "", "getList", "()Ljava/util/List;", "onVisit", "Ljava/nio/file/FileVisitResult;", "visit", "Lorg/kingdoms/utils/fs/walker/visitors/PathVisit;", "getFiles", "", "shared"})
public final class CollectorPathVisitor
implements PathVisitor {
    @NotNull
    private final Path root;
    @NotNull
    private final PathVisitor visitor;
    @NotNull
    private final List<Path> list;

    public CollectorPathVisitor(@NotNull Path root, @NotNull PathVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        this.root = root;
        this.visitor = visitor;
        this.list = new ArrayList();
    }

    @NotNull
    public final Path getRoot() {
        return this.root;
    }

    @NotNull
    public final PathVisitor getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final List<Path> getList() {
        return this.list;
    }

    @Override
    @NotNull
    public FileVisitResult onVisit(@NotNull PathVisit visit) {
        Intrinsics.checkNotNullParameter((Object)visit, (String)"visit");
        FileVisitResult result = this.visitor.onVisit(visit);
        switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: 
            case 2: {
                this.list.add(visit.getPath());
            }
        }
        return result;
    }

    @NotNull
    public final List<Path> getFiles() {
        FileTreeWalker.walkFileTree(this.root, new HashSet(), Integer.MAX_VALUE, this);
        return this.list;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileVisitResult.values().length];
            try {
                nArray[FileVisitResult.CONTINUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileVisitResult.SKIP_SIBLINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

