/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.fs;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public abstract class FolderRegistry {
    protected final String displayName;
    protected final Path folder;
    protected boolean copyDefaults = false;
    protected boolean useDefaults = false;
    private final Set<String> present = new HashSet<String>();

    public FolderRegistry(@NonNull String displayName, @NonNull Path folder) {
        this.displayName = Objects.requireNonNull(displayName);
        this.folder = Objects.requireNonNull(folder);
        if (Files.exists(folder, new LinkOption[0]) && !Files.isDirectory(folder, new LinkOption[0])) {
            throw new IllegalArgumentException("Path doesn't refer to a folder: " + folder.toAbsolutePath());
        }
    }

    protected boolean filter(@NonNull Path path) {
        return true;
    }

    protected void visitPresent() {
        if (!Files.exists(this.folder, new LinkOption[0])) {
            throw new IllegalStateException("Cannot visit because the folder doesn't exist: " + this.folder);
        }
        try (Stream<Path> stream = Files.walk(this.folder, new FileVisitOption[0]);){
            stream.filter((? super T x$0) -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::filter).forEach(item -> {
                String relativePathLocation = this.folder.toAbsolutePath().relativize(item.toAbsolutePath()).toString();
                String name = FolderRegistry.normalizeName(relativePathLocation);
                this.present.add(name);
                KLogger.debug((DebugNS)KingdomsDebug.FOLDER$REGISTRY, "Visting present of " + this + " -> " + name + " | " + relativePathLocation);
                try {
                    this.handle(new Entry(name, relativePathLocation, (Path)item, null));
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Error while registering " + this.displayName + " '" + name + "' " + item.toFile(), ex);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract Pair<String, URI> getDefaultsURI();

    protected abstract void handle(@NonNull Entry var1);

    public abstract void register();

    public FolderRegistry dontUseDefaultsIfFolderExists() {
        boolean useDefaults = !Files.exists(this.folder, new LinkOption[0]);
        this.copyDefaults(useDefaults).useDefaults(useDefaults);
        return this;
    }

    public FolderRegistry copyDefaults(boolean value) {
        this.copyDefaults = value;
        return this;
    }

    public FolderRegistry useDefaults(boolean value) {
        this.useDefaults = value;
        return this;
    }

    private static String normalizeName(String relativePath) {
        return relativePath.substring(0, relativePath.lastIndexOf(46)).replace('\\', '/').replace(' ', '-');
    }

    protected void visitDefaults() {
        Pair<String, URI> defaults;
        try {
            defaults = this.getDefaultsURI();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to obtain defaults for: " + this, ex);
        }
        URI uri = defaults.getValue();
        String folderName = defaults.getKey();
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, new HashMap());){
            for (Path path : zipfs.getRootDirectories()) {
                Stream<Path> stream = Files.walk(path.resolve('/' + folderName), new FileVisitOption[0]);
                try {
                    stream.filter((? super T x$0) -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::filter).forEach(item -> {
                        String relativePath = item.toString();
                        String name = FolderRegistry.normalizeName(relativePath = relativePath.substring(1 + folderName.length() + 1));
                        if (this.present.contains(name)) {
                            return;
                        }
                        KLogger.debug((DebugNS)KingdomsDebug.FOLDER$REGISTRY, "Visting default of " + this + " -> " + name + " | " + relativePath);
                        Entry entry = new Entry(name, relativePath, this.folder.resolve(relativePath), (Path)item);
                        if (this.copyDefaults) {
                            try {
                                if (!Files.exists(entry.getPath(), new LinkOption[0])) {
                                    Files.createDirectories(entry.getPath().getParent(), new FileAttribute[0]);
                                    Files.copy(entry.getDefaultPath(), entry.getPath(), new CopyOption[0]);
                                }
                            }
                            catch (IOException e) {
                                throw new IllegalStateException("Failed to copy defaults from " + entry.getDefaultPath() + " -> " + entry.getPath(), e);
                            }
                        }
                        try {
                            this.handle(entry);
                        }
                        catch (Throwable ex) {
                            throw new IllegalStateException("Error while registering default " + name + " (" + relativePath + ") for " + this, ex);
                        }
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create file system for defaults: " + this, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "displayName='" + this.displayName + '\'' + ", folder=" + this.folder + ", copyDefaults=" + this.copyDefaults + ", useDefaults=" + this.useDefaults + '}';
    }

    public static final class Entry {
        private final @NonNull String name;
        private final @NonNull String relativePathLocation;
        private final @NonNull Path path;
        private final @Nullable Path defaultPath;

        public Entry(@NonNull String name, @NonNull String relativePathLocation, @NonNull Path path, @Nullable Path defaultPath) {
            this.name = name;
            this.relativePathLocation = relativePathLocation;
            this.path = path;
            this.defaultPath = defaultPath;
        }

        public String getName() {
            return this.name;
        }

        public String getRelativeName() {
            return this.relativePathLocation;
        }

        public Path getDefaultPath() {
            return this.defaultPath;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isDefault() {
            return this.defaultPath != null;
        }
    }
}

