/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.fs;

import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.runnables.IORunnable;

public final class FSUtil {
    public static final StandardOpenOption[] STD_WRITER = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Set<Character> ILLEGAL_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('\u0000'), Character.valueOf('\f'), Character.valueOf('`'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':'), Character.valueOf('\u0000'), Character.valueOf('\"'), Character.valueOf('*'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('|')));

    public static int countEntriesOf(Path folder) {
        int n;
        block9: {
            if (!Files.isDirectory(folder, new LinkOption[0])) {
                throw new IllegalArgumentException("Path is not a folder: " + folder.toAbsolutePath());
            }
            DirectoryStream<Path> fs = Files.newDirectoryStream(folder);
            try {
                n = ArrayUtils.sizeOfIterator(fs.iterator());
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fs.close();
        }
        return n;
    }

    public static BufferedWriter standardWriter(Path path) throws IOException {
        return Files.newBufferedWriter(path, StandardCharsets.UTF_8, (OpenOption[])STD_WRITER);
    }

    public static int countEntriesOf(Path folder, Predicate<Path> filter) {
        int n;
        block9: {
            if (!Files.isDirectory(folder, new LinkOption[0])) {
                throw new IllegalArgumentException("Path is not a folder: " + folder.toAbsolutePath());
            }
            DirectoryStream<Path> fs = Files.newDirectoryStream(folder);
            try {
                n = (int)StreamSupport.stream(fs.spliterator(), false).filter(filter).count();
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fs.close();
        }
        return n;
    }

    public static Path findSlotForCounterFile(Path folder, String prefix, String extension) {
        Path file;
        int counter = 1;
        while (Files.exists(file = folder.resolve(prefix + '-' + counter++ + '.' + extension), new LinkOption[0])) {
        }
        return file;
    }

    public static Path findSlotForCounterFolder(Path folder, String prefix) {
        Path file;
        int counter = 1;
        while (Files.exists(file = folder.resolve(prefix + '-' + counter++), new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
        }
        return file;
    }

    public void lockBeforeCopy(Path from, OutputStream to, Runnable beforeWrite) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(from, StandardOpenOption.READ);
             FileLock lock = fileChannel.lock(0L, Long.MAX_VALUE, true);){
            long count;
            WritableByteChannel zsChan = Channels.newChannel(to);
            long maxCount = 67076096L;
            long position = 0L;
            beforeWrite.run();
            for (long size = fileChannel.size(); size > 0L; size -= count) {
                count = fileChannel.transferTo(position, Math.min(maxCount, size), zsChan);
                position += count;
            }
        }
    }

    private static boolean isInvalidFileNameChar(char ch) {
        return Character.isISOControl(ch) || ILLEGAL_CHARACTERS.contains(Character.valueOf(ch));
    }

    public static boolean isValidPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return false;
        }
        try {
            Paths.get(path, new String[0]);
        }
        catch (InvalidPathException ex) {
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(String name) {
        for (char ch : name.toCharArray()) {
            if (!FSUtil.isInvalidFileNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    public static Path transformPath(FileSystem fs, Path path) {
        Path finalPath = fs.getPath(path.isAbsolute() ? fs.getSeparator() : "", new String[0]);
        for (Path component : path) {
            finalPath = finalPath.resolve(component.getFileName().toString());
        }
        return finalPath;
    }

    public static String removeInvalidFileChars(String name, String replaceWith) {
        StringBuilder builder = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (FSUtil.isInvalidFileNameChar(ch)) {
                builder.append(replaceWith);
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static String oneOfValidFileNames(String ... names) {
        for (String name : names) {
            if (!FSUtil.isValidFileName(name)) continue;
            return name;
        }
        throw new IllegalArgumentException("None of the file names are valid: " + Arrays.toString(names));
    }

    public static boolean isFolderEmpty(Path folder) {
        return FSUtil.countEntriesOf(folder) == 0;
    }

    public static void deleteFolder(Path folder) {
        FSUtil.deleteFolder(folder, Fn.alwaysFalse());
    }

    public static void deleteFolder(Path folder, Predicate<Path> ignore) {
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        try {
            AtomicBoolean errored = new AtomicBoolean();
            Files.list(folder).forEach(path -> {
                try {
                    if (folder.equals(path)) {
                        return;
                    }
                    if (ignore.test((Path)path)) {
                        return;
                    }
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        FSUtil.deleteFolder(path);
                    } else {
                        Files.delete(path);
                    }
                }
                catch (IOException ex) {
                    errored.set(true);
                    ex.printStackTrace();
                }
            });
            if (!errored.get()) {
                Files.delete(folder);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void deleteAllFileTypes(Path folder, String type) {
        try {
            Files.list(folder).forEach(path -> {
                try {
                    if (folder.equals(path)) {
                        return;
                    }
                    if (!path.toString().endsWith(type)) {
                        return;
                    }
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        return;
                    }
                    Files.delete(path);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static List<Path> getFiles(Path folder) {
        ArrayList<Path> files = new ArrayList<Path>();
        PathIterator iterator = new PathIterator(null, (p, attrs) -> {
            if (attrs.isRegularFile()) {
                files.add((Path)p);
            }
        });
        try {
            Files.walkFileTree(folder, iterator);
            return files;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream stringToInputStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(out, "out");
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    public static void copyFolder(Path source, Path destination) {
        try {
            Files.walkFileTree(source, new CopyFileVisitor(source, destination));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void lockAndTransfer(Path file, OutputStream transferTo, IORunnable beforeTransfer) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(file, StandardOpenOption.READ);
             FileLock lock = fileChannel.lock(0L, Long.MAX_VALUE, true);){
            long count;
            WritableByteChannel zsChan = Channels.newChannel(transferTo);
            long maxCount = 67076096L;
            long position = 0L;
            beforeTransfer.run();
            for (long size = fileChannel.size(); size > 0L; size -= count) {
                count = fileChannel.transferTo(position, Math.min(maxCount, size), zsChan);
                position += count;
            }
        }
    }

    private static final class PathIterator
    extends SimpleFileVisitor<Path> {
        public final BiConsumer<Path, BasicFileAttributes> visitor;
        private final BiPredicate<Path, BasicFileAttributes> filter;

        private PathIterator(BiPredicate<Path, BasicFileAttributes> filter, BiConsumer<Path, BasicFileAttributes> consumer) {
            this.visitor = consumer;
            this.filter = filter;
        }

        private FileVisitResult visit(Path path, BasicFileAttributes attrs) {
            if (this.filter == null || this.filter.test(path, attrs)) {
                this.visitor.accept(path, attrs);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            return this.visit(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            return this.visit(file, attrs);
        }
    }

    private static final class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path sourcePath;
        private final Path targetPath;

        public CopyFileVisitor(Path sourcePath, Path targetPath) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }
    }
}

