/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.visualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.kingdoms.constants.namespace.NamespacedMetadataContainer;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.provider.MessageContextProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.PluginState;
import org.kingdoms.scheduler.AbstractJavaScheduler;
import org.kingdoms.scheduler.TaskScheduleProvider;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.scheduler.TracedRunnable;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.VisualizerOperationException;
import org.kingdoms.utils.display.visualizer.visibility.StatefulVisibilityStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0017J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0017J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0017J\b\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u0019H\u0016J\b\u0010%\u001a\u00020\u0019H\u0016J\u0016\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0016J4\u0010&\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+2\u0006\u0010-\u001a\u00020.2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020/2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(H\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128g@gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00060\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/display/visualizer/Visualizer;", "Lorg/kingdoms/locale/provider/MessageContextProvider;", "Lorg/kingdoms/utils/display/components/VisualComponent;", "Lorg/kingdoms/constants/namespace/NamespacedMetadataContainer;", "components", "", "getComponents", "()Ljava/util/List;", "visibilityStrategy", "Lorg/kingdoms/utils/display/visualizer/visibility/StatefulVisibilityStrategy;", "getVisibilityStrategy", "()Lorg/kingdoms/utils/display/visualizer/visibility/StatefulVisibilityStrategy;", "operationQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/lang/Runnable;", "getOperationQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "value", "Ljava/lang/Thread;", "processingThread", "getProcessingThread", "()Ljava/lang/Thread;", "setProcessingThread", "(Ljava/lang/Thread;)V", "enqueueOperation", "", "operation", "addComponent", "component", "removeComponent", "onPlayerAdd", "player", "Lorg/bukkit/entity/Player;", "onPlayerRemove", "clearVisualComponents", "start", "stop", "close", "runThreadedComponents", "run", "Ljava/util/function/Consumer;", "shouldStopTasks", "", "Ljava/util/concurrent/RunnableFuture;", "Ljava/lang/Void;", "taskThreadType", "Lorg/kingdoms/scheduler/TaskThreadType;", "", "core"})
@SourceDebugExtension(value={"SMAP\nVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Visualizer.kt\norg/kingdoms/utils/display/visualizer/Visualizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1#2:276\n1863#3,2:277\n*S KotlinDebug\n*F\n+ 1 Visualizer.kt\norg/kingdoms/utils/display/visualizer/Visualizer\n*L\n125#1:277,2\n*E\n"})
public interface Visualizer
extends MessageContextProvider,
VisualComponent,
NamespacedMetadataContainer {
    @NotNull
    public List<VisualComponent> getComponents();

    @NotNull
    public StatefulVisibilityStrategy getVisibilityStrategy();

    @ApiStatus.Internal
    @NotNull
    public ConcurrentLinkedQueue<Runnable> getOperationQueue();

    @ApiStatus.Internal
    @Nullable
    public Thread getProcessingThread();

    @ApiStatus.Internal
    public void setProcessingThread(@Nullable Thread var1);

    @ApiStatus.Internal
    default public void enqueueOperation(@NotNull Runnable operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (this.shouldStopTasks()) {
            return;
        }
        try {
            Thread currentThread = Thread.currentThread();
            if (!this.getOperationQueue().isEmpty()) {
                if (currentThread == this.getProcessingThread()) {
                    operation.run();
                    return;
                }
                this.getOperationQueue().offer(new TracedRunnable(operation));
                return;
            }
            this.getOperationQueue().offer(operation);
            this.setProcessingThread(currentThread);
            operation.run();
            while (true) {
                Runnable next = this.getOperationQueue().poll();
                if (this.shouldStopTasks()) {
                    this.setProcessingThread(null);
                    return;
                }
                if (next == null) {
                    this.setProcessingThread(null);
                    return;
                }
                if (next == operation) continue;
                next.run();
            }
        }
        catch (VisualizerOperationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VisualizerOperationException("Error while running operations for " + this, ex);
        }
    }

    default public void addComponent(@NotNull VisualComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (!(component.getState() != VisualComponent.State.STARTED)) {
            boolean bl = false;
            String string = "Cannot add a component that is already started " + component;
            throw new IllegalArgumentException(string.toString());
        }
        this.getComponents().add(component);
        FutureTask<Object> future = new FutureTask<Object>(() -> Visualizer.addComponent$lambda$2(this, component), null);
        this.enqueueOperation(() -> Visualizer.addComponent$lambda$3(component, future));
    }

    default public void removeComponent(@NotNull VisualComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.getComponents().remove(component);
        if (component.getState() == VisualComponent.State.STARTED) {
            this.enqueueOperation(() -> Visualizer.removeComponent$lambda$5(component));
        }
    }

    @Override
    @ApiStatus.Internal
    default public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.runThreadedComponents(arg_0 -> Visualizer.onPlayerAdd$lambda$6(player, arg_0));
    }

    @Override
    @ApiStatus.Internal
    default public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.runThreadedComponents(arg_0 -> Visualizer.onPlayerRemove$lambda$7(player, arg_0));
    }

    default public void clearVisualComponents() {
        this.enqueueOperation(() -> Visualizer.clearVisualComponents$lambda$9(this));
    }

    @Override
    default public void start() {
        this.enqueueOperation(() -> Visualizer.start$lambda$11(this));
    }

    @Override
    default public void stop() {
        this.enqueueOperation(() -> Visualizer.stop$lambda$13(this));
    }

    @Override
    default public void close() {
        this.enqueueOperation(() -> Visualizer.close$lambda$15(this));
    }

    private void runThreadedComponents(Consumer<VisualComponent> run) {
        List sync = new ArrayList(this.getComponents().size());
        List async = new ArrayList(this.getComponents().size());
        List any = new ArrayList(this.getComponents().size());
        for (VisualComponent component : this.getComponents()) {
            List list;
            switch (WhenMappings.$EnumSwitchMapping$0[component.getTaskThreadType().ordinal()]) {
                case 1: {
                    list = any;
                    break;
                }
                case 2: {
                    list = sync;
                    break;
                }
                case 3: {
                    list = async;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            List list2 = list;
            list2.add(component);
        }
        this.runThreadedComponents(TaskThreadType.ANY, any, run);
        this.enqueueOperation(() -> Visualizer.runThreadedComponents$lambda$16(this, async, run, sync));
    }

    default public boolean shouldStopTasks() {
        return Kingdoms.get().getState() == PluginState.DISABLING || Kingdoms.taskScheduler().isShutdown();
    }

    private RunnableFuture<Void> runThreadedComponents(TaskThreadType taskThreadType, List<? extends VisualComponent> components, Consumer<VisualComponent> run) {
        if (!((Collection)components).isEmpty()) {
            FutureTask<Object> future = new FutureTask<Object>(() -> Visualizer.runThreadedComponents$lambda$17(components, this, run), null);
            TaskScheduleProvider taskScheduleProvider = Kingdoms.taskScheduler();
            Intrinsics.checkNotNull((Object)taskScheduleProvider, (String)"null cannot be cast to non-null type org.kingdoms.scheduler.AbstractJavaScheduler");
            ((AbstractJavaScheduler)taskScheduleProvider).shutdownHook((Future)future);
            Kingdoms.taskScheduler().run(taskThreadType, future);
            return future;
        }
        return null;
    }

    private static void addComponent$lambda$2(Visualizer this$0, VisualComponent $component) {
        Iterable $this$forEach$iv = this$0.getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            $component.onPlayerAdd(it);
        }
        if (this$0.getState() == VisualComponent.State.STARTED && $component.getState() != VisualComponent.State.STARTED) {
            $component.start();
        }
    }

    private static void addComponent$lambda$3(VisualComponent $component, FutureTask $future) {
        Kingdoms.taskScheduler().run($component.getTaskThreadType(), $future);
        $future.get();
    }

    private static void removeComponent$lambda$5$lambda$4(VisualComponent $component) {
        $component.stop();
    }

    private static void removeComponent$lambda$5(VisualComponent $component) {
        FutureTask<Object> future = new FutureTask<Object>(() -> Visualizer.removeComponent$lambda$5$lambda$4($component), null);
        Kingdoms.taskScheduler().run($component.getTaskThreadType(), future);
        future.get();
    }

    private static void onPlayerAdd$lambda$6(Player $player, VisualComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.onPlayerAdd($player);
    }

    private static void onPlayerRemove$lambda$7(Player $player, VisualComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.onPlayerRemove($player);
    }

    private static void clearVisualComponents$lambda$9$lambda$8(VisualComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.close();
    }

    private static void clearVisualComponents$lambda$9(Visualizer this$0) {
        if (this$0.getState() == VisualComponent.State.STARTED) {
            this$0.runThreadedComponents(Visualizer::clearVisualComponents$lambda$9$lambda$8);
        }
        this$0.getComponents().clear();
    }

    private static void start$lambda$11$lambda$10(VisualComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.start();
    }

    private static void start$lambda$11(Visualizer this$0) {
        VisualComponent.super.start();
        this$0.runThreadedComponents(Visualizer::start$lambda$11$lambda$10);
    }

    private static void stop$lambda$13$lambda$12(VisualComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.stop();
    }

    private static void stop$lambda$13(Visualizer this$0) {
        VisualComponent.super.stop();
        this$0.runThreadedComponents(Visualizer::stop$lambda$13$lambda$12);
    }

    private static void close$lambda$15$lambda$14(VisualComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.close();
    }

    private static void close$lambda$15(Visualizer this$0) {
        if (this$0.getState() == VisualComponent.State.STARTED) {
            VisualComponent.super.close();
            this$0.getVisibilityStrategy().close();
            this$0.runThreadedComponents(Visualizer::close$lambda$15$lambda$14);
        }
    }

    private static void runThreadedComponents$lambda$16(Visualizer this$0, List $async, Consumer $run, List $sync) {
        block1: {
            RunnableFuture<Void> syncs;
            RunnableFuture<Void> asyncs = this$0.runThreadedComponents(TaskThreadType.ASYNC, $async, $run);
            RunnableFuture<Void> runnableFuture = syncs = this$0.runThreadedComponents(TaskThreadType.SYNC, $sync, $run);
            if (runnableFuture != null) {
                Void cfr_ignored_0 = (Void)runnableFuture.get();
            }
            RunnableFuture<Void> runnableFuture2 = asyncs;
            if (runnableFuture2 == null) break block1;
            Void cfr_ignored_1 = (Void)runnableFuture2.get();
        }
    }

    private static void runThreadedComponents$lambda$17(List $components, Visualizer this$0, Consumer $run) {
        for (VisualComponent component : $components) {
            if (this$0.shouldStopTasks()) {
                return;
            }
            $run.accept(component);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TaskThreadType.values().length];
            try {
                nArray[TaskThreadType.ANY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskThreadType.SYNC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskThreadType.ASYNC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

