/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.visualizer;

import java.awt.Color;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.building.SimpleBlockRegion;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.sequences.Sequence;
import org.kingdoms.libs.kotlin.sequences.SequencesKt;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.platform.bukkit.channel.BlockMarker;
import org.kingdoms.platform.bukkit.channel.BlockMarkerPluginChannel;
import org.kingdoms.platform.bukkit.channel.PluginChannels;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.display.components.BlockMarkerVisualComponent;
import org.kingdoms.utils.display.components.EntityVisualComponent;
import org.kingdoms.utils.display.components.FakeBlockVisualComponent;
import org.kingdoms.utils.display.components.ParticleVisualComponent;
import org.kingdoms.utils.display.models.EntityVisualModel;
import org.kingdoms.utils.display.models.StructureVisualModel;
import org.kingdoms.utils.display.visualizer.PreviewBlockInfo;
import org.kingdoms.utils.display.visualizer.TemporaryVisualizer;
import org.kingdoms.utils.display.visualizer.Visualizer;
import org.kingdoms.utils.display.visualizer.visibility.ManualVisibilityStrategy;
import org.kingdoms.utils.versionsupport.VersionSupport;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0002+,B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\u0016\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u001fJ\u0006\u0010'\u001a\u00020\u001fJ\u0006\u0010(\u001a\u00020\u001fJ\b\u0010)\u001a\u00020\u001fH\u0016J\b\u0010*\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/kingdoms/utils/display/visualizer/StructureVisualizer;", "Lorg/kingdoms/utils/display/visualizer/TemporaryVisualizer;", "namespace", "Lorg/kingdoms/constants/namespace/Namespace;", "viewer", "Lorg/bukkit/entity/Player;", "blocks", "", "Lorg/kingdoms/server/location/BlockVector3;", "duration", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/constants/namespace/Namespace;Lorg/bukkit/entity/Player;Ljava/util/Set;Ljava/time/Duration;)V", "world", "Lorg/kingdoms/server/location/World;", "getWorld", "()Lorg/kingdoms/server/location/World;", "", "Lorg/kingdoms/utils/display/visualizer/PreviewBlockInfo;", "getBlocks", "()Ljava/util/Map;", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "min", "Lorg/bukkit/Location;", "max", "spawnParticles", "", "display", "Lorg/kingdoms/libs/xseries/particles/ParticleDisplay;", "spawnParticles$core", "add", "block", "blockData", "particles", "blockMarkers", "displayBlocks", "start", "stop", "StructureEntityModel", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStructureVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureVisualizer.kt\norg/kingdoms/utils/display/visualizer/StructureVisualizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,142:1\n1293#2,4:143\n662#3:147\n743#3,4:148\n662#3:152\n743#3,4:153\n381#4,7:157\n*S KotlinDebug\n*F\n+ 1 StructureVisualizer.kt\norg/kingdoms/utils/display/visualizer/StructureVisualizer\n*L\n39#1:143,4\n68#1:147\n68#1:148,4\n86#1:152\n86#1:153,4\n95#1:157,7\n*E\n"})
public class StructureVisualizer
extends TemporaryVisualizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Namespace namespace;
    @NotNull
    private final Player viewer;
    @NotNull
    private final org.kingdoms.server.location.World world;
    @NotNull
    private final Map<BlockVector3, PreviewBlockInfo> blocks;
    @NotNull
    private Color color;
    @NotNull
    private final Location min;
    @NotNull
    private final Location max;
    @JvmField
    @NotNull
    public static final Namespace MAIN_NS;
    public static final short MAIN_PRIORITY = 30000;
    @JvmField
    @NotNull
    public static final BiCooldown<UUID, Namespace> LAST_PREVIEW;
    @NotNull
    private static final Map<UUID, NamespacedMap<Visualizer>> PREVIEWS;

    /*
     * WARNING - void declaration
     */
    public StructureVisualizer(@NotNull Namespace namespace, @NotNull Player viewer, @NotNull Set<BlockVector3> blocks, @NotNull Duration duration) {
        void destination$iv;
        void $this$associateWithTo$iv;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        super(new ManualVisibilityStrategy(), duration, new MessagePlaceholderProvider());
        this.namespace = namespace;
        this.viewer = viewer;
        World world = this.viewer.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        this.world = BukkitAdapter.adapt(world);
        Iterable iterable = blocks;
        Map map = new HashMap();
        StructureVisualizer structureVisualizer = this;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            BlockVector3 blockVector3 = (BlockVector3)element$iv;
            Object t = element$iv;
            void var13_13 = destination$iv;
            boolean bl = false;
            Object v = null;
            var13_13.put(t, v);
        }
        structureVisualizer.blocks = destination$iv;
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
        this.color = color;
        SimpleBlockRegion region = new SimpleBlockRegion(blocks);
        this.min = BukkitAdapter.adapt(region.getMinimumPoint().inWorld(this.world));
        Location location = BukkitAdapter.adapt(region.getMaximumPoint().toVector().add(1.1, 1.0, 1.0).inWorld(this.world));
        Intrinsics.checkNotNull((Object)location);
        this.max = location;
    }

    @NotNull
    public final org.kingdoms.server.location.World getWorld() {
        return this.world;
    }

    @NotNull
    public final Map<BlockVector3, PreviewBlockInfo> getBlocks() {
        return this.blocks;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.color = color;
    }

    public void spawnParticles$core(@NotNull ParticleDisplay display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Particles.structuredCube((Location)this.min, (Location)this.max, (double)0.1, (ParticleDisplay)display);
    }

    public final void add(@NotNull BlockVector3 block, @NotNull PreviewBlockInfo blockData) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockData, (String)"blockData");
        this.blocks.put(block, blockData);
    }

    public final void particles() {
        ParticleDisplay particleDisplay = ParticleDisplay.of((XParticle)XParticle.DUST).withColor(this.color, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)particleDisplay, (String)"withColor(...)");
        ParticleDisplay display = particleDisplay;
        Visualizer visualizer = this;
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        this.addComponent(new ParticleVisualComponent(visualizer, duration, display, this::spawnParticles$core));
    }

    /*
     * WARNING - void declaration
     */
    public final void blockMarkers() {
        Map map;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        if (!PluginChannels.isSupported()) {
            return;
        }
        Sequence sequence = MapsKt.asSequence(this.blocks);
        Visualizer visualizer = this;
        StructureVisualizer structureVisualizer = this;
        boolean $i$f$associate = false;
        void var3_5 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Duration duration = this.getDuration();
            Object object = (PreviewBlockInfo)it.getValue();
            if (object == null || (object = ((PreviewBlockInfo)object).getColor()) == null) {
                object = this.color;
            }
            Pair pair = TuplesKt.to(k, (Object)new BlockMarker(duration, (Color)object, ""));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = map = destination$iv$iv;
        BlockMarkerPluginChannel blockMarkerPluginChannel = new BlockMarkerPluginChannel(map3);
        Visualizer visualizer2 = visualizer;
        structureVisualizer.addComponent(new BlockMarkerVisualComponent(visualizer2, blockMarkerPluginChannel));
    }

    /*
     * WARNING - void declaration
     */
    public final void displayBlocks() {
        if (VersionSupport.SUPPORTS_BLOCK_DISPLAYS) {
            this.addComponent(new StructureEntityModel());
        } else {
            Map map;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Sequence sequence = SequencesKt.filter((Sequence)MapsKt.asSequence(this.blocks), StructureVisualizer::displayBlocks$lambda$2);
            Visualizer visualizer = this;
            StructureVisualizer structureVisualizer = this;
            boolean $i$f$associate = false;
            void var3_5 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Object v = it.getValue();
                Intrinsics.checkNotNull(v);
                Pair pair = TuplesKt.to(k, (Object)((PreviewBlockInfo)v).getInfo());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = map = destination$iv$iv;
            Visualizer visualizer2 = visualizer;
            structureVisualizer.addComponent(new FakeBlockVisualComponent(visualizer2, map3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        Object object;
        void $this$getOrPut$iv;
        this.getVisibilityStrategy().showTo(this.viewer, MAIN_NS, (short)30000);
        Map<UUID, NamespacedMap<Visualizer>> map = PREVIEWS;
        UUID key$iv = this.viewer.getUniqueId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            NamespacedMap answer$iv = new NamespacedMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        NamespacedMap previews = (NamespacedMap)object;
        Visualizer visualizer = (Visualizer)previews.remove(this.namespace);
        if (visualizer != null) {
            visualizer.close();
        }
        super.start();
        ((Map)previews).put(this.namespace, this);
        LAST_PREVIEW.add(this.viewer.getUniqueId(), this.namespace, this.getDuration().plus(Duration.ofSeconds(30L)));
    }

    @Override
    public void stop() {
        block0: {
            super.stop();
            NamespacedMap<Visualizer> namespacedMap = PREVIEWS.get(this.viewer.getUniqueId());
            if (namespacedMap == null) break block0;
            namespacedMap.remove(this.namespace);
        }
    }

    private static final boolean displayBlocks$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PreviewBlockInfo previewBlockInfo = (PreviewBlockInfo)it.getValue();
        return (previewBlockInfo != null ? previewBlockInfo.getInfo() : null) != null;
    }

    @JvmStatic
    @Nullable
    public static final Visualizer get(@NotNull Player player, @NotNull Namespace namespace) {
        return Companion.get(player, namespace);
    }

    @JvmStatic
    public static final void stop(@NotNull Player player, @NotNull Namespace namespace) {
        Companion.stop(player, namespace);
    }

    static {
        Namespace namespace = Namespace.kingdoms("MAIN");
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
        MAIN_NS = namespace;
        LAST_PREVIEW = new BiCooldown();
        PREVIEWS = new HashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0007R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/utils/display/visualizer/StructureVisualizer$Companion;", "", "<init>", "()V", "MAIN_NS", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "MAIN_PRIORITY", "", "LAST_PREVIEW", "Lorg/kingdoms/utils/cooldown/BiCooldown;", "Ljava/util/UUID;", "PREVIEWS", "", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "getPREVIEWS$annotations", "get", "player", "Lorg/bukkit/entity/Player;", "namespace", "stop", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getPREVIEWS$annotations() {
        }

        @JvmStatic
        @Nullable
        public final Visualizer get(@NotNull Player player, @NotNull Namespace namespace) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            NamespacedMap namespacedMap = (NamespacedMap)PREVIEWS.get(player.getUniqueId());
            return namespacedMap != null ? (Visualizer)namespacedMap.get(namespace) : null;
        }

        @JvmStatic
        public final void stop(@NotNull Player player, @NotNull Namespace namespace) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                Object object = (NamespacedMap)PREVIEWS.get(player.getUniqueId());
                if (object == null || (object = (Visualizer)((NamespacedMap)object).remove(namespace)) == null) break block0;
                object.close();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/display/visualizer/StructureVisualizer$StructureEntityModel;", "Lorg/kingdoms/utils/display/components/EntityVisualComponent;", "Lorg/kingdoms/utils/display/models/StructureVisualModel;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/StructureVisualizer;)V", "createModel", "", "player", "Lorg/bukkit/entity/Player;", "createModel$core", "update", "", "core"})
    @SourceDebugExtension(value={"SMAP\nStructureVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureVisualizer.kt\norg/kingdoms/utils/display/visualizer/StructureVisualizer$StructureEntityModel\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,142:1\n662#2:143\n743#2,4:144\n*S KotlinDebug\n*F\n+ 1 StructureVisualizer.kt\norg/kingdoms/utils/display/visualizer/StructureVisualizer$StructureEntityModel\n*L\n115#1:143\n115#1:144,4\n*E\n"})
    private final class StructureEntityModel
    extends EntityVisualComponent<StructureVisualModel> {
        public StructureEntityModel() {
            super(TaskThreadType.SYNC, StructureVisualizer.this, StructureVisualizer.this.getDuration());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<StructureVisualModel> createModel$core(@NotNull Player player) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Object object = SequencesKt.filter((Sequence)MapsKt.asSequence(StructureVisualizer.this.getBlocks()), StructureEntityModel::createModel$lambda$0);
            StructureVisualizer structureVisualizer = StructureVisualizer.this;
            boolean $i$f$associate = false;
            Object[] objectArray = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Location location = BukkitAdapter.adapt(((BlockVector3)it.getKey()).inWorld(structureVisualizer.getWorld()));
                Object v = it.getValue();
                Intrinsics.checkNotNull(v);
                Pair pair = TuplesKt.to((Object)location, (Object)((PreviewBlockInfo)v).getInfo());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            Object $this$createModel_u24lambda_u242 = object = new StructureVisualModel(map);
            boolean bl = false;
            objectArray = new UUID[]{player.getUniqueId()};
            ((EntityVisualModel)$this$createModel_u24lambda_u242).visibleTo(SetsKt.hashSetOf((Object[])objectArray));
            org.kingdoms.server.location.Location location = BukkitAdapter.adapt(player.getLocation());
            Intrinsics.checkNotNull((Object)location);
            ((StructureVisualModel)$this$createModel_u24lambda_u242).spawn(location, this.getVisualizer().getMessageContext());
            return CollectionsKt.listOf((Object)object);
        }

        @Override
        public void update() {
        }

        private static final boolean createModel$lambda$0(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PreviewBlockInfo previewBlockInfo = (PreviewBlockInfo)it.getValue();
            return (previewBlockInfo != null ? previewBlockInfo.getInfo() : null) != null;
        }
    }
}

