/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.scoreboard;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

public class XScoreboard
implements Namespaced {
    private static final char[] COLORS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'c', 'd', 'f', 'r'};
    private static final boolean SUPPORTS_INFINITE_LENGTH = XReflection.supports((int)9);
    private static final boolean SUPPORTS_CRITERIA;
    private final Namespace id;
    private final Messenger title;
    private boolean lineNumberAsScore = true;
    private final List<Line> lines = new CopyOnWriteArrayList<Line>();
    private MessagePlaceholderProvider settings;
    private String alignRight = "";
    private final Cache<UUID, Scoreboard> previousScoreboard = CacheHandler.newBuilder().weakValues().build();
    private final Map<UUID, LocalScoreboard> scoreboards = new ConcurrentHashMap<UUID, LocalScoreboard>();

    public XScoreboard(Namespace id, Messenger title, MessagePlaceholderProvider settings) {
        this.id = id;
        this.title = title;
        this.settings = settings;
    }

    public void update(MessagePlaceholderProvider settings) {
        this.settings = settings;
        for (Map.Entry<UUID, LocalScoreboard> uoj : this.scoreboards.entrySet()) {
            LocalScoreboard scoreboard = uoj.getValue();
            scoreboard.clear();
            Language locale = LanguageManager.localeOf(uoj.getKey());
            scoreboard.objective.setDisplayName(this.title.parse(locale, settings));
            this.buildLines(scoreboard, locale);
        }
    }

    public void setAlignRight(String alignRight) {
        this.alignRight = Objects.requireNonNull(alignRight);
    }

    public void addPlayer(Player player) {
        String id = this.id.asNormalizedString();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Language locale = LanguageManager.localeOf(player);
        String titleStr = this.title.parse(locale, this.settings);
        Objective mainObjective = SUPPORTS_CRITERIA ? scoreboard.registerNewObjective(id, Criteria.DUMMY, titleStr) : scoreboard.registerNewObjective(id, titleStr);
        mainObjective.setDisplaySlot(DisplaySlot.SIDEBAR);
        LocalScoreboard localScoreboard = new LocalScoreboard(mainObjective);
        this.buildLines(localScoreboard, locale);
        Scoreboard current = player.getScoreboard();
        player.setScoreboard(scoreboard);
        this.scoreboards.put(player.getUniqueId(), localScoreboard);
        this.previousScoreboard.put((Object)player.getUniqueId(), (Object)current);
    }

    public void removePlayer(Player player) {
        Scoreboard previous = (Scoreboard)this.previousScoreboard.getIfPresent((Object)player.getUniqueId());
        if (previous == null) {
            return;
        }
        this.previousScoreboard.invalidate((Object)player.getUniqueId());
        LocalScoreboard currentTracked = this.scoreboards.remove(player.getUniqueId());
        Scoreboard current = player.getScoreboard();
        if (currentTracked != null && current != currentTracked.objective.getScoreboard()) {
            return;
        }
        player.setScoreboard(previous);
    }

    public void removeAll() {
        for (UUID playerId : this.scoreboards.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            this.removePlayer(player);
        }
        this.scoreboards.clear();
        this.previousScoreboard.invalidateAll();
    }

    public Line addLine(Messenger obj, MessagePlaceholderProvider context) {
        if (this.lines.size() >= 15) {
            throw new IllegalStateException("Scoreboards cannot have more than 15 lines");
        }
        Line line = new Line(obj).withContext(context);
        this.lines.add(line);
        return line;
    }

    public Line addLine(Messenger obj) {
        return this.addLine(obj, null);
    }

    public void clearAll() {
        this.lines.clear();
        for (LocalScoreboard scoreboard : this.scoreboards.values()) {
            scoreboard.clear();
        }
    }

    private void buildLines(LocalScoreboard scoreboard, Language locale) {
        int linePosition = this.lines.size();
        Objective objective = scoreboard.objective;
        for (Line line : this.lines) {
            this.buildLine(scoreboard, locale, line, objective, linePosition--);
        }
    }

    private void buildLine(LocalScoreboard scoreboard, Language locale, Line line, Objective objective, int linePosition) {
        String translatedLine = this.alignRight + line.text.parse(locale, line.context == null ? this.settings : line.context);
        Score score = objective.getScore(XScoreboard.lengthCheckedLine(translatedLine));
        int duplicateResolverIndex = 0;
        while (score.isScoreSet()) {
            String sanitizedLine = "\u00a7" + COLORS[duplicateResolverIndex++] + translatedLine;
            score = objective.getScore(XScoreboard.lengthCheckedLine(sanitizedLine));
        }
        score.setScore(this.lineNumberAsScore ? linePosition : line.score);
        scoreboard.registerLine(line, score);
    }

    public XScoreboard useLineNumberAsScore(boolean lineNumberAsScore) {
        this.lineNumberAsScore = lineNumberAsScore;
        return this;
    }

    public Cache<UUID, Scoreboard> getPreviousScoreboards() {
        return this.previousScoreboard;
    }

    private static String lengthCheckedLine(String str) {
        return !XReflection.supports((int)13) && str.length() > 40 ? str.substring(0, 40) : str;
    }

    public String toString() {
        return "XScoreboard[" + this.id.asString() + ", " + this.title + ", lines=" + this.lines.size() + ']';
    }

    @Override
    public @NonNull Namespace getNamespace() {
        return this.id;
    }

    static {
        boolean criteria = false;
        try {
            Class.forName("org.bukkit.scoreboard.Criteria");
            criteria = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SUPPORTS_CRITERIA = criteria;
    }

    private static final class LocalScoreboard {
        private final Objective objective;
        private final Map<Line, Score> scores = new IdentityHashMap<Line, Score>();

        private LocalScoreboard(Objective objective) {
            this.objective = objective;
        }

        private void clear() {
            Scoreboard scoreboard = this.objective.getScoreboard();
            for (String entry : scoreboard.getEntries()) {
                scoreboard.resetScores(entry);
            }
            this.scores.clear();
        }

        private void registerLine(Line line, Score score) {
            this.scores.put(line, score);
        }
    }

    public final class Line {
        private final Messenger text;
        private MessagePlaceholderProvider context;
        private int score;

        public Line(Messenger text) {
            this.text = text;
        }

        public Line withContext(MessagePlaceholderProvider context) {
            this.context = context;
            return this;
        }

        public void setScore(int score) {
            this.score = score;
            for (LocalScoreboard scoreboard : XScoreboard.this.scoreboards.values()) {
                Score matched = (Score)scoreboard.scores.get(this);
                Objects.requireNonNull(matched, () -> "No line match found for " + this.text);
                matched.setScore(score);
            }
        }

        public int getScore() {
            return this.score;
        }
    }
}

