/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.display.models.EntityModelState;
import org.kingdoms.utils.display.models.HologramVisualModel;
import org.kingdoms.utils.nms.EntityFactory;
import org.kingdoms.utils.nms.FakeArmorStand;
import org.kingdoms.utils.nms.HologramFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001 B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000eH\u0014J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/kingdoms/utils/display/models/ArmorStandEntityVisualModel;", "Lorg/kingdoms/utils/display/models/HologramVisualModel;", "holograms", "", "Lorg/kingdoms/managers/holograms/GroupedHologram;", "<init>", "(Ljava/util/Collection;)V", "activeHolograms", "", "Lorg/kingdoms/utils/display/models/ArmorStandEntityVisualModel$SpawnedHologram;", "getActiveHolograms", "()Ljava/util/List;", "entities", "", "Lorg/bukkit/entity/Entity;", "getEntities", "remove", "", "update", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "initials", "entity", "addPlayer", "player", "Lorg/bukkit/entity/Player;", "removePlayer", "spawn", "origin", "Lorg/kingdoms/server/location/Location;", "createPackets", "showTo", "SpawnedHologram", "core"})
@SourceDebugExtension(value={"SMAP\nEntityVisualModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityVisualModel.kt\norg/kingdoms/utils/display/models/ArmorStandEntityVisualModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1368#2:312\n1454#2,2:313\n1557#2:315\n1628#2,3:316\n1456#2,3:319\n1557#2:322\n1628#2,3:323\n1557#2:326\n1628#2,3:327\n1368#2:330\n1454#2,2:331\n1557#2:333\n1628#2,3:334\n1456#2,3:337\n*S KotlinDebug\n*F\n+ 1 EntityVisualModel.kt\norg/kingdoms/utils/display/models/ArmorStandEntityVisualModel\n*L\n226#1:312\n226#1:313,2\n226#1:315\n226#1:316,3\n226#1:319,3\n231#1:322\n231#1:323,3\n271#1:326\n271#1:327,3\n307#1:330\n307#1:331,2\n307#1:333\n307#1:334,3\n307#1:337,3\n*E\n"})
public final class ArmorStandEntityVisualModel
extends HologramVisualModel {
    @NotNull
    private final List<SpawnedHologram> activeHolograms;

    public ArmorStandEntityVisualModel(@NotNull Collection<GroupedHologram> holograms) {
        Intrinsics.checkNotNullParameter(holograms, (String)"holograms");
        super(holograms);
        this.activeHolograms = new ArrayList();
    }

    @NotNull
    public final List<SpawnedHologram> getActiveHolograms() {
        return this.activeHolograms;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Entity> getEntities() {
        void $this$flatMapTo$iv$iv;
        this.ensure(EntityModelState.SPAWNED);
        Iterable $this$flatMap$iv = this.activeHolograms;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            SpawnedHologram it = (SpawnedHologram)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getEntity();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(((FakeArmorStand)x.getFirst()).getEntity());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.ensure(EntityModelState.SPAWNED);
        Iterable iterable = this.getEntities();
        Collection collection = this.getOnlineVisitors();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity2 = (Entity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getEntityId());
        }
        EntityFactory.removeEntity(collection, (List)destination$iv$iv);
        this.activeHolograms.clear();
        this.setState(EntityModelState.REMOVED);
    }

    @Override
    public void update(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensure(EntityModelState.SPAWNED);
        List entitiesToUpdate = new ArrayList();
        for (SpawnedHologram activeHologram : this.activeHolograms) {
            for (Pair<FakeArmorStand, Messenger> pair : activeHologram.getEntity()) {
                FakeArmorStand entity2 = (FakeArmorStand)pair.component1();
                Messenger msg = (Messenger)pair.component2();
                String parsed = msg.parse(context);
                if (Intrinsics.areEqual((Object)entity2.getEntity().getCustomName(), (Object)parsed)) continue;
                entity2.getEntity().setCustomName(parsed);
                entitiesToUpdate.add(entity2);
            }
        }
        HologramFactory.updateHolograms((Collection<? extends Player>)this.getOnlineVisitors(), entitiesToUpdate);
    }

    @Override
    protected void initials(@NotNull Entity entity2) {
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        super.initials(entity2);
        ArmorStand it = (ArmorStand)entity2;
        boolean bl = false;
        it.setCustomNameVisible(true);
        it.setMarker(true);
        it.setVisible(false);
    }

    @Override
    public void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.addPlayer(player);
        Location location = BukkitAdapter.adapt(((Entity)CollectionsKt.first(this.getEntities())).getLocation());
        Intrinsics.checkNotNull((Object)location);
        MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider();
        Set<Player> set = Collections.singleton(player);
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        this.spawn(location, messagePlaceholderProvider, (Collection<? extends Player>)set);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removePlayer(@NotNull Player player) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.removePlayer(player);
        Iterable iterable = this.getEntities();
        Collection collection = Collections.singleton(player);
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entity entity2 = (Entity)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getEntityId());
        }
        EntityFactory.removeEntity(collection, (List)destination$iv$iv);
    }

    @Override
    public void spawn(@NotNull Location origin, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.spawn(origin, context, (Collection<? extends Player>)this.getOnlineVisitors());
    }

    public final void createPackets(@NotNull Location origin, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (GroupedHologram hologram : this.getHolograms()) {
            Location currentOffset = origin;
            List lines = new ArrayList();
            currentOffset = currentOffset.add(hologram.getOffset());
            Messenger rawMessage = hologram.getHologram().getSettings().getMessage();
            MessageObject messageObject = rawMessage.getMessageObject(context.getLanguage());
            Intrinsics.checkNotNull((Object)messageObject);
            List<MessageObject> objLines = messageObject.splitLines();
            for (MessageObject line : objLines) {
                org.bukkit.Location bukkitLoc;
                currentOffset = currentOffset.add(0, -0.23, 0);
                StaticMessenger msg = new StaticMessenger(line);
                Intrinsics.checkNotNull((Object)BukkitAdapter.adapt(currentOffset));
                FakeArmorStand fakeEntity = HologramFactory.createHologram(bukkitLoc, arg_0 -> ArmorStandEntityVisualModel.createPackets$lambda$5(this, msg, context, arg_0));
                this.initials((Entity)fakeEntity.getEntity());
                lines.add(TuplesKt.to((Object)fakeEntity, (Object)msg));
            }
            this.activeHolograms.add(new SpawnedHologram(lines, hologram));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void spawn(@NotNull Location origin, @NotNull MessagePlaceholderProvider context, @NotNull Collection<? extends Player> showTo) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(showTo, (String)"showTo");
        this.ensure(EntityModelState.NOT_SPAWNED);
        if (this.activeHolograms.isEmpty()) {
            this.createPackets(origin, context);
        }
        Iterable iterable = this.activeHolograms;
        Collection<? extends Player> collection = showTo;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            SpawnedHologram it = (SpawnedHologram)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getEntity();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add((FakeArmorStand)x.getFirst());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        HologramFactory.spawn(collection, (List)destination$iv$iv);
        this.setState(EntityModelState.SPAWNED);
    }

    private static final void createPackets$lambda$5(ArmorStandEntityVisualModel this$0, StaticMessenger $msg, MessagePlaceholderProvider $context, ArmorStand it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.initials((Entity)it);
        it.setCustomName($msg.parse($context));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/display/models/ArmorStandEntityVisualModel$SpawnedHologram;", "", "entity", "", "Lorg/kingdoms/libs/kotlin/Pair;", "Lorg/kingdoms/utils/nms/FakeArmorStand;", "Lorg/kingdoms/locale/messenger/Messenger;", "group", "Lorg/kingdoms/managers/holograms/GroupedHologram;", "<init>", "(Ljava/util/List;Lorg/kingdoms/managers/holograms/GroupedHologram;)V", "getEntity", "()Ljava/util/List;", "getGroup", "()Lorg/kingdoms/managers/holograms/GroupedHologram;", "core"})
    public static final class SpawnedHologram {
        @NotNull
        private final List<Pair<FakeArmorStand, Messenger>> entity;
        @NotNull
        private final GroupedHologram group;

        public SpawnedHologram(@NotNull List<? extends Pair<FakeArmorStand, ? extends Messenger>> entity2, @NotNull GroupedHologram group) {
            Intrinsics.checkNotNullParameter(entity2, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            this.entity = entity2;
            this.group = group;
        }

        @NotNull
        public final List<Pair<FakeArmorStand, Messenger>> getEntity() {
            return this.entity;
        }

        @NotNull
        public final GroupedHologram getGroup() {
            return this.group;
        }
    }
}

