/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.AbstractVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H&J\b\u0010\u0019\u001a\u00020\u0016H\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "Lorg/kingdoms/utils/display/components/AbstractVisualComponent;", "taskThreadType", "Lorg/kingdoms/scheduler/TaskThreadType;", "updateThreadType", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/scheduler/TaskThreadType;Lorg/kingdoms/scheduler/TaskThreadType;Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;)V", "getUpdateThreadType", "()Lorg/kingdoms/scheduler/TaskThreadType;", "getUpdateInterval", "()Ljava/time/Duration;", "updateTask", "Lorg/kingdoms/scheduler/DelayedRepeatingTask;", "getUpdateTask", "()Lorg/kingdoms/scheduler/DelayedRepeatingTask;", "setUpdateTask", "(Lorg/kingdoms/scheduler/DelayedRepeatingTask;)V", "start", "", "update0", "update", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nVisualComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualComponent.kt\norg/kingdoms/utils/display/components/UpdatingVisualComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public abstract class UpdatingVisualComponent
extends AbstractVisualComponent {
    @NotNull
    private final TaskThreadType updateThreadType;
    @NotNull
    private final Duration updateInterval;
    @Nullable
    private DelayedRepeatingTask updateTask;

    public UpdatingVisualComponent(@NotNull TaskThreadType taskThreadType, @NotNull TaskThreadType updateThreadType, @NotNull Visualizer visualizer, @NotNull Duration updateInterval) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskThreadType), (String)"taskThreadType");
        Intrinsics.checkNotNullParameter((Object)((Object)updateThreadType), (String)"updateThreadType");
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        super(taskThreadType, visualizer);
        this.updateThreadType = updateThreadType;
        this.updateInterval = updateInterval;
    }

    @NotNull
    public final TaskThreadType getUpdateThreadType() {
        return this.updateThreadType;
    }

    @NotNull
    public final Duration getUpdateInterval() {
        return this.updateInterval;
    }

    @Nullable
    public final DelayedRepeatingTask getUpdateTask() {
        return this.updateTask;
    }

    public final void setUpdateTask(@Nullable DelayedRepeatingTask delayedRepeatingTask) {
        this.updateTask = delayedRepeatingTask;
    }

    @Override
    public void start() {
        super.start();
        if (!(this.updateTask == null)) {
            boolean $i$a$-require-UpdatingVisualComponent$start$32 = false;
            String $i$a$-require-UpdatingVisualComponent$start$32 = "Already started (" + this + ')';
            throw new IllegalArgumentException($i$a$-require-UpdatingVisualComponent$start$32.toString());
        }
        if (!this.updateInterval.isZero()) {
            if (!(!this.updateInterval.isNegative())) {
                boolean bl = false;
                String string = "Update interval is negative " + this.updateInterval + " for " + this;
                throw new IllegalArgumentException(string.toString());
            }
            TaskScheduler scheduler = this.updateThreadType != TaskThreadType.SYNC ? Kingdoms.taskScheduler().async() : Kingdoms.taskScheduler().sync();
            this.updateTask = scheduler.repeating(this.updateInterval, this.updateInterval, this::update0);
        }
    }

    private final void update0() {
        if (this.getState() != VisualComponent.State.STARTED) {
            return;
        }
        Set<UUID> set = this.getVisualizer().getVisibilityStrategy().getVisibleTo();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-visibleTo>(...)");
        if (!((Collection)set).isEmpty()) {
            this.update();
        }
    }

    public abstract void update();

    @Override
    @MustBeInvokedByOverriders
    public void stop() {
        super.stop();
        DelayedRepeatingTask delayedRepeatingTask = this.updateTask;
        if (delayedRepeatingTask != null) {
            delayedRepeatingTask.cancel();
        }
        this.updateTask = null;
    }
}

