/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import java.util.List;
import org.bukkit.entity.Player;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.UpdatingVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.scoreboard.XScoreboard;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/utils/display/components/ScoreboardVisualComponent;", "Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "id", "Lorg/kingdoms/constants/namespace/Namespace;", "title", "Lorg/kingdoms/locale/messenger/Messenger;", "lines", "", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/constants/namespace/Namespace;Lorg/kingdoms/locale/messenger/Messenger;Ljava/util/List;Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;)V", "scoreboard", "Lorg/kingdoms/utils/display/scoreboard/XScoreboard;", "start", "", "setScoreboardFor", "player", "Lorg/bukkit/entity/Player;", "removeScoreboardFrom", "onPlayerAdd", "onPlayerRemove", "update", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nMessageComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageComponents.kt\norg/kingdoms/utils/display/components/ScoreboardVisualComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2,2:148\n1863#2,2:150\n*S KotlinDebug\n*F\n+ 1 MessageComponents.kt\norg/kingdoms/utils/display/components/ScoreboardVisualComponent\n*L\n59#1:148,2\n64#1:150,2\n*E\n"})
public final class ScoreboardVisualComponent
extends UpdatingVisualComponent {
    @NotNull
    private final XScoreboard scoreboard;

    public ScoreboardVisualComponent(@NotNull Namespace id, @NotNull Messenger title, @NotNull List<? extends Messenger> lines, @NotNull Visualizer visualizer, @NotNull Duration updateInterval) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        super(TaskThreadType.SYNC, TaskThreadType.ASYNC, visualizer, updateInterval);
        this.scoreboard = new XScoreboard(id, title, visualizer.getMessageContext());
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Messenger it = (Messenger)element$iv;
            boolean bl = false;
            this.scoreboard.addLine(it);
        }
    }

    @Override
    public void start() {
        super.start();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.setScoreboardFor(it);
        }
    }

    public final void setScoreboardFor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.scoreboard.addPlayer(player);
    }

    public final void removeScoreboardFrom(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.scoreboard.removePlayer(player);
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.setScoreboardFor(player);
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.removeScoreboardFrom(player);
        }
    }

    @Override
    public void update() {
        this.scoreboard.update(this.getVisualizer().getMessageContext());
    }

    @Override
    public void stop() {
        super.stop();
        this.scoreboard.removeAll();
    }
}

