/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.display.components.EntityVisualComponent;
import org.kingdoms.utils.display.models.ArmorStandEntityVisualModel;
import org.kingdoms.utils.display.models.HologramVisualModel;
import org.kingdoms.utils.display.models.TextDisplayEntityVisualModel;
import org.kingdoms.utils.display.visualizer.Visualizer;
import org.kingdoms.utils.versionsupport.VersionSupport;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/utils/display/components/HologramModelVisualComponent;", "Lorg/kingdoms/utils/display/components/EntityVisualComponent;", "Lorg/kingdoms/utils/display/models/HologramVisualModel;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "origin", "Lorg/kingdoms/server/location/Location;", "groupedHolograms", "", "Lorg/kingdoms/managers/holograms/GroupedHologram;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;Lorg/kingdoms/server/location/Location;Ljava/util/Collection;)V", "getOrigin", "()Lorg/kingdoms/server/location/Location;", "getGroupedHolograms", "()Ljava/util/Collection;", "setGroupedHolograms", "(Ljava/util/Collection;)V", "createModel", "player", "Lorg/bukkit/entity/Player;", "createModel$core", "core"})
public final class HologramModelVisualComponent
extends EntityVisualComponent<HologramVisualModel> {
    @NotNull
    private final Location origin;
    @NotNull
    private Collection<GroupedHologram> groupedHolograms;

    public HologramModelVisualComponent(@NotNull Visualizer visualizer, @NotNull Duration updateInterval, @NotNull Location origin, @NotNull Collection<GroupedHologram> groupedHolograms) {
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(groupedHolograms, (String)"groupedHolograms");
        super(VersionSupport.SUPPORTS_TEXT_DISPLAYS ? TaskThreadType.SYNC : TaskThreadType.ANY, visualizer, updateInterval);
        this.origin = origin;
        this.groupedHolograms = groupedHolograms;
    }

    @NotNull
    public final Location getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Collection<GroupedHologram> getGroupedHolograms() {
        return this.groupedHolograms;
    }

    public final void setGroupedHolograms(@NotNull Collection<GroupedHologram> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.groupedHolograms = collection;
    }

    @Override
    @NotNull
    public Collection<HologramVisualModel> createModel$core(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HologramVisualModel model = VersionSupport.SUPPORTS_TEXT_DISPLAYS ? (HologramVisualModel)new TextDisplayEntityVisualModel(this.groupedHolograms) : (HologramVisualModel)new ArmorStandEntityVisualModel(this.groupedHolograms);
        Object[] objectArray = new UUID[]{player.getUniqueId()};
        model.visibleTo(SetsKt.hashSetOf((Object[])objectArray));
        model.spawn(this.origin, this.getVisualizer().getMessageContext());
        return CollectionsKt.listOf((Object)model);
    }
}

