/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.building.info.block.BlockInfo;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.display.components.AbstractVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/utils/display/components/FakeBlockVisualComponent;", "Lorg/kingdoms/utils/display/components/AbstractVisualComponent;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "blocks", "", "Lorg/kingdoms/server/location/BlockVector3;", "Lorg/kingdoms/constants/land/building/info/block/BlockInfo;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/util/Map;)V", "getBlocks", "()Ljava/util/Map;", "start", "", "sendBlockChange", "player", "Lorg/bukkit/entity/Player;", "show", "", "onPlayerAdd", "onPlayerRemove", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nBasicComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicComponents.kt\norg/kingdoms/utils/display/components/FakeBlockVisualComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1863#2,2:138\n1863#2,2:140\n*S KotlinDebug\n*F\n+ 1 BasicComponents.kt\norg/kingdoms/utils/display/components/FakeBlockVisualComponent\n*L\n109#1:138,2\n135#1:140,2\n*E\n"})
public class FakeBlockVisualComponent
extends AbstractVisualComponent {
    @NotNull
    private final Map<BlockVector3, BlockInfo> blocks;

    public FakeBlockVisualComponent(@NotNull Visualizer visualizer, @NotNull Map<BlockVector3, ? extends BlockInfo> blocks) {
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        super(TaskThreadType.ANY, visualizer);
        this.blocks = blocks;
    }

    @NotNull
    public final Map<BlockVector3, BlockInfo> getBlocks() {
        return this.blocks;
    }

    @Override
    public void start() {
        super.start();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.sendBlockChange(it, true);
        }
    }

    private final void sendBlockChange(Player player, boolean show) {
        for (Map.Entry<BlockVector3, BlockInfo> entry : this.blocks.entrySet()) {
            BlockVector3 loc = entry.getKey();
            BlockInfo info = entry.getValue();
            World world = player.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            BlockLocation3 location = loc.inWorld(BukkitAdapter.adapt(world));
            if (show) {
                info.sendBlockUpdate(location, player);
                continue;
            }
            PlayerUtils.sendBlockChange(player, BukkitAdapter.adapt(location).getBlock());
        }
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.sendBlockChange(player, true);
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.sendBlockChange(player, false);
        }
    }

    @Override
    public void stop() {
        super.stop();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.sendBlockChange(it, false);
        }
    }
}

