/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.UpdatingVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.models.EntityModelState;
import org.kingdoms.utils.display.models.EntityVisualModel;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H \u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016R#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/utils/display/components/EntityVisualComponent;", "E", "Lorg/kingdoms/utils/display/models/EntityVisualModel;", "Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "taskThreadType", "Lorg/kingdoms/scheduler/TaskThreadType;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/scheduler/TaskThreadType;Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;)V", "entities", "", "Ljava/util/UUID;", "", "getEntities", "()Ljava/util/Map;", "start", "", "spawnFor", "player", "Lorg/bukkit/entity/Player;", "createModel", "createModel$core", "onPlayerAdd", "onPlayerRemove", "update", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nEntityComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityComponents.kt\norg/kingdoms/utils/display/components/EntityVisualComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1863#2,2:85\n1863#2,2:87\n1863#2,2:89\n1863#2,2:91\n*S KotlinDebug\n*F\n+ 1 EntityComponents.kt\norg/kingdoms/utils/display/components/EntityVisualComponent\n*L\n24#1:85,2\n41#1:87,2\n48#1:89,2\n58#1:91,2\n*E\n"})
public abstract class EntityVisualComponent<E extends EntityVisualModel>
extends UpdatingVisualComponent {
    @NotNull
    private final Map<UUID, Collection<E>> entities;

    public EntityVisualComponent(@NotNull TaskThreadType taskThreadType, @NotNull Visualizer visualizer, @NotNull Duration updateInterval) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskThreadType), (String)"taskThreadType");
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        super(taskThreadType, TaskThreadType.ASYNC, visualizer, updateInterval);
        this.entities = new ConcurrentHashMap();
    }

    @NotNull
    public final Map<UUID, Collection<E>> getEntities() {
        return this.entities;
    }

    @Override
    public void start() {
        super.start();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.spawnFor(it);
        }
    }

    public final void spawnFor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.entities.put(player.getUniqueId(), this.createModel$core(player));
    }

    @NotNull
    public abstract Collection<E> createModel$core(@NotNull Player var1);

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.spawnFor(player);
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            super.onPlayerRemove(player);
            if (this.getState() != VisualComponent.State.STARTED) break block2;
            Collection<E> collection = this.entities.remove(player.getUniqueId());
            if (collection != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EntityVisualModel it = (EntityVisualModel)element$iv;
                    boolean bl = false;
                    it.remove();
                }
            }
        }
    }

    @Override
    public void update() {
        MessagePlaceholderProvider context = this.getVisualizer().getMessageContext();
        for (Collection<E> playerHolo : this.entities.values()) {
            Iterable $this$forEach$iv = playerHolo;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityVisualModel it = (EntityVisualModel)element$iv;
                boolean bl = false;
                if (it.getState() != EntityModelState.SPAWNED) continue;
                it.update(context);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        Iterable $this$forEach$iv = this.entities.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection group = (Collection)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = group;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                EntityVisualModel it = (EntityVisualModel)element$iv2;
                boolean bl2 = false;
                it.remove();
            }
        }
        this.entities.clear();
    }
}

