/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.bossbars.BossBarSession;
import org.kingdoms.utils.bossbars.BossBarSettings;
import org.kingdoms.utils.display.components.UpdatingVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/utils/display/components/BossBarVisualComponent;", "Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "settings", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "progressUpdater", "Ljava/util/function/Supplier;", "", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/utils/bossbars/BossBarSettings;Ljava/util/function/Supplier;Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;)V", "bossBars", "", "Ljava/util/UUID;", "Lorg/kingdoms/utils/bossbars/BossBarSession;", "start", "", "setFor", "player", "Lorg/bukkit/entity/Player;", "onPlayerAdd", "onPlayerRemove", "update", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nMessageComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageComponents.kt\norg/kingdoms/utils/display/components/BossBarVisualComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Nullability.kt\norg/kingdoms/utils/internal/nonnull/Nullability\n*L\n1#1,147:1\n1863#2,2:148\n17#3,2:150\n*S KotlinDebug\n*F\n+ 1 MessageComponents.kt\norg/kingdoms/utils/display/components/BossBarVisualComponent\n*L\n105#1:148,2\n126#1:150,2\n*E\n"})
public final class BossBarVisualComponent
extends UpdatingVisualComponent {
    @NotNull
    private final BossBarSettings settings;
    @NotNull
    private final Supplier<Double> progressUpdater;
    @NotNull
    private final Map<UUID, BossBarSession> bossBars;

    public BossBarVisualComponent(@NotNull BossBarSettings settings, @NotNull Supplier<Double> progressUpdater, @NotNull Visualizer visualizer, @NotNull Duration updateInterval) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(progressUpdater, (String)"progressUpdater");
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        super(TaskThreadType.SYNC, TaskThreadType.ASYNC, visualizer, updateInterval);
        this.settings = settings;
        this.progressUpdater = progressUpdater;
        this.bossBars = new ConcurrentHashMap();
    }

    @Override
    public void start() {
        super.start();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.setFor(it);
        }
    }

    private final void setFor(Player player) {
        BossBarSession bossBar = new BossBarSession(this.settings);
        bossBar.addPlayer(player);
        bossBar.updateTitle(this.getVisualizer().getMessageContext());
        if (this.bossBars.containsKey(player.getUniqueId())) {
            throw new IllegalArgumentException("BossBar already defined for " + player);
        }
        this.bossBars.put(player.getUniqueId(), bossBar);
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.setFor(player);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPlayerRemove(@NotNull Player player) {
        block2: {
            block1: {
                void var3_2;
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                super.onPlayerRemove(player);
                if (this.getState() != VisualComponent.State.STARTED) break block1;
                BossBarSession $this$assertNotNull$iv = this.bossBars.remove(player.getUniqueId());
                boolean $i$f$assertNotNull = false;
                if ($this$assertNotNull$iv == null) {
                    boolean bl = false;
                    String string = player + " didn't have a bossbar for " + this;
                    throw new NullPointerException(string);
                }
                BossBarSession bossBar = (BossBarSession)var3_2;
                bossBar.removeAll();
                break block2;
            }
            BossBarSession bossBarSession = this.bossBars.remove(player.getUniqueId());
            if (bossBarSession == null) break block2;
            bossBarSession.removeAll();
        }
    }

    @Override
    public void update() {
        for (BossBarSession bossBar : this.bossBars.values()) {
            Double d = this.progressUpdater.get();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
            bossBar.setProgress(((Number)d).doubleValue());
            bossBar.updateTitle(this.getVisualizer().getMessageContext());
        }
    }

    @Override
    public void stop() {
        super.stop();
        for (BossBarSession bossBar : this.bossBars.values()) {
            bossBar.removeAll();
        }
        this.bossBars.clear();
    }
}

