/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.platform.bukkit.channel.BlockMarkerPluginChannel;
import org.kingdoms.platform.bukkit.channel.PluginChannels;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.AbstractVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/display/components/BlockMarkerVisualComponent;", "Lorg/kingdoms/utils/display/components/AbstractVisualComponent;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "channel", "Lorg/kingdoms/platform/bukkit/channel/BlockMarkerPluginChannel;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/Visualizer;Lorg/kingdoms/platform/bukkit/channel/BlockMarkerPluginChannel;)V", "getChannel", "()Lorg/kingdoms/platform/bukkit/channel/BlockMarkerPluginChannel;", "singleton", "", "start", "", "onPlayerAdd", "player", "Lorg/bukkit/entity/Player;", "onPlayerRemove", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nBasicComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicComponents.kt\norg/kingdoms/utils/display/components/BlockMarkerVisualComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1863#2,2:138\n1863#2,2:140\n*S KotlinDebug\n*F\n+ 1 BasicComponents.kt\norg/kingdoms/utils/display/components/BlockMarkerVisualComponent\n*L\n82#1:138,2\n99#1:140,2\n*E\n"})
public class BlockMarkerVisualComponent
extends AbstractVisualComponent {
    @NotNull
    private final BlockMarkerPluginChannel channel;
    @NotNull
    private final Collection<BlockMarkerPluginChannel> singleton;

    public BlockMarkerVisualComponent(@NotNull Visualizer visualizer, @NotNull BlockMarkerPluginChannel channel) {
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(TaskThreadType.ANY, visualizer);
        this.channel = channel;
        Set<BlockMarkerPluginChannel> set = Collections.singleton(this.channel);
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        this.singleton = set;
    }

    @NotNull
    public final BlockMarkerPluginChannel getChannel() {
        return this.channel;
    }

    @Override
    public void start() {
        super.start();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            PluginChannels.sendBlockMarker(it, this.singleton);
        }
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            PluginChannels.sendBlockMarker(player, this.singleton);
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            PluginChannels.clearBlockMarkers(player, this.singleton);
        }
    }

    @Override
    public void stop() {
        super.stop();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            PluginChannels.clearBlockMarkers(it, this.singleton);
        }
    }
}

