/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.UpdatingVisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/utils/display/components/AudibleVisualComponent;", "Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "recordPlayer", "Lorg/kingdoms/libs/xseries/XSound$SoundPlayer;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;Lcom/cryptomorin/xseries/XSound$SoundPlayer;)V", "getRecordPlayer", "()Lcom/cryptomorin/xseries/XSound$SoundPlayer;", "onPlayerAdd", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerRemove", "update", "core"})
public class AudibleVisualComponent
extends UpdatingVisualComponent {
    @NotNull
    private final XSound.SoundPlayer recordPlayer;

    public AudibleVisualComponent(@NotNull Visualizer visualizer, @NotNull Duration updateInterval, @NotNull XSound.SoundPlayer recordPlayer) {
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        Intrinsics.checkNotNullParameter((Object)recordPlayer, (String)"recordPlayer");
        super(TaskThreadType.ANY, TaskThreadType.ASYNC, visualizer, updateInterval);
        this.recordPlayer = recordPlayer;
        this.recordPlayer.record.publicSound(false);
    }

    @NotNull
    public final XSound.SoundPlayer getRecordPlayer() {
        return this.recordPlayer;
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        this.recordPlayer.players.add(player.getUniqueId());
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        this.recordPlayer.players.remove(player.getUniqueId());
    }

    @Override
    public void update() {
        this.recordPlayer.play();
    }
}

