/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.messages.ActionBar;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.UpdatingVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/utils/display/components/ActionBarVisualComponent;", "Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "message", "Lorg/kingdoms/locale/messenger/Messenger;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/locale/messenger/Messenger;Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;)V", "getMessage", "()Lorg/kingdoms/locale/messenger/Messenger;", "send", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerAdd", "onPlayerRemove", "update", "stop", "core"})
@SourceDebugExtension(value={"SMAP\nMessageComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageComponents.kt\norg/kingdoms/utils/display/components/ActionBarVisualComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1863#2,2:148\n1863#2,2:150\n*S KotlinDebug\n*F\n+ 1 MessageComponents.kt\norg/kingdoms/utils/display/components/ActionBarVisualComponent\n*L\n39#1:148,2\n44#1:150,2\n*E\n"})
public final class ActionBarVisualComponent
extends UpdatingVisualComponent {
    @NotNull
    private final Messenger message;

    public ActionBarVisualComponent(@NotNull Messenger message, @NotNull Visualizer visualizer, @NotNull Duration updateInterval) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        super(TaskThreadType.ASYNC, TaskThreadType.ASYNC, visualizer, updateInterval);
        this.message = message;
    }

    @NotNull
    public final Messenger getMessage() {
        return this.message;
    }

    private final void send(Player player) {
        String msg = this.message.parse(this.getVisualizer().getMessageContext());
        ActionBar.sendActionBar((Player)player, (String)msg);
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            this.send(player);
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        if (this.getState() == VisualComponent.State.STARTED) {
            ActionBar.clearActionBar((Player)player);
        }
    }

    @Override
    public void update() {
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.send(it);
        }
    }

    @Override
    public void stop() {
        super.stop();
        Iterable $this$forEach$iv = this.getVisualizer().getVisibilityStrategy().getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            ActionBar.clearActionBar((Player)it);
        }
    }
}

