/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cooldown;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cooldown.CooldownContainer;

public final class EntityCooldown {
    public static boolean add(Entity entity2, String name, long time) {
        return EntityCooldown.add(entity2, name, time, TimeUnit.SECONDS);
    }

    public static boolean add(Entity entity2, String name, long time, TimeUnit timeUnit) {
        if (EntityCooldown.isInCooldown(entity2, name)) {
            return false;
        }
        entity2.setMetadata(name, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)new CooldownContainer(timeUnit.toMillis(time), System.currentTimeMillis())));
        return true;
    }

    public static boolean isInCooldown(Entity entity2, String name) {
        return EntityCooldown.getTimeLeft(entity2, name) != 0L;
    }

    public static void stop(Entity entity2, String name) {
        entity2.removeMetadata(name, (Plugin)Kingdoms.get());
    }

    public static CooldownContainer get(Entity entity2, String name) {
        List meta = entity2.getMetadata(name);
        if (meta.isEmpty()) {
            return null;
        }
        return (CooldownContainer)((MetadataValue)meta.get(0)).value();
    }

    public static long getTimeLeft(Entity entity2, String name) {
        CooldownContainer cooldown = EntityCooldown.get(entity2, name);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long difference = now - cooldown.start;
        if (difference >= cooldown.time) {
            EntityCooldown.stop(entity2, name);
            return 0L;
        }
        return cooldown.time - difference;
    }
}

