/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config;

import com.google.common.base.Enums;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.ValidationContext;
import org.kingdoms.libs.snakeyaml.validation.ValidationFailure;
import org.kingdoms.libs.xseries.XBiome;
import org.kingdoms.libs.xseries.XEnchantment;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeUtils;

public final class CustomConfigValidators {
    private static final Map<String, NodeValidator> VALIDATORS = new HashMap<String, NodeValidator>();
    public static final Tag MATH = new Tag("Math");
    public static final Tag MATERIAL = new Tag("Material");
    public static final Tag BIOME = new Tag("Biome");
    public static final Tag CONDITION = new Tag("Condition");
    public static final Tag ENCHANT = new Tag("Enchant");
    public static final Tag MATERIAL_MATCHER = new Tag("MaterialMatcher");
    public static final Tag STRING_MATCHER = new Tag("StringMatcher");
    public static final Tag REGEX = CustomConfigValidators.register("RegEx", new RegEx());
    public static final Tag NUMBER_MATCHER = CustomConfigValidators.register("NumberMatcher", new NumberMatcher());
    public static final Tag ITEM_MATCHER = new Tag("ItemMatcher");
    public static final Tag ITEM_STACK = new Tag("ItemStack");
    public static final Tag ENTITY = new Tag("Entity");
    public static final Tag ITEM_FLAG = new Tag("ItemFlag");
    public static final Tag WORLD = new Tag("World");
    public static final Tag KINGDOM_PERMISSION = new Tag("KingdomPermission");
    public static final Tag SOUND = new Tag("Sound");
    public static final Tag PERIOD = new Tag("Period");
    public static final Tag STRUCTURE_TYPE = new Tag("StructureType");
    public static final Tag TURRET_TYPE = new Tag("TurretType");
    public static final Tag TIME = CustomConfigValidators.register("Time", new Time());
    public static final Tag POTION = CustomConfigValidators.register("Potion", new Potion());
    public static final Tag POTION_EFFECT_TYPE = CustomConfigValidators.register("PotionEffectType", new PotionEffectType());
    public static final Tag MESSAGE_ENTRY = CustomConfigValidators.register("MessageEntry", new MessageEntry());
    public static final Tag MESSAGE = CustomConfigValidators.register("Message", new Message());
    public static final Tag PERMISSION = CustomConfigValidators.register("Permission", new Permission());
    public static final Tag CLASS = CustomConfigValidators.register("Class", new Class());
    public static final Tag PARTICLE = CustomConfigValidators.register("Particle", new Particle());
    private static final NodeValidator PERMISSION_VALIDATOR;
    private static final NodeValidator ITEM_STACK_VALIDATOR;
    private static final NodeValidator ITEM_MATCHER_VALIDATOR;
    private static final NodeValidator ENTITY_VALIDATOR;

    private CustomConfigValidators() {
    }

    public static Map<String, NodeValidator> getValidators() {
        return VALIDATORS;
    }

    public static Tag register(String name, NodeValidator validator) {
        Tag tag = new Tag(name);
        VALIDATORS.put(name, validator);
        return tag;
    }

    private static ValidationFailure expectString(ValidationContext context, String name) {
        Tag tag = context.getNode().getTag();
        if (tag != Tag.STR) {
            return context.err("Expected a " + name + ", instead got: " + tag);
        }
        return null;
    }

    static {
        VALIDATORS.put(MATH.getValue(), new Math());
        VALIDATORS.put(MATERIAL.getValue(), new Material());
        VALIDATORS.put(ENTITY.getValue(), new Entity());
        VALIDATORS.put(BIOME.getValue(), new Biome());
        VALIDATORS.put(CONDITION.getValue(), new Condition());
        VALIDATORS.put(STRING_MATCHER.getValue(), new StringMatcher());
        VALIDATORS.put(MATERIAL_MATCHER.getValue(), new MaterialMatcher());
        VALIDATORS.put(KINGDOM_PERMISSION.getValue(), new KingdomPermission());
        VALIDATORS.put(SOUND.getValue(), new Sound());
        VALIDATORS.put(PERIOD.getValue(), new Period());
        VALIDATORS.put(ENCHANT.getValue(), new Enchant());
        VALIDATORS.put(ITEM_STACK.getValue(), new ItemStack());
        VALIDATORS.put(ITEM_MATCHER.getValue(), new ItemMatcher());
        VALIDATORS.put(ITEM_FLAG.getValue(), new ItemFlag());
        VALIDATORS.put(WORLD.getValue(), new World());
        VALIDATORS.put(STRUCTURE_TYPE.getValue(), new StructureType());
        VALIDATORS.put(TURRET_TYPE.getValue(), new TurretType());
        PERMISSION_VALIDATOR = YamlContainer.parseValidator("Item Stack", "schemas/permission.yml");
        ITEM_STACK_VALIDATOR = YamlContainer.parseValidator("Item Stack", "schemas/item-stack.yml");
        ITEM_MATCHER_VALIDATOR = YamlContainer.parseValidator("Item Matcher", "schemas/item-matcher.yml");
        ENTITY_VALIDATOR = YamlContainer.parseValidator("Entity", "schemas/entity.yml");
    }

    private static final class RegEx
    implements NodeValidator {
        private RegEx() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == STRING_MATCHER) {
                return null;
            }
            if (context.getNode().getNodeType() != NodeType.SCALAR) {
                return context.err("Expected a RegEx text here, got '" + tag.getValue() + "' instead. ");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            String val = scalarNode.getValue();
            try {
                Pattern pattern = Pattern.compile(val);
                scalarNode.setTag(REGEX);
                scalarNode.cacheConstructed(pattern);
            }
            catch (PatternSyntaxException ex) {
                return context.err("Failed to parse RegEx '" + val + "' " + ex.getMessage());
            }
            return null;
        }
    }

    private static final class NumberMatcher
    implements NodeValidator {
        private NumberMatcher() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == STRING_MATCHER) {
                return null;
            }
            if (context.getNode().getNodeType() != NodeType.SCALAR) {
                return context.err("Expected a number matcher text here, got '" + tag.getValue() + "' instead. ");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            String val = scalarNode.getValue();
            try {
                org.kingdoms.utils.internal.string.NumberMatcher matcher = org.kingdoms.utils.internal.string.NumberMatcher.parse(val);
                if (matcher == null) {
                    return context.err("Failed to parse number matcher '" + val + "' invalid.");
                }
                scalarNode.setTag(NUMBER_MATCHER);
                scalarNode.cacheConstructed(matcher);
            }
            catch (Exception ex) {
                return context.err("Failed to parse number matcher '" + val + "' " + ex.getMessage());
            }
            return null;
        }
    }

    private static final class Time
    implements NodeValidator {
        private Time() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == TIME) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a time HH:mm:ss, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            String[] split = Strings.splitArray(scalarNode.getValue(), ':');
            if (split.length == 0 || split.length == 1 || split.length > 3) {
                return context.err("Expected a time HH:mm:ss");
            }
            String hours = split[0];
            String minutes = split[1];
            String seconds = split.length == 3 ? split[2] : null;
            try {
                int hrs = Integer.parseInt(hours);
                if (hrs < 0 || hrs > 24) {
                    return context.err("Hour segment must be between 0-24 '" + hours + "' HH:mm:ss");
                }
            }
            catch (NumberFormatException ex) {
                return context.err("Invalid number for hours segment '" + hours + "' HH:mm:ss");
            }
            try {
                int mins = Integer.parseInt(minutes);
                if (mins < 0 || mins >= 60) {
                    return context.err("Hour segment must be between 0-59 '" + minutes + "' HH:mm:ss");
                }
            }
            catch (NumberFormatException ex) {
                return context.err("Invalid number for minutes segment '" + minutes + "' HH:mm:ss");
            }
            if (seconds != null) {
                try {
                    int secs = Integer.parseInt(seconds);
                    if (secs < 0 || secs >= 60) {
                        return context.err("Hour segment must be between 0-59 '" + seconds + "' HH:mm:ss");
                    }
                }
                catch (NumberFormatException ex) {
                    return context.err("Invalid number for minutes segment '" + seconds + "' HH:mm:ss");
                }
            }
            scalarNode.setTag(TIME);
            return null;
        }
    }

    private static final class Potion
    implements NodeValidator {
        private Potion() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == POTION) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected a potion effect");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            XPotion.Effect potion = XPotion.parseEffect((String)scalarNode.getValue());
            if (potion == null) {
                return context.err("Unknown potion effect '" + scalarNode.getValue() + '\'');
            }
            scalarNode.setTag(POTION);
            scalarNode.cacheConstructed(potion);
            return null;
        }
    }

    private static final class PotionEffectType
    implements NodeValidator {
        private PotionEffectType() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == POTION_EFFECT_TYPE) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected a potion effect");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            Optional potion = XPotion.of((String)scalarNode.getValue());
            if (!potion.isPresent()) {
                return context.err("Unknown potion effect type '" + scalarNode.getValue() + '\'');
            }
            scalarNode.setTag(POTION_EFFECT_TYPE);
            scalarNode.cacheConstructed(potion.get());
            return null;
        }
    }

    private static final class MessageEntry
    implements NodeValidator {
        private MessageEntry() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == MESSAGE_ENTRY) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a message entry, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            if (!LanguageEntry.isValidConfigLanguageEntry(scalarNode.getValue())) {
                return context.err("Malformed message entry: '" + scalarNode.getValue() + '\'');
            }
            scalarNode.setTag(MESSAGE_ENTRY);
            scalarNode.cacheConstructed(LanguageEntry.fromString(scalarNode.getValue()));
            return null;
        }
    }

    private static final class Message
    implements NodeValidator {
        private Message() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == MESSAGE) {
                return null;
            }
            if (tag == Tag.NULL) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a message entry, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            MessageCompilerSettings compilerSettings = MessageCompilerSettings.none().validate().allowNewLines().colorize().hovers().translatePlaceholders();
            MessageCompiler compiler = new MessageCompiler(scalarNode.getValue(), compilerSettings);
            if (compiler.hasErrors()) {
                return context.err(compiler.joinExceptions());
            }
            scalarNode.setTag(MESSAGE);
            return null;
        }
    }

    private static final class Permission
    implements NodeValidator {
        private Permission() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == PERMISSION) {
                return null;
            }
            if (tag == Tag.MAP) {
                return PERMISSION_VALIDATOR.validate(context);
            }
            if (tag == Tag.STR) {
                String value = ((ScalarNode)context.getNode()).getValue();
                if (value.indexOf(46) <= 0) {
                    context.warn("Suspicious permission node. Consider using dots to namespace permissions.");
                }
                return null;
            }
            return context.err("Expected a permission, instead got " + tag);
        }
    }

    private static final class Class
    implements NodeValidator {
        private Class() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == CLASS) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a class name, instead got " + tag);
            }
            String name = ((ScalarNode)context.getNode()).getValue();
            try {
                java.lang.Class.forName(name);
                return null;
            }
            catch (ClassNotFoundException e) {
                return context.err("Unknown class");
            }
        }
    }

    private static final class Particle
    implements NodeValidator {
        private Particle() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == PARTICLE) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a particle name, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            Optional particle = XParticle.of((String)scalarNode.getValue());
            if (!particle.isPresent()) {
                return context.err("Unknown particle '" + scalarNode.getValue() + '\'');
            }
            return null;
        }
    }

    private static final class Math
    implements NodeValidator {
        private Math() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            MathCompiler.Expression compiled;
            Tag tag = context.getNode().getTag();
            if (tag == MATH) {
                return null;
            }
            if (tag != Tag.STR && tag != Tag.INT && tag != Tag.FLOAT) {
                return context.err("Expected math equation, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            try {
                compiled = MathCompiler.compile(scalarNode.getValue());
            }
            catch (MathCompiler.MathEvaluateException ex) {
                return context.err("(Math Compiler Error) " + ex.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return context.err("(Internal Math Compiler Error) " + ex.getMessage());
            }
            scalarNode.setTag(MATH);
            scalarNode.cacheConstructed(compiled);
            return null;
        }
    }

    private static final class Material
    implements NodeValidator {
        private Material() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == MATERIAL) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected a material");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            Optional mat = XMaterial.matchXMaterial((String)scalarNode.getValue());
            if (!mat.isPresent()) {
                return context.err("Unknown material '" + scalarNode.getValue() + '\'');
            }
            scalarNode.setTag(MATERIAL);
            scalarNode.cacheConstructed(mat.get());
            return null;
        }
    }

    private static final class Entity
    implements NodeValidator {
        private Entity() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == ENTITY) {
                return null;
            }
            if (context.getNode().getNodeType() != NodeType.MAPPING) {
                return context.err("Expected an entity section, instead got " + tag);
            }
            return ENTITY_VALIDATOR.validate(context);
        }
    }

    private static final class Biome
    implements NodeValidator {
        private Biome() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == BIOME) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected a biome");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            Optional mat = XBiome.of((String)scalarNode.getValue());
            if (!mat.isPresent()) {
                return context.err("Unknown biome '" + scalarNode.getValue() + '\'');
            }
            return null;
        }
    }

    private static final class Condition
    implements NodeValidator {
        private Condition() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            ConditionalCompiler.LogicalOperand compiled;
            Tag tag = context.getNode().getTag();
            if (tag == CONDITION) {
                return null;
            }
            if (tag != Tag.STR && tag != Tag.BOOL) {
                return context.err("Expected a condition, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            try {
                compiled = ConditionalCompiler.compile(scalarNode.getValue()).evaluate();
            }
            catch (Exception ex) {
                return context.err(ex.getMessage());
            }
            scalarNode.setTag(CONDITION);
            scalarNode.cacheConstructed(compiled);
            return null;
        }
    }

    private static final class StringMatcher
    implements NodeValidator {
        private StringMatcher() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == STRING_MATCHER) {
                return null;
            }
            if (context.getNode().getNodeType() != NodeType.SCALAR) {
                return context.err("Expected a string matcher text here, got '" + tag.getValue() + "' instead. ");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            String val = scalarNode.getValue();
            try {
                org.kingdoms.utils.internal.string.StringMatcher matcher = org.kingdoms.utils.internal.string.StringMatcher.fromString(val);
                scalarNode.setTag(STRING_MATCHER);
                scalarNode.cacheConstructed(matcher);
            }
            catch (PatternSyntaxException ex) {
                return context.err("Failed to parse string matcher '" + val + "' " + ex.getMessage());
            }
            return null;
        }
    }

    private static final class MaterialMatcher
    implements NodeValidator {
        private MaterialMatcher() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == MATERIAL_MATCHER) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected a material");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            String val = scalarNode.getValue();
            String material = val.toUpperCase(Locale.ENGLISH);
            if (material.startsWith("CONTAINS:")) {
                material = val.substring("CONTAINS:".length());
                for (char c : material.toCharArray()) {
                    if (c == '_' || Strings.isEnglishLetterOrDigit(c)) continue;
                    return context.err("Materials cannot possibly contain the character '" + c + '\'');
                }
            } else if (material.startsWith("REGEX:")) {
                material = val.substring("REGEX:".length());
                try {
                    Pattern.compile(material);
                }
                catch (PatternSyntaxException ex) {
                    return context.err("Failed to parse regex '" + material + "' " + ex.getMessage());
                }
            } else {
                Optional mat = XMaterial.matchXMaterial((String)val);
                if (!mat.isPresent()) {
                    return context.err("Unknown material matcher '" + val + '\'');
                }
            }
            scalarNode.setTag(MATERIAL_MATCHER);
            return null;
        }
    }

    private static final class KingdomPermission
    implements NodeValidator {
        private KingdomPermission() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == KINGDOM_PERMISSION) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected a kingdom permission");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            org.kingdoms.constants.player.KingdomPermission perm = (org.kingdoms.constants.player.KingdomPermission)((Object)Kingdoms.get().getPermissionRegistery().getRegistered(Namespace.fromString(scalarNode.getValue())));
            if (perm == null) {
                return context.err("Unknown kingdom permission '" + scalarNode.getValue() + '\'');
            }
            scalarNode.setTag(KINGDOM_PERMISSION);
            scalarNode.cacheConstructed(perm);
            return null;
        }
    }

    private static final class Sound
    implements NodeValidator {
        private Sound() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            XSound.Record record;
            if (context.getNode().getTag() == SOUND) {
                return null;
            }
            ValidationFailure expectStr = CustomConfigValidators.expectString(context, "sound");
            if (expectStr != null) {
                return expectStr;
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            if (scalarNode.getValue().equals("default")) {
                record = XSound.parse((String)KingdomsConfig.GUIS_DEFAULT_CLICK_SOUND.getString());
            } else {
                try {
                    record = XSound.parse((String)scalarNode.getValue());
                }
                catch (IllegalArgumentException ex) {
                    return context.err(ex.getMessage());
                }
            }
            scalarNode.setTag(SOUND);
            scalarNode.cacheConstructed(record);
            return null;
        }
    }

    private static final class Period
    implements NodeValidator {
        private Period() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == PERIOD) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR && context.getNode().getTag() != Tag.INT) {
                return context.err("Expected a time period");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            if (!(scalarNode.getParsed() instanceof Number)) {
                try {
                    MathCompiler.Expression compiled = MathCompiler.compile(scalarNode.getValue());
                    if (!compiled.contains(MathCompiler.ConstantExpr.class, x -> x.getType() == MathCompiler.ConstantExprType.TIME)) {
                        context.warn("The provided math equation doesn't seem to contain any time periods");
                    }
                    scalarNode.setTag(PERIOD);
                    scalarNode.cacheConstructed(compiled);
                    return null;
                }
                catch (Exception compiled) {
                    Long time = TimeUtils.parseTime(scalarNode.getValue());
                    if (time == null) {
                        return context.err("Cannot parse time period '" + scalarNode.getValue() + '\'');
                    }
                    scalarNode.cacheConstructed(time);
                }
            } else {
                int num = ((Number)scalarNode.getParsed()).intValue();
                if (num < 0) {
                    return context.err("Cannot parse time period '" + scalarNode.getValue() + '\'');
                }
                if (num > 0) {
                    context.err("Time period without any time suffix.");
                }
            }
            scalarNode.setTag(PERIOD);
            return null;
        }
    }

    private static final class Enchant
    implements NodeValidator {
        private Enchant() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            if (context.getNode().getTag() == ENCHANT) {
                return null;
            }
            if (context.getNode().getTag() != Tag.STR) {
                return context.err("Expected an enchantment");
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            Optional enchant = XEnchantment.matchXEnchantment((String)scalarNode.getValue());
            if (!enchant.isPresent()) {
                return context.err("Unknown enchantment '" + scalarNode.getValue() + '\'');
            }
            scalarNode.setTag(ENCHANT);
            scalarNode.cacheConstructed(enchant.get());
            return null;
        }
    }

    private static final class ItemStack
    implements NodeValidator {
        private ItemStack() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == ITEM_STACK) {
                return null;
            }
            if (context.getNode().getNodeType() != NodeType.MAPPING) {
                return context.err("Expected an item, instead got " + tag);
            }
            return ITEM_STACK_VALIDATOR.validate(context);
        }
    }

    private static final class ItemMatcher
    implements NodeValidator {
        private ItemMatcher() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == ITEM_MATCHER) {
                return null;
            }
            if (context.getNode().getNodeType() != NodeType.MAPPING) {
                return context.err("Expected an item matcher section, instead got " + tag);
            }
            return ITEM_MATCHER_VALIDATOR.validate(context);
        }
    }

    private static final class ItemFlag
    implements NodeValidator {
        private ItemFlag() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == ITEM_FLAG) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected an item flag, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            com.google.common.base.Optional itemFlag = Enums.getIfPresent(org.bukkit.inventory.ItemFlag.class, (String)scalarNode.getValue());
            if (!itemFlag.isPresent() && !scalarNode.getValue().equalsIgnoreCase("ALL")) {
                return context.err("Unknown item flag '" + scalarNode.getValue() + '\'');
            }
            return null;
        }
    }

    private static final class World
    implements NodeValidator {
        private static final boolean CHECK_WORLD_EXISTANCE = false;

        private World() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == WORLD) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a world name, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            return null;
        }
    }

    private static final class StructureType
    implements NodeValidator {
        private StructureType() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == STRUCTURE_TYPE) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a structure type name, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            org.kingdoms.constants.land.structures.StructureType type = StructureRegistry.get().getType(scalarNode.getValue());
            if (type == null) {
                return context.err("Unknown structure type with name '" + scalarNode.getValue() + '\'');
            }
            return null;
        }
    }

    private static final class TurretType
    implements NodeValidator {
        private TurretType() {
        }

        @Override
        public ValidationFailure validate(ValidationContext context) {
            Tag tag = context.getNode().getTag();
            if (tag == TURRET_TYPE) {
                return null;
            }
            if (tag != Tag.STR) {
                return context.err("Expected a turret type name, instead got " + tag);
            }
            ScalarNode scalarNode = (ScalarNode)context.getNode();
            org.kingdoms.constants.land.turrets.TurretType type = TurretRegistry.get().getType(scalarNode.getValue());
            if (type == null) {
                return context.err("Unknown turret type with name '" + scalarNode.getValue() + '\'');
            }
            return null;
        }
    }
}

