/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.conditions;

import java.time.Duration;
import java.util.ArrayList;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.compilers.translators.ConditionalVariableTranslator;
import org.kingdoms.utils.conditions.ConditionBranch;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.Strings;

public final class ConditionProcessor
implements ConditionalVariableTranslator {
    private final PlaceholderProvider placeholderContextProvider;
    private final MessagePlaceholderProvider messageBuilder;

    public ConditionProcessor(PlaceholderProvider placeholderContextProvider) {
        this.placeholderContextProvider = placeholderContextProvider;
        this.messageBuilder = placeholderContextProvider instanceof MessagePlaceholderProvider ? (MessagePlaceholderProvider)placeholderContextProvider : null;
    }

    public static boolean process(ConditionalExpression condition, PlaceholderProvider placeholderContextProvider) {
        try {
            return condition.eval(new ConditionProcessor(placeholderContextProvider));
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while evaluating condition: " + condition, ex);
        }
    }

    public static ConditionChain<Messenger> mapConditions(ConfigSection section) {
        return ConditionProcessor.mapConditions(section, false);
    }

    public static ConditionChain<Messenger> mapConditions(ConfigSection section, boolean asPath) {
        if (section == null) {
            return null;
        }
        ArrayList conditions = new ArrayList();
        for (String condition : section.getKeys()) {
            String value = section.getString(condition);
            Messenger messenger = asPath ? (com.google.common.base.Strings.isNullOrEmpty((String)value) ? null : new LanguageEntryMessenger(Strings.splitArray(value, '.'))) : (com.google.common.base.Strings.isNullOrEmpty((String)value) ? null : new StaticMessenger(MessageCompiler.compile(value)));
            conditions.add(new ConditionBranch<LanguageEntryMessenger>(ConditionalCompiler.compile(condition).evaluate(), (LanguageEntryMessenger)messenger));
        }
        return new ConditionChain<Messenger>(conditions);
    }

    @Override
    public Object apply(String x) {
        Object local = this.placeholderContextProvider.providePlaceholder(x);
        if (local == null) {
            return null;
        }
        if (local instanceof PlaceholderTranslationContext) {
            PlaceholderTranslationContext ctx = (PlaceholderTranslationContext)local;
            local = ctx.getValue();
        }
        if (this.messageBuilder != null) {
            if (local instanceof Messenger) {
                local = ((Messenger)local).getMessageObject(this.messageBuilder.getLanguage());
            }
            if (local instanceof MessageObjectBuilder) {
                local = ((MessageObjectBuilder)local).buildPlain(this.messageBuilder);
            }
        }
        if (local instanceof Duration) {
            local = ((Duration)local).toMillis();
        }
        return local;
    }
}

