/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.conditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.luckperms.api.node.Node;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.services.ServiceLuckPerms;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.conditions.ConditionBranch;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0012B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0017\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJ\u001f\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/conditions/ConditionChain;", "T", "", "cases", "", "Lorg/kingdoms/utils/conditions/ConditionBranch;", "<init>", "(Ljava/util/List;)V", "case", "(Lorg/kingdoms/utils/conditions/ConditionBranch;)V", "getCases", "()Ljava/util/List;", "evaluate", "scrutinee", "Lorg/kingdoms/locale/placeholders/context/PlaceholderProvider;", "returnIf", "", "(Lorg/kingdoms/locale/placeholders/context/PlaceholderProvider;Z)Ljava/lang/Object;", "Companion", "core"})
public final class ConditionChain<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ConditionBranch<T>> cases;

    public ConditionChain(@NotNull List<ConditionBranch<T>> cases) {
        Intrinsics.checkNotNullParameter(cases, (String)"cases");
        this.cases = cases;
    }

    @NotNull
    public final List<ConditionBranch<T>> getCases() {
        return this.cases;
    }

    public ConditionChain(@NotNull ConditionBranch<T> conditionBranch) {
        Intrinsics.checkNotNullParameter(conditionBranch, (String)"case");
        List<ConditionBranch<T>> list = Collections.singletonList(conditionBranch);
        Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
        this(list);
    }

    @Nullable
    public final T evaluate(@NotNull PlaceholderProvider scrutinee, boolean returnIf) {
        Intrinsics.checkNotNullParameter((Object)scrutinee, (String)"scrutinee");
        for (ConditionBranch<T> conditionBranch : this.cases) {
            if (returnIf != ConditionProcessor.process(conditionBranch.getCondition(), scrutinee)) continue;
            T item = conditionBranch.getCase();
            return item instanceof ConditionChain ? ((ConditionChain)item).evaluate(scrutinee, returnIf) : item;
        }
        return null;
    }

    public static /* synthetic */ Object evaluate$default(ConditionChain conditionChain, PlaceholderProvider placeholderProvider, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return conditionChain.evaluate(placeholderProvider, bl);
    }

    @JvmStatic
    public static final void addAllPermissions(@NotNull Collection<UUID> players, @NotNull ConfigSection root, int level) {
        Companion.addAllPermissions(players, root, level);
    }

    @JvmStatic
    public static final void removeAllPermissions(@NotNull Collection<UUID> players, @NotNull ConfigSection root) {
        Companion.removeAllPermissions(players, root);
    }

    @JvmStatic
    public static final void performPermissionOperations(@NotNull Collection<UUID> players, @NotNull ConfigSection root, @Nullable ConfigSection current, int level, @NotNull ServiceLuckPerms.Operation operation, @NotNull MessagePlaceholderProvider settings) {
        Companion.performPermissionOperations(players, root, current, level, operation, settings);
    }

    @JvmStatic
    @NotNull
    public static final ConditionChain<Object> parse(@NotNull ConfigSection config, @NotNull Function<String, Object> terminalParser) {
        return Companion.parse(config, terminalParser);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J@\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00010\u0018H\u0007\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/utils/conditions/ConditionChain$Companion;", "", "<init>", "()V", "addAllPermissions", "", "players", "", "Ljava/util/UUID;", "root", "Lorg/kingdoms/utils/config/ConfigSection;", "level", "", "removeAllPermissions", "performPermissionOperations", "current", "operation", "Lorg/kingdoms/services/ServiceLuckPerms$Operation;", "settings", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "parse", "Lorg/kingdoms/utils/conditions/ConditionChain;", "config", "terminalParser", "Ljava/util/function/Function;", "", "core"})
    @SourceDebugExtension(value={"SMAP\nConditionBranch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionBranch.kt\norg/kingdoms/utils/conditions/ConditionChain$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1557#2:160\n1628#2,3:161\n*S KotlinDebug\n*F\n+ 1 ConditionBranch.kt\norg/kingdoms/utils/conditions/ConditionChain$Companion\n*L\n149#1:160\n149#1:161,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void addAllPermissions(@NotNull Collection<UUID> players, @NotNull ConfigSection root, int level) {
            Intrinsics.checkNotNullParameter(players, (String)"players");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Map permissions = new HashMap();
            for (String key : root.getKeys()) {
                if (!Intrinsics.areEqual((Object)key, (Object)"permissions")) continue;
                org.kingdoms.libs.snakeyaml.nodes.Node node = root.getNode("permissions");
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.snakeyaml.nodes.SequenceNode");
                SequenceNode seq = (SequenceNode)node;
                for (org.kingdoms.libs.snakeyaml.nodes.Node node2 : seq.getValue()) {
                    Node perm = ServiceLuckPerms.buildNode(node2);
                    permissions.put(perm.getKey(), perm);
                }
            }
            for (UUID player : players) {
                ServiceLuckPerms.perform(players, ServiceLuckPerms.Operation.REMOVE, permissions.values());
            }
        }

        @JvmStatic
        public final void removeAllPermissions(@NotNull Collection<UUID> players, @NotNull ConfigSection root) {
            Intrinsics.checkNotNullParameter(players, (String)"players");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Map permissions = new HashMap();
            for (String key : root.getKeys()) {
                org.kingdoms.libs.snakeyaml.nodes.Node node = root.getNode(key);
                if (Intrinsics.areEqual((Object)key, (Object)"permissions")) {
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.snakeyaml.nodes.SequenceNode");
                    SequenceNode seq = (SequenceNode)node;
                    for (org.kingdoms.libs.snakeyaml.nodes.Node element : seq.getValue()) {
                        Node perm = ServiceLuckPerms.buildNode(element);
                        permissions.put(perm.getKey(), perm);
                    }
                    continue;
                }
                if (!(node instanceof MappingNode)) continue;
                this.removeAllPermissions(players, new ConfigSection((MappingNode)node));
            }
            for (UUID player : players) {
                ServiceLuckPerms.perform(players, ServiceLuckPerms.Operation.REMOVE, permissions.values());
            }
        }

        @JvmStatic
        public final void performPermissionOperations(@NotNull Collection<UUID> players, @NotNull ConfigSection root, @Nullable ConfigSection current, int level, @NotNull ServiceLuckPerms.Operation operation, @NotNull MessagePlaceholderProvider settings) {
            Intrinsics.checkNotNullParameter(players, (String)"players");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            int closestSection = KingdomsConfig.getClosestLevelSection(new YamlConfigAccessor(root, root).noDefault(), level);
            String[] stringArray = new String[]{String.valueOf(level)};
            ConfigSection config = root.getSection(stringArray);
            if (config.isSet("permissions")) {
                String string = config.getString("previous");
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)"remove")) {
                        if (level > 1) {
                            Companion.performPermissionOperations(players, root, null, level - 1, ServiceLuckPerms.Operation.REMOVE, settings);
                        } else {
                            throw new IllegalArgumentException("Cannot remove previous permissions from lowest level");
                        }
                    }
                }
                ServiceLuckPerms.perform(players, operation, config.getNode("permissions"));
            }
            for (String key : config.getKeys()) {
                ConditionalCompiler.LogicalOperand condition = ConditionalCompiler.compile(key).evaluate();
                if (!ConditionProcessor.process(condition, settings)) continue;
                org.kingdoms.libs.snakeyaml.nodes.Node node = config.getNode(key);
                if (node instanceof MappingNode) {
                    this.performPermissionOperations(players, root, new ConfigSection((MappingNode)node), level, operation, settings);
                    continue;
                }
                throw new IllegalStateException(("Unexpected permission " + node.getWholeMark()).toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ConditionChain<Object> parse(@NotNull ConfigSection config, @NotNull Function<String, Object> terminalParser) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(terminalParser, (String)"terminalParser");
            List branch = new ArrayList();
            for (String key : config.getKeys()) {
                ConditionalCompiler.LogicalOperand condition = ConditionalCompiler.compile(key).evaluate();
                org.kingdoms.libs.snakeyaml.nodes.Node node = config.getNode(key);
                org.kingdoms.libs.snakeyaml.nodes.Node node2 = node;
                if (node2 instanceof ScalarNode) {
                    org.kingdoms.utils.conditions.ConditionChain$Companion.parse$addBranch(branch, condition, CollectionsKt.listOf((Object)terminalParser.apply(((ScalarNode)node).getValue())));
                    continue;
                }
                if (node2 instanceof SequenceNode) {
                    Collection<Object> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Collection collection2 = ((SequenceNode)node).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getValue(...)");
                    Iterable iterable = collection2;
                    ConditionalCompiler.LogicalOperand logicalOperand = condition;
                    List list = branch;
                    boolean $i$f$map = false;
                    void var11_12 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void x;
                        org.kingdoms.libs.snakeyaml.nodes.Node node3 = (org.kingdoms.libs.snakeyaml.nodes.Node)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)x, (String)"null cannot be cast to non-null type org.snakeyaml.nodes.ScalarNode");
                        collection.add(terminalParser.apply(((ScalarNode)x).getValue()));
                    }
                    collection = (List)destination$iv$iv;
                    org.kingdoms.utils.conditions.ConditionChain$Companion.parse$addBranch(list, logicalOperand, collection);
                    continue;
                }
                if (!(node2 instanceof MappingNode)) continue;
                String[] stringArray = new String[]{key};
                ConfigSection configSection = config.getSection(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
                org.kingdoms.utils.conditions.ConditionChain$Companion.parse$addBranch(branch, condition, this.parse(configSection, terminalParser));
            }
            return new ConditionChain<Object>(branch);
        }

        private static final void parse$addBranch(List<ConditionBranch<Object>> branch, ConditionalCompiler.LogicalOperand condition, Object obj) {
            Intrinsics.checkNotNull((Object)condition);
            branch.add(new ConditionBranch<Object>(condition, obj));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

