/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.compilers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.IntRange;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.compilers.translators.MathematicalVariableTranslator;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0012\u0018\u0000 C2\u00020\u0001:\u00113456789:;<=>?@ABCB?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\bJ\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\u0000H\u0002J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0082\bJ\t\u0010\u0018\u001a\u00020\bH\u0082\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0017\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fH\u0082\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0011\u0010$\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u001aH\u0082\bJ\b\u0010%\u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005H\u0002J(\u0010.\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00032\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020\u000502H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler;", "", "expression", "", "offset", "", "end", "sub", "", "lexicalEnv", "Ljava/util/LinkedList;", "Lorg/kingdoms/utils/compilers/MathCompiler$LexicalEnvironment;", "<init>", "(Ljava/lang/String;IIZLjava/util/LinkedList;)V", "syntaxTree", "skipWhitespace", "ofs", "skipUntilNonVar", "firstOfs", "varInterpolation", "delegate", "charAt", "", "index", "isInsideFunction", "compile", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "build", "grouped", "Lorg/kingdoms/utils/compilers/MathCompiler$BiOperation;", "iter", "", "handleOperator", "", "op", "Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "handleOperand", "untilNonDouble", "parseVariable", "interpolation", "parseFunction", "Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;", "name", "parsePeriod", "Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExpr;", "beg", "exception", "Lorg/kingdoms/utils/compilers/MathCompiler$MathEvaluateException;", "txt", "pointers", "", "Function", "LexicalEnvironment", "MathEvaluateException", "Side", "Arity", "QuantumFunction", "TriDoubleFn", "Operator", "Expression", "StringConstant", "BiOperation", "FunctionExpr", "ConstantExprType", "ConstantExpr", "Variable", "FnArgs", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMathCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler\n+ 2 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$Companion\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,965:1\n88#1:966\n88#1:967\n88#1:968\n88#1:969\n88#1:970\n91#1:971\n278#1,35:972\n234#1,31:1008\n88#1:1039\n88#1:1040\n88#1:1041\n52#1,3:1042\n88#1:1045\n936#2:1007\n947#2,3:1050\n37#3:1046\n36#3,3:1047\n*S KotlinDebug\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler\n*L\n64#1:966\n70#1:967\n77#1:968\n99#1:969\n131#1:970\n143#1:971\n173#1:972,35\n227#1:1008,31\n315#1:1039\n318#1:1040\n323#1:1041\n334#1:1042,3\n335#1:1045\n176#1:1007\n433#1:1050,3\n394#1:1046\n394#1:1047,3\n*E\n"})
public final class MathCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    private int offset;
    private final int end;
    private final boolean sub;
    @NotNull
    private final LinkedList<LexicalEnvironment> lexicalEnv;
    @NotNull
    private final LinkedList<Object> syntaxTree;
    @NotNull
    private static final Map<String, Double> CONSTANTS = new HashMap(8);
    @NotNull
    private static final Map<String, Function> FUNCTIONS = new HashMap(44);
    @NotNull
    private static final Map<Character, Operator> OPERATORS = new HashMap(20);
    @NotNull
    private static final MathematicalVariableTranslator EMPTY_VARS = MathCompiler::EMPTY_VARS$lambda$7;
    @JvmField
    @NotNull
    public static final Expression DEFAULT_VALUE = new ConstantExpr(0.0, ConstantExprType.NUMBER);

    private MathCompiler(String expression, int offset, int end, boolean sub, LinkedList<LexicalEnvironment> lexicalEnv) {
        this.expression = expression;
        this.offset = offset;
        this.end = end;
        this.sub = sub;
        this.lexicalEnv = lexicalEnv;
        this.syntaxTree = new LinkedList();
    }

    /* synthetic */ MathCompiler(String string, int n, int n2, boolean bl, LinkedList linkedList, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            linkedList = new LinkedList<LexicalEnvironment>();
        }
        this(string, n, n2, bl, linkedList);
    }

    private final int skipWhitespace(int ofs, int end) {
        int ofs2;
        boolean $i$f$skipWhitespace = false;
        for (ofs2 = ofs; ofs2 < end && this.expression.charAt(ofs2) == ' '; ++ofs2) {
        }
        return ofs2;
    }

    private final int skipUntilNonVar(int firstOfs, boolean varInterpolation) {
        int ofs = firstOfs;
        MathCompiler this_$iv = this;
        boolean $i$f$charAt = false;
        char ch = this_$iv.expression.charAt(ofs);
        if (varInterpolation) {
            while (ch != '}') {
                if (++ofs == this.end) {
                    throw MathCompiler.exception$default(this, firstOfs - 1, "Unclosed variable interpolation", null, 4, null);
                }
                this_$iv = this;
                $i$f$charAt = false;
                ch = this_$iv.expression.charAt(ofs);
            }
            ++ofs;
        } else {
            while (true) {
                if (!('a' <= ch ? ch < '{' : false)) {
                    if (!('A' <= ch ? ch < '[' : false)) {
                        boolean bl = '0' <= ch ? ch < ':' : false;
                        if (!bl && ch != '_') break;
                    }
                }
                if (++ofs == this.end) {
                    return ofs;
                }
                this_$iv = this;
                $i$f$charAt = false;
                ch = this_$iv.expression.charAt(ofs);
            }
        }
        return ofs;
    }

    private final MathCompiler delegate() {
        return new MathCompiler(this.expression, this.offset, this.end, true, this.lexicalEnv);
    }

    private final char charAt(int index) {
        boolean $i$f$charAt = false;
        return this.expression.charAt(index);
    }

    private final boolean isInsideFunction() {
        boolean $i$f$isInsideFunction = false;
        Function1 function1 = isInsideFunction.1.INSTANCE;
        return this.lexicalEnv.stream().anyMatch(new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final Expression compile() throws NumberFormatException, MathEvaluateException {
        if (this.offset == this.end) {
            return this.build();
        }
        do {
            block35: {
                block37: {
                    block36: {
                        var2_3 = this;
                        index$iv = this.offset;
                        $i$f$charAt = false;
                        ch = this_$iv.expression.charAt(index$iv);
                        if (ch == ' ') break block35;
                        index$iv = ch;
                        v0 = 48 <= index$iv ? index$iv < 58 : false;
                        if (!v0) break block36;
                        from = this.offset;
                        this.untilNonDouble();
                        var6_21 = this.offset;
                        this.offset = var6_21 + -1;
                        to = var6_21;
                        Intrinsics.checkNotNullExpressionValue((Object)this.expression.substring(from, to), (String)"substring(...)");
                        try {
                            var7_23 = new ConstantExpr(Double.parseDouble((String)evaluated), ConstantExprType.NUMBER);
                        }
                        catch (NumberFormatException thr) {
                            throw this.exception(from, "Invalid numeric value \"" + (String)evaluated + '\"', org.kingdoms.utils.compilers.MathCompiler$Companion.access$pointerToName(MathCompiler.Companion, from, (String)evaluated));
                        }
                        v1 = var7_23;
                        break block37;
                    }
                    if (97 <= index$iv ? index$iv < 123 : false) ** GOTO lbl-1000
                    v2 = 65 <= index$iv ? index$iv < 91 : false;
                    if (v2) lbl-1000:
                    // 2 sources

                    {
                        v1 = this.parseVariable(false);
                    } else if (index$iv == 123) {
                        from = this.offset;
                        this.offset = from + 1;
                        v1 = this.parseVariable(true);
                    } else {
                        if (index$iv == 34) {
                            from = this.offset;
                            this.offset = from + 1;
                            str = new StringBuilder();
                            chr = '\u0000';
                            do {
                                evaluated = this;
                                var7_25 = this.offset;
                                this.offset = var7_25 + 1;
                                index$iv = var7_25;
                                $i$f$charAt = false;
                                chr = this_$iv.expression.charAt(index$iv);
                                str.append(chr);
                            } while (chr != '\"');
                            v3 = str.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toString(...)");
                            return new StringConstant(v3);
                        }
                        if (index$iv == 44 || index$iv == 59) {
                            v4 = this.lexicalEnv.peekLast();
                            if (v4 == null) {
                                throw MathCompiler.exception$default(this, this.offset, "Function argument separator outside of functions", null, 4, null);
                            }
                            last = v4;
                            if (!last.isFunction()) {
                                this_$iv = this;
                                $i$f$isInsideFunction = false;
                                index$iv = isInsideFunction.1.INSTANCE;
                                if (this_$iv.lexicalEnv.stream().anyMatch(new /* invalid duplicate definition of identical inner class */)) {
                                    throw MathCompiler.exception$default(this, last.getIndex(), "Unclosed parentheses", null, 4, null);
                                }
                                throw MathCompiler.exception$default(this, this.offset, "Function argument separator outside of functions", null, 4, null);
                            }
                            return this.build();
                        }
                        if (index$iv == 91) {
                            v1 = this.parsePeriod(this.offset);
                        } else if (index$iv == 40) {
                            last = this.offset;
                            this.offset = last + 1;
                            this.lexicalEnv.add(new LexicalEnvironment(last, null));
                            subExpr = this.delegate();
                            compiled = subExpr.compile();
                            this.offset = subExpr.offset;
                            v1 = compiled;
                        } else {
                            if (index$iv == 41) {
                                v5 = this.lexicalEnv.pollLast();
                                if (v5 == null) {
                                    throw MathCompiler.exception$default(this, this.offset, "No opening parentheses found for closing parenthes", null, 4, null);
                                }
                                last = v5;
                                if (last.getFunction() == null && this.syntaxTree.isEmpty()) {
                                    throw MathCompiler.exception$default(this, this.offset, "Empty subexpression", null, 4, null);
                                }
                                return this.build();
                            }
                            v1 = operand = null;
                        }
                    }
                }
                if (operand != null) {
                    this_$iv = this;
                    $i$f$handleOperand = false;
                    if (this_$iv.syntaxTree.isEmpty()) {
                        this_$iv.syntaxTree.add(operand);
                    } else {
                        sentence$iv = operand;
                        last$iv = this_$iv.syntaxTree.getLast();
                        if (!(last$iv instanceof Operator)) {
                            throw MathCompiler.exception$default(this_$iv, this_$iv.offset, "Expected an operator before operand", null, 4, null);
                        }
                        block9: while (last$iv != null && last$iv instanceof Operator) {
                            switch (WhenMappings.$EnumSwitchMapping$0[((Operator)last$iv).getArity$core().ordinal()]) {
                                case 1: {
                                    break block9;
                                }
                                case 2: {
                                    sentence$iv = new BiOperation(MathCompiler.DEFAULT_VALUE, (Operator)last$iv, sentence$iv);
                                    this_$iv.syntaxTree.removeLast();
                                    break;
                                }
                                case 3: {
                                    this_$iv.syntaxTree.removeLast();
                                    lastLast$iv = this_$iv.syntaxTree.peekLast();
                                    if (lastLast$iv == null || lastLast$iv instanceof Operator) {
                                        sentence$iv = new BiOperation(MathCompiler.DEFAULT_VALUE, (Operator)last$iv, sentence$iv);
                                        break;
                                    }
                                    this_$iv.syntaxTree.add(last$iv);
                                    break block9;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            last$iv = this_$iv.syntaxTree.peekLast();
                        }
                        this_$iv.syntaxTree.addLast(sentence$iv);
                    }
                } else {
                    this_$iv = MathCompiler.Companion;
                    $i$f$getOperator = false;
                    v6 = op = MathCompiler.OPERATORS.get(Character.valueOf(ch));
                    if (v6 != null) {
                        this.handleOperator(v6);
                    } else {
                        throw MathCompiler.exception$default(this, this.offset, "Unrecognized character '" + ch + "' (" + ch + ") outside of variable/placeholder interpolation", null, 4, null);
                    }
                }
            }
            var2_2 = this.offset;
            this.offset = var2_2 + 1;
        } while (this.offset < this.end);
        return this.build();
    }

    private final Expression build() {
        if (!(this.offset < this.end && this.sub || this.lexicalEnv.isEmpty())) {
            ArrayList list = new ArrayList();
            Ref.BooleanRef includesFunction = new Ref.BooleanRef();
            this.lexicalEnv.stream().forEach(arg_0 -> MathCompiler.build$lambda$1(arg_0 -> MathCompiler.build$lambda$0(list, includesFunction, arg_0), arg_0));
            throw this.exception(this.lexicalEnv.getLast().getIndex(), "Unclosed parentheses" + (includesFunction.element ? " and functions" : ""), list);
        }
        if (this.syntaxTree.isEmpty()) {
            return DEFAULT_VALUE;
        }
        if (this.syntaxTree.size() == 1) {
            Object object = this.syntaxTree.getLast();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
            return (Expression)object;
        }
        Object it = this.syntaxTree.getLast();
        boolean bl = false;
        if (it instanceof Operator) {
            String suggestIfPlaceholder = ((Operator)it).getSymbol() == '%' ? " (Hint: Write placeholders without % around them." : "";
            throw MathCompiler.exception$default(this, this.end - 1, "Blank operand on right hand side of " + ((Operator)it).getSymbol() + suggestIfPlaceholder, null, 4, null);
        }
        BiOperation operation = null;
        ListIterator<BiOperation> listIterator = this.syntaxTree.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        ListIterator<BiOperation> iter = listIterator;
        while (iter.hasNext()) {
            BiOperation biOperation;
            MathCompiler this_$iv = this;
            boolean $i$f$grouped = false;
            Object e = iter.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
            Expression lhs$iv = (Expression)e;
            Object e2 = iter.next();
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
            Operator op$iv = (Operator)e2;
            Object e3 = iter.next();
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
            Expression rhs$iv = (Expression)e3;
            if (!iter.hasNext()) {
                biOperation = new BiOperation(lhs$iv, op$iv, rhs$iv);
            } else {
                BiOperation operation$iv;
                Object e4 = iter.next();
                Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
                Operator op2$iv = (Operator)e4;
                Object e5 = iter.next();
                Intrinsics.checkNotNull(e5, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
                Expression op2Rhs$iv = (Expression)e5;
                if (op$iv.hasPrecedenceOver$core(op2$iv)) {
                    operation$iv = new BiOperation(lhs$iv, op$iv, rhs$iv);
                    ListIterator<BiOperation> $this$grouped_u24lambda_u243$iv = iter;
                    boolean bl2 = false;
                    $this$grouped_u24lambda_u243$iv.previous();
                    $this$grouped_u24lambda_u243$iv.previous();
                    $this$grouped_u24lambda_u243$iv.previous();
                    $this$grouped_u24lambda_u243$iv.remove();
                    $this$grouped_u24lambda_u243$iv.previous();
                    $this$grouped_u24lambda_u243$iv.remove();
                    $this$grouped_u24lambda_u243$iv.previous();
                    $this$grouped_u24lambda_u243$iv.set(operation$iv);
                    biOperation = operation$iv;
                } else {
                    operation$iv = new BiOperation(rhs$iv, op2$iv, op2Rhs$iv);
                    ListIterator<BiOperation> $this$grouped_u24lambda_u244$iv = iter;
                    boolean bl3 = false;
                    $this$grouped_u24lambda_u244$iv.remove();
                    $this$grouped_u24lambda_u244$iv.previous();
                    $this$grouped_u24lambda_u244$iv.remove();
                    $this$grouped_u24lambda_u244$iv.previous();
                    $this$grouped_u24lambda_u244$iv.set(operation$iv);
                    $this$grouped_u24lambda_u244$iv.previous();
                    $this$grouped_u24lambda_u244$iv.previous();
                    biOperation = operation$iv;
                }
            }
            operation = biOperation;
        }
        BiOperation biOperation = operation;
        Intrinsics.checkNotNull(biOperation);
        return biOperation;
    }

    private final BiOperation grouped(ListIterator<Object> iter) {
        BiOperation biOperation;
        boolean $i$f$grouped = false;
        Object object = iter.next();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        Expression lhs = (Expression)object;
        Object object2 = iter.next();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
        Operator op = (Operator)object2;
        Object object3 = iter.next();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        Expression rhs = (Expression)object3;
        if (!iter.hasNext()) {
            return new BiOperation(lhs, op, rhs);
        }
        Object object4 = iter.next();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
        Operator op2 = (Operator)object4;
        Object object5 = iter.next();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        Expression op2Rhs = (Expression)object5;
        if (op.hasPrecedenceOver$core(op2)) {
            BiOperation operation = new BiOperation(lhs, op, rhs);
            ListIterator<Object> $this$grouped_u24lambda_u243 = iter;
            boolean bl = false;
            $this$grouped_u24lambda_u243.previous();
            $this$grouped_u24lambda_u243.previous();
            $this$grouped_u24lambda_u243.previous();
            $this$grouped_u24lambda_u243.remove();
            $this$grouped_u24lambda_u243.previous();
            $this$grouped_u24lambda_u243.remove();
            $this$grouped_u24lambda_u243.previous();
            $this$grouped_u24lambda_u243.set(operation);
            biOperation = operation;
        } else {
            BiOperation operation = new BiOperation(rhs, op2, op2Rhs);
            ListIterator<Object> $this$grouped_u24lambda_u244 = iter;
            boolean bl = false;
            $this$grouped_u24lambda_u244.remove();
            $this$grouped_u24lambda_u244.previous();
            $this$grouped_u24lambda_u244.remove();
            $this$grouped_u24lambda_u244.previous();
            $this$grouped_u24lambda_u244.set(operation);
            $this$grouped_u24lambda_u244.previous();
            $this$grouped_u24lambda_u244.previous();
            biOperation = operation;
        }
        return biOperation;
    }

    private final void handleOperator(Operator op) {
        Object last = this.syntaxTree.peekLast();
        if (!op.getArity$core().isUnary$core() && last instanceof Operator) {
            throw MathCompiler.exception$default(this, this.offset, "Blank operand on the left hand side of binary operator", null, 4, null);
        }
        this.syntaxTree.addLast(op);
    }

    private final void handleOperand(Expression expression) {
        boolean $i$f$handleOperand = false;
        if (this.syntaxTree.isEmpty()) {
            this.syntaxTree.add(expression);
            return;
        }
        Expression sentence = expression;
        Object last = this.syntaxTree.getLast();
        if (!(last instanceof Operator)) {
            throw MathCompiler.exception$default(this, this.offset, "Expected an operator before operand", null, 4, null);
        }
        block5: while (last != null && last instanceof Operator) {
            switch (WhenMappings.$EnumSwitchMapping$0[((Operator)last).getArity$core().ordinal()]) {
                case 1: {
                    break block5;
                }
                case 2: {
                    sentence = new BiOperation(DEFAULT_VALUE, (Operator)last, sentence);
                    this.syntaxTree.removeLast();
                    break;
                }
                case 3: {
                    this.syntaxTree.removeLast();
                    Object lastLast = this.syntaxTree.peekLast();
                    if (lastLast == null || lastLast instanceof Operator) {
                        sentence = new BiOperation(DEFAULT_VALUE, (Operator)last, sentence);
                        break;
                    }
                    this.syntaxTree.add(last);
                    break block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            last = this.syntaxTree.peekLast();
        }
        this.syntaxTree.addLast(sentence);
    }

    /*
     * WARNING - void declaration
     */
    private final void untilNonDouble() {
        void this_$iv;
        MathCompiler mathCompiler = this;
        int index$iv2 = this.offset;
        boolean $i$f$charAt = false;
        char ch = this_$iv.expression.charAt(index$iv2);
        while (true) {
            boolean bl = '0' <= ch ? ch < ':' : false;
            if (!bl && ch != 'x' && ch != 'e' && ch != 'E' && ch != '-' && ch != '.') break;
            if (ch == '-') {
                void this_$iv2;
                MathCompiler index$iv2 = this;
                int index$iv3 = this.offset - 1;
                boolean $i$f$charAt2 = false;
                char previous = this_$iv2.expression.charAt(index$iv3);
                if (previous != 'e' && previous != 'E') {
                    return;
                }
            }
            ++this.offset;
            if (this.offset == this.end) {
                return;
            }
            MathCompiler previous = this;
            index$iv2 = this.offset;
            $i$f$charAt = false;
            ch = this_$iv.expression.charAt(index$iv2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Expression parseVariable(boolean interpolation) {
        MathCompiler this_$iv;
        void end$iv;
        void ofs$iv;
        int endVar = this.skipUntilNonVar(this.offset, interpolation);
        String string = this.expression.substring(this.offset, interpolation ? endVar - 1 : endVar);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String varName = string;
        if (Intrinsics.areEqual((Object)varName, (Object)"_")) {
            throw MathCompiler.exception$default(this, this.offset, "Reserved single underscore identifier", null, 4, null);
        }
        this.offset = endVar;
        MathCompiler mathCompiler = this;
        int n = this.offset;
        int n2 = this.end;
        MathCompiler mathCompiler2 = this;
        boolean $i$f$skipWhitespace = false;
        for (ofs$iv = ofs$iv; ofs$iv < end$iv && this_$iv.expression.charAt((int)ofs$iv) == ' '; ++ofs$iv) {
        }
        void var10_11 = ofs$iv;
        mathCompiler2.offset = var10_11;
        if (this.offset < this.end) {
            this_$iv = this;
            int index$iv = this.offset;
            boolean $i$f$charAt = false;
            if (this_$iv.expression.charAt(index$iv) == '(') {
                return this.parseFunction(varName);
            }
        }
        this.offset = endVar - 1;
        Double it = CONSTANTS.get(varName);
        boolean bl = false;
        return it == null ? (Expression)new Variable(varName) : (Expression)new ConstantExpr(it, ConstantExprType.CONSTANT_VARIABLE);
    }

    private final FunctionExpr parseFunction(String name) {
        String suggestion = MathCompiler.Companion.findFunction(name);
        suggestion = suggestion == null ? "" : "; Did you mean '" + suggestion + "' function?";
        Function function = FUNCTIONS.get(name);
        if (function == null) {
            throw MathCompiler.exception$default(this, this.offset, "Unknown function: " + name + suggestion, null, 4, null);
        }
        Function fn = function;
        int n = this.offset;
        this.offset = n + 1;
        ArrayList<Expression> args = new ArrayList<Expression>();
        LexicalEnvironment instance = new LexicalEnvironment(this.offset, fn);
        this.lexicalEnv.add(instance);
        int beg = this.offset;
        do {
            MathCompiler compiler;
            Expression obj;
            if (!Intrinsics.areEqual((Object)(obj = (compiler = this.delegate()).compile()), (Object)DEFAULT_VALUE)) {
                args.add(obj);
            }
            this.offset = compiler.offset + 1;
        } while (Intrinsics.areEqual((Object)this.lexicalEnv.peekLast(), (Object)instance));
        int compiler = this.offset;
        this.offset = compiler + -1;
        if (fn.getArgCount() < 0) {
            int minArgs = Math.abs(fn.getArgCount()) - 1;
            if (args.size() < minArgs) {
                throw this.exception(beg, "Too few arguments for function '" + name + "', expected at least: " + minArgs + ", got: " + args.size(), MathCompiler.Companion.pointerToName(beg, name));
            }
        } else {
            if (args.size() < fn.getArgCount()) {
                throw this.exception(beg, "Too few arguments for function '" + name + "', expected: " + fn.getArgCount() + ", got: " + args.size(), MathCompiler.Companion.pointerToName(beg, name));
            }
            if (args.size() > fn.getArgCount()) {
                throw this.exception(beg, "Too many arguments for function '" + name + "', expected: " + fn.getArgCount() + ", got: " + args.size(), MathCompiler.Companion.pointerToName(beg, name));
            }
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FunctionExpr(name, fn, thisCollection$iv.toArray(new Expression[0]));
    }

    private final ConstantExpr parsePeriod(int beg) {
        int n;
        int timeEnd = StringsKt.indexOf$default((CharSequence)this.expression, (char)']', (int)(beg + 1), (boolean)false, (int)4, null);
        if (timeEnd == -1) {
            throw MathCompiler.exception$default(this, beg, "Cannot find time literal closing bracket.", null, 4, null);
        }
        int beg2 = beg + 1;
        if (this.expression.charAt(beg2) == '-') {
            ++beg2;
            n = -1;
        } else if (this.expression.charAt(beg2) == '+') {
            ++beg2;
            n = 1;
        } else {
            n = 1;
        }
        int sign = n;
        String string = this.expression.substring(beg2, timeEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String timeStr = string;
        this.offset = timeEnd;
        Long l = TimeUtils.parseTime(timeStr);
        if (l == null) {
            throw this.exception(this.offset, "Unknown time format", CollectionsKt.toMutableList((Iterable)((Iterable)new IntRange(beg2, timeEnd))));
        }
        long parsedTime = l;
        return new ConstantExpr((double)sign * (double)parsedTime, ConstantExprType.TIME);
    }

    private final MathEvaluateException exception(int ofs, String txt, Collection<Integer> pointers) {
        String errMsg = '\n' + txt + " at offset " + ofs + " in expression: \n\"" + this.expression + '\"';
        int max = 0;
        pointers.add(ofs);
        Iterator<Integer> iterator = pointers.iterator();
        while (iterator.hasNext()) {
            int pointer = ((Number)iterator.next()).intValue();
            if (pointer <= max) continue;
            max = pointer;
        }
        Companion pointer = Companion;
        int times$iv = max + 2;
        boolean $i$f$spaces = false;
        char[] spaces$iv = new char[times$iv];
        Arrays.fill(spaces$iv, ' ');
        StringBuilder pointerStr = new StringBuilder(new String(spaces$iv));
        pointers.forEach(arg_0 -> MathCompiler.exception$lambda$6(pointerStr, arg_0));
        return new MathEvaluateException(errMsg + '\n' + pointerStr, null, 2, null);
    }

    static /* synthetic */ MathEvaluateException exception$default(MathCompiler mathCompiler, int n, String string, Collection collection, int n2, Object object) {
        if ((n2 & 4) != 0) {
            collection = new ArrayList();
        }
        return mathCompiler.exception(n, string, collection);
    }

    private static final Unit build$lambda$0(ArrayList $list, Ref.BooleanRef $includesFunction, LexicalEnvironment x) {
        $list.add(x.getIndex());
        if (!$includesFunction.element) {
            $includesFunction.element = x.isFunction();
        }
        return Unit.INSTANCE;
    }

    private static final void build$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void exception$lambda$6(StringBuilder $pointerStr, int x) {
        $pointerStr.setCharAt(x + 1, '^');
    }

    private static final Double EMPTY_VARS$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        throw new IllegalAccessError();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Double> getConstants() {
        return Companion.getConstants();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Function> getFunctions() {
        return Companion.getFunctions();
    }

    @JvmStatic
    @NotNull
    public static final Expression compile(@Nullable String expression) throws NumberFormatException, ArithmeticException {
        return Companion.compile(expression);
    }

    @JvmStatic
    @NotNull
    public static final MathExpression partiallyReplace(@NotNull MathExpression expression, @NotNull MathematicalVariableTranslator variables) {
        return Companion.partiallyReplace(expression, variables);
    }

    @JvmStatic
    private static final Expression replace(Expression expression, MathematicalVariableTranslator variables) {
        return MathCompiler.Companion.replace(expression, variables);
    }

    static {
        MathCompiler.Companion.registerOperators();
        MathCompiler.Companion.registerFunctions();
        MathCompiler.Companion.registerConstants();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\n"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Arity;", "", "<init>", "(Ljava/lang/String;I)V", "UNARY", "BINARY", "UNARY_AND_BINARY", "isUnary", "", "isUnary$core", "core"})
    public static final class Arity
    extends Enum<Arity> {
        public static final /* enum */ Arity UNARY = new Arity();
        public static final /* enum */ Arity BINARY = new Arity();
        public static final /* enum */ Arity UNARY_AND_BINARY = new Arity();
        private static final /* synthetic */ Arity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isUnary$core() {
            return this == UNARY || this == UNARY_AND_BINARY;
        }

        public static Arity[] values() {
            return (Arity[])$VALUES.clone();
        }

        public static Arity valueOf(String value) {
            return Enum.valueOf(Arity.class, value);
        }

        @NotNull
        public static EnumEntries<Arity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = arityArray = new Arity[]{Arity.UNARY, Arity.BINARY, Arity.UNARY_AND_BINARY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$BiOperation;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "left", "op", "Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "right", "<init>", "(Lorg/kingdoms/utils/compilers/MathCompiler$Expression;Lorg/kingdoms/utils/compilers/MathCompiler$Operator;Lorg/kingdoms/utils/compilers/MathCompiler$Expression;)V", "getLeft$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "getOp$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "getRight$core", "eval", "", "variables", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "(Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;)Ljava/lang/Double;", "getVariables", "", "", "asString", "pretty", "", "toString", "core"})
    public static final class BiOperation
    extends Expression {
        @NotNull
        private final Expression left;
        @NotNull
        private final Operator op;
        @NotNull
        private final Expression right;

        public BiOperation(@NotNull Expression left, @NotNull Operator op, @NotNull Expression right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @NotNull
        public final Expression getLeft$core() {
            return this.left;
        }

        @NotNull
        public final Operator getOp$core() {
            return this.op;
        }

        @NotNull
        public final Expression getRight$core() {
            return this.right;
        }

        @Override
        @NotNull
        public Double eval(@NotNull MathematicalVariableTranslator variables) {
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            return this.op.getFunction$core().apply(this.left.eval(variables), this.right.eval(variables));
        }

        @Override
        @NotNull
        public Set<String> getVariables() {
            return SetsKt.plus(this.left.getVariables(), (Iterable)this.right.getVariables());
        }

        @Override
        @NotNull
        public String asString(boolean pretty) {
            return this.left.asString(pretty) + ' ' + this.op.getSymbol() + ' ' + this.right.asString(pretty);
        }

        @NotNull
        public String toString() {
            return "" + '(' + this.left + ' ' + this.op.getSymbol() + (this.op.getSymbol() == '(' ? "" : Character.valueOf(' ')) + this.right + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0007J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\"\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"H\u0002J*\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"H\u0002J\u0012\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0011H\u0007J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0011H\u0003J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0013\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020\rH\u0082\bJ\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/2\u0006\u00100\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0011\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\"H\u0082\bJ\u0012\u00103\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003R\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u0016\u0010\u0010\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0003R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Companion;", "", "<init>", "()V", "CONSTANTS", "", "", "", "getCONSTANTS$annotations", "FUNCTIONS", "Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "getFUNCTIONS$annotations", "OPERATORS", "", "Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "getOPERATORS$annotations", "EMPTY_VARS", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "getEMPTY_VARS$annotations", "DEFAULT_VALUE", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "getConstants", "getFunctions", "op", "", "opr", "registerConstants", "registerOperators", "registerFunctions", "fn", "name", "handler", "Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "argCount", "", "optimizable", "", "compile", "expression", "partiallyReplace", "Lorg/kingdoms/utils/compilers/expressions/MathExpression;", "variables", "replace", "optimize", "getOperator", "chr", "pointerToName", "", "from", "spaces", "times", "findFunction", "core"})
    @SourceDebugExtension(value={"SMAP\nMathCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,965:1\n13402#2,2:966\n37#3:968\n36#3,3:969\n37#3:972\n36#3,3:973\n*S KotlinDebug\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$Companion\n*L\n707#1:966,2\n881#1:968\n881#1:969,3\n928#1:972\n928#1:973,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getCONSTANTS$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getFUNCTIONS$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getOPERATORS$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getEMPTY_VARS$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Map<String, Double> getConstants() {
            return CONSTANTS;
        }

        @JvmStatic
        @NotNull
        public final Map<String, Function> getFunctions() {
            return FUNCTIONS;
        }

        private final void op(Operator opr) {
            if (opr.getSymbolAliases().length == 0) {
                OPERATORS.put(Character.valueOf(opr.getSymbol()), opr);
            } else {
                Character[] $this$forEach$iv = opr.getSymbolAliases();
                boolean $i$f$forEach = false;
                for (Character element$iv : $this$forEach$iv) {
                    char symbol = element$iv.charValue();
                    boolean bl = false;
                    Character c = Character.valueOf(symbol);
                    OPERATORS.put(c, opr);
                }
            }
        }

        private final void registerConstants() {
            CONSTANTS.put("E", Math.E);
            CONSTANTS.put("\u03b3", 0.5772156649);
            CONSTANTS.put("\u03c0", Math.PI);
            CONSTANTS.put("PI", Math.PI);
            CONSTANTS.put("LN2", 0.693147180559945);
            CONSTANTS.put("LN10", 2.302585092994046);
            CONSTANTS.put("LOG2E", 1.442695040888963);
            CONSTANTS.put("LOG10E", 0.434294481903252);
            CONSTANTS.put("PHI", 1.618033988749895);
            CONSTANTS.put("\u03c6", 1.618033988749895);
        }

        private final void registerOperators() {
            this.op(new Operator('^', new Character[0], 12, 13, Side.NONE, Companion::registerOperators$lambda$1));
            Character[] characterArray = new Character[]{Character.valueOf('*'), Character.valueOf('\u00d7'), Character.valueOf('\u22c5')};
            this.op(new Operator(characterArray, 10, Companion::registerOperators$lambda$2));
            this.op(new Operator('(', 10, Companion::registerOperators$lambda$3));
            characterArray = new Character[]{Character.valueOf('/'), Character.valueOf('\u00f7')};
            this.op(new Operator(characterArray, 10, Companion::registerOperators$lambda$4));
            this.op(new Operator('%', 10, Companion::registerOperators$lambda$5));
            this.op(new Operator('+', 9, Companion::registerOperators$lambda$6));
            characterArray = new Character[]{Character.valueOf('-'), Character.valueOf('\u2212')};
            this.op(new Operator(characterArray, 9, Companion::registerOperators$lambda$7));
            this.op(new Operator('\u221a', 9, Companion::registerOperators$lambda$8));
            this.op(new Operator('~', 10, Companion::registerOperators$lambda$9));
            this.op(new Operator('@', 8, Companion::registerOperators$lambda$10));
            this.op(new Operator('#', 8, Companion::registerOperators$lambda$11));
            this.op(new Operator('>', 8, Companion::registerOperators$lambda$12));
            this.op(new Operator('<', 8, Companion::registerOperators$lambda$13));
            this.op(new Operator('$', 8, Companion::registerOperators$lambda$14));
            this.op(new Operator('&', 7, Companion::registerOperators$lambda$15));
            this.op(new Operator('!', 6, Companion::registerOperators$lambda$16));
            this.op(new Operator('|', 5, Companion::registerOperators$lambda$17));
        }

        private final void registerFunctions() {
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "abs", Companion::registerFunctions$lambda$18, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "acos", Companion::registerFunctions$lambda$19, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "asin", Companion::registerFunctions$lambda$20, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "atan", Companion::registerFunctions$lambda$21, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "cbrt", Companion::registerFunctions$lambda$22, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "ceil", Companion::registerFunctions$lambda$23, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "cos", Companion::registerFunctions$lambda$24, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "cosh", Companion::registerFunctions$lambda$25, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "exp", Companion::registerFunctions$lambda$26, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "expm1", Companion::registerFunctions$lambda$27, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "floor", Companion::registerFunctions$lambda$28, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "getExponent", Companion::registerFunctions$lambda$29, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "log", Companion::registerFunctions$lambda$30, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "log10", Companion::registerFunctions$lambda$31, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "log1p", Companion::registerFunctions$lambda$32, 0, 4, null);
            this.fn("max", Companion::registerFunctions$lambda$33, -2);
            this.fn("min", Companion::registerFunctions$lambda$34, -2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "nextUp", Companion::registerFunctions$lambda$35, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "nextDown", Companion::registerFunctions$lambda$36, 0, 4, null);
            this.fn("nextAfter", Companion::registerFunctions$lambda$37, 2);
            this.fn("random", false, Companion::registerFunctions$lambda$38, 2);
            this.fn("randInt", false, Companion::registerFunctions$lambda$39, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "round", Companion::registerFunctions$lambda$40, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "rint", Companion::registerFunctions$lambda$41, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "signum", Companion::registerFunctions$lambda$42, 0, 4, null);
            this.fn("whatPercentOf", Companion::registerFunctions$lambda$43, 2);
            this.fn("percentOf", Companion::registerFunctions$lambda$44, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "sin", Companion::registerFunctions$lambda$45, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "sinh", Companion::registerFunctions$lambda$46, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "bits", Companion::registerFunctions$lambda$47, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "hash", Companion::registerFunctions$lambda$48, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "identityHash", Companion::registerFunctions$lambda$49, 0, 4, null);
            this.fn("time", false, Companion::registerFunctions$lambda$50, 0);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "sqrt", Companion::registerFunctions$lambda$51, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "tan", Companion::registerFunctions$lambda$52, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "tanh", Companion::registerFunctions$lambda$53, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "toDegrees", Companion::registerFunctions$lambda$54, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "toRadians", Companion::registerFunctions$lambda$55, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "ulp", Companion::registerFunctions$lambda$56, 0, 4, null);
            this.fn("scalb", Companion::registerFunctions$lambda$57, 2);
            this.fn("hypot", Companion::registerFunctions$lambda$58, 2);
            this.fn("copySign", Companion::registerFunctions$lambda$59, 2);
            this.fn("IEEEremainder", Companion::registerFunctions$lambda$60, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "naturalSum", Companion::registerFunctions$lambda$61, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "reverse", Companion::registerFunctions$lambda$62, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "reverseBytes", Companion::registerFunctions$lambda$63, 0, 4, null);
            this.fn("eq", Companion::registerFunctions$lambda$64, 4);
            this.fn("ne", Companion::registerFunctions$lambda$65, 4);
            this.fn("gt", Companion::registerFunctions$lambda$66, 4);
            this.fn("lt", Companion::registerFunctions$lambda$67, 4);
            this.fn("ge", Companion::registerFunctions$lambda$68, 4);
            this.fn("le", Companion::registerFunctions$lambda$69, 4);
        }

        private final void fn(String name, QuantumFunction handler, int argCount) {
            this.fn(name, true, handler, argCount);
        }

        static /* synthetic */ void fn$default(Companion companion, String string, QuantumFunction quantumFunction, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1;
            }
            companion.fn(string, quantumFunction, n);
        }

        private final void fn(String name, boolean optimizable, QuantumFunction handler, int argCount) {
            FUNCTIONS.put(name, new Function(handler, optimizable, argCount));
        }

        static /* synthetic */ void fn$default(Companion companion, String string, boolean bl, QuantumFunction quantumFunction, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 1;
            }
            companion.fn(string, bl, quantumFunction, n);
        }

        @JvmStatic
        @NotNull
        public final Expression compile(@Nullable String expression) throws NumberFormatException, ArithmeticException {
            CharSequence charSequence = expression;
            if (charSequence == null || charSequence.length() == 0) {
                return DEFAULT_VALUE;
            }
            return this.optimize(new MathCompiler(expression, 0, 0, false, null, 30, null).compile()).withOriginalString(expression);
        }

        @JvmStatic
        @NotNull
        public final MathExpression partiallyReplace(@NotNull MathExpression expression, @NotNull MathematicalVariableTranslator variables) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            if (!(expression instanceof Expression)) {
                throw new IllegalArgumentException("Unsupported math expression: " + expression + " (" + expression.getClass() + ')');
            }
            return this.optimize(this.replace((Expression)expression, variables));
        }

        @JvmStatic
        private final Expression replace(Expression expression, MathematicalVariableTranslator variables) {
            Expression expression2 = expression;
            if (expression2 instanceof Variable) {
                ConstantExpr constantExpr;
                Double result = ((Variable)expression).tryReplace(variables);
                if (result == null) {
                    return expression;
                }
                ConstantExpr $this$replace_u24lambda_u2470 = constantExpr = new ConstantExpr(result, ConstantExprType.NUMBER);
                boolean bl = false;
                $this$replace_u24lambda_u2470.setOriginalString$core(expression.getOriginalString$core());
                return constantExpr;
            }
            if (expression2 instanceof BiOperation) {
                Expression lhs = this.replace(((BiOperation)expression).getLeft$core(), variables);
                Expression rhs = this.replace(((BiOperation)expression).getRight$core(), variables);
                if (lhs != ((BiOperation)expression).getLeft$core() || rhs != ((BiOperation)expression).getRight$core()) {
                    BiOperation $this$replace_u24lambda_u2470;
                    BiOperation $this$replace_u24lambda_u2471 = $this$replace_u24lambda_u2470 = new BiOperation(lhs, ((BiOperation)expression).getOp$core(), rhs);
                    boolean bl = false;
                    $this$replace_u24lambda_u2471.setOriginalString$core(expression.getOriginalString$core());
                    return $this$replace_u24lambda_u2470;
                }
                return expression;
            }
            if (expression2 instanceof FunctionExpr) {
                Expression expression3;
                ArrayList<Expression> newParameters = new ArrayList<Expression>(((FunctionExpr)expression).getArgs$core().length);
                boolean changed = false;
                for (Expression arg : ((FunctionExpr)expression).getArgs$core()) {
                    Expression replaced = this.replace(arg, variables);
                    newParameters.add(replaced);
                    if (arg == replaced) continue;
                    changed = true;
                }
                if (changed) {
                    Collection $this$toTypedArray$iv = newParameters;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    expression3 = new FunctionExpr(((FunctionExpr)expression).getName$core(), ((FunctionExpr)expression).getHandler$core(), thisCollection$iv.toArray(new Expression[0]));
                } else {
                    expression3 = expression;
                }
                return expression3;
            }
            return expression;
        }

        private final Expression optimize(Expression expression) {
            Expression expression2 = expression;
            if (expression2 instanceof BiOperation) {
                Expression lhs = this.optimize(((BiOperation)expression).getLeft$core());
                Expression rhs = this.optimize(((BiOperation)expression).getRight$core());
                if (lhs instanceof ConstantExpr && rhs instanceof ConstantExpr) {
                    return new ConstantExpr(((BiOperation)expression).getOp$core().getFunction$core().apply(((ConstantExpr)lhs).getValue(), ((ConstantExpr)rhs).getValue()), ConstantExprType.OPTIMIZED);
                }
                if (lhs != ((BiOperation)expression).getLeft$core() || rhs != ((BiOperation)expression).getRight$core()) {
                    BiOperation biOperation;
                    BiOperation $this$optimize_u24lambda_u2472 = biOperation = new BiOperation(lhs, ((BiOperation)expression).getOp$core(), rhs);
                    boolean bl = false;
                    $this$optimize_u24lambda_u2472.setOriginalString$core(expression.getOriginalString$core());
                    return biOperation;
                }
            } else if (expression2 instanceof FunctionExpr) {
                Expression expression3;
                if (!((FunctionExpr)expression).getHandler$core().getOptimizable$core()) {
                    return expression;
                }
                boolean allOptimized = true;
                ArrayList<Expression> newParameters = new ArrayList<Expression>(((FunctionExpr)expression).getArgs$core().length);
                for (Expression arg : ((FunctionExpr)expression).getArgs$core()) {
                    Expression optimized = this.optimize(arg);
                    newParameters.add(optimized);
                    if (!allOptimized) continue;
                    allOptimized = optimized instanceof ConstantExpr;
                }
                if (allOptimized) {
                    expression3 = new ConstantExpr(((FunctionExpr)expression).getHandler$core().getFunction$core().apply(new FnArgs((FunctionExpr)expression, EMPTY_VARS)), ConstantExprType.OPTIMIZED);
                } else {
                    Collection $this$toTypedArray$iv = newParameters;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    expression3 = new FunctionExpr(((FunctionExpr)expression).getName$core(), ((FunctionExpr)expression).getHandler$core(), thisCollection$iv.toArray(new Expression[0]));
                }
                return expression3;
            }
            return expression;
        }

        private final Operator getOperator(char chr) {
            boolean $i$f$getOperator = false;
            return OPERATORS.get(Character.valueOf(chr));
        }

        private final Collection<Integer> pointerToName(int from, String name) {
            List pointers = new ArrayList(name.length());
            int n = name.length();
            for (int i = 1; i < n; ++i) {
                pointers.add(from + i);
            }
            return pointers;
        }

        private final String spaces(int times) {
            boolean $i$f$spaces = false;
            char[] spaces = new char[times];
            Arrays.fill(spaces, ' ');
            return new String(spaces);
        }

        private final String findFunction(String name) {
            String string = name;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String lowerCaseName = string2;
            Optional<Object> exact = FUNCTIONS.keySet().stream().filter(arg_0 -> Companion.findFunction$lambda$74(arg_0 -> Companion.findFunction$lambda$73(lowerCaseName, arg_0), arg_0)).findFirst();
            return exact.orElseGet(() -> Companion.findFunction$lambda$77(lowerCaseName));
        }

        private static final double registerOperators$lambda$1(double a, double b) {
            return Math.pow(a, b);
        }

        private static final double registerOperators$lambda$2(double a, double b) {
            return a * b;
        }

        private static final double registerOperators$lambda$3(double a, double b) {
            return a * b;
        }

        private static final double registerOperators$lambda$4(double a, double b) {
            return a / b;
        }

        private static final double registerOperators$lambda$5(double a, double b) {
            return a % b;
        }

        private static final double registerOperators$lambda$6(double a, double b) {
            return Double.sum(a, b);
        }

        private static final double registerOperators$lambda$7(double a, double b) {
            return a - b;
        }

        private static final double registerOperators$lambda$8(double d, double b) {
            return Math.sqrt(b);
        }

        private static final double registerOperators$lambda$9(double d, double b) {
            return (long)b ^ 0xFFFFFFFFFFFFFFFFL;
        }

        private static final double registerOperators$lambda$10(double a, double b) {
            return Long.rotateLeft((long)a, (int)b);
        }

        private static final double registerOperators$lambda$11(double a, double b) {
            return Long.rotateRight((long)a, (int)b);
        }

        private static final double registerOperators$lambda$12(double a, double b) {
            return (long)a >> (int)b;
        }

        private static final double registerOperators$lambda$13(double a, double b) {
            return (long)a << (int)b;
        }

        private static final double registerOperators$lambda$14(double a, double b) {
            return (long)a >>> (int)b;
        }

        private static final double registerOperators$lambda$15(double a, double b) {
            return (long)a & (long)b;
        }

        private static final double registerOperators$lambda$16(double a, double b) {
            return (long)a ^ (long)b;
        }

        private static final double registerOperators$lambda$17(double a, double b) {
            return (long)a | (long)b;
        }

        private static final double registerFunctions$lambda$18(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.abs(p.next());
        }

        private static final double registerFunctions$lambda$19(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.acos(p.next());
        }

        private static final double registerFunctions$lambda$20(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.asin(p.next());
        }

        private static final double registerFunctions$lambda$21(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.atan(p.next());
        }

        private static final double registerFunctions$lambda$22(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.cbrt(p.next());
        }

        private static final double registerFunctions$lambda$23(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.ceil(p.next());
        }

        private static final double registerFunctions$lambda$24(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.cos(p.next());
        }

        private static final double registerFunctions$lambda$25(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.cosh(p.next());
        }

        private static final double registerFunctions$lambda$26(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.exp(p.next());
        }

        private static final double registerFunctions$lambda$27(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.expm1(p.next());
        }

        private static final double registerFunctions$lambda$28(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.floor(p.next());
        }

        private static final double registerFunctions$lambda$29(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.getExponent(p.next());
        }

        private static final double registerFunctions$lambda$30(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.log(p.next());
        }

        private static final double registerFunctions$lambda$31(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.log10(p.next());
        }

        private static final double registerFunctions$lambda$32(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.log1p(p.next());
        }

        private static final double registerFunctions$lambda$33(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return CollectionsKt.maxOrThrow((Iterable)p.allArgs());
        }

        private static final double registerFunctions$lambda$34(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return CollectionsKt.minOrThrow((Iterable)p.allArgs());
        }

        private static final double registerFunctions$lambda$35(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.nextUp(p.next());
        }

        private static final double registerFunctions$lambda$36(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.nextDown(p.next());
        }

        private static final double registerFunctions$lambda$37(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.nextAfter(p.next(), p.next());
        }

        private static final double registerFunctions$lambda$38(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return ThreadLocalRandom.current().nextDouble(p.next(), p.next() + 1.0);
        }

        private static final double registerFunctions$lambda$39(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return ThreadLocalRandom.current().nextInt((int)p.next(), (int)p.next() + 1);
        }

        private static final double registerFunctions$lambda$40(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.round(p.next());
        }

        private static final double registerFunctions$lambda$41(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.rint(p.next());
        }

        private static final double registerFunctions$lambda$42(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.signum(p.next());
        }

        private static final double registerFunctions$lambda$43(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() / p.next() * (double)100;
        }

        private static final double registerFunctions$lambda$44(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() / (double)100 * p.next();
        }

        private static final double registerFunctions$lambda$45(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.sin(p.next());
        }

        private static final double registerFunctions$lambda$46(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.sinh(p.next());
        }

        private static final double registerFunctions$lambda$47(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Double.doubleToRawLongBits(p.next());
        }

        private static final double registerFunctions$lambda$48(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Double.hashCode(p.next());
        }

        private static final double registerFunctions$lambda$49(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return System.identityHashCode(p.next());
        }

        private static final double registerFunctions$lambda$50(FnArgs it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return System.currentTimeMillis();
        }

        private static final double registerFunctions$lambda$51(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.sqrt(p.next());
        }

        private static final double registerFunctions$lambda$52(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.tan(p.next());
        }

        private static final double registerFunctions$lambda$53(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.tanh(p.next());
        }

        private static final double registerFunctions$lambda$54(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.toDegrees(p.next());
        }

        private static final double registerFunctions$lambda$55(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.toRadians(p.next());
        }

        private static final double registerFunctions$lambda$56(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.ulp(p.next());
        }

        private static final double registerFunctions$lambda$57(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.scalb(p.next(), (int)p.next());
        }

        private static final double registerFunctions$lambda$58(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.hypot(p.next(), p.next());
        }

        private static final double registerFunctions$lambda$59(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.copySign(p.next(), p.next());
        }

        private static final double registerFunctions$lambda$60(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.IEEEremainder(p.next(), p.next());
        }

        private static final double registerFunctions$lambda$61(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = (int)p.next();
            return (double)(n * (n + 1)) / 2.0;
        }

        private static final double registerFunctions$lambda$62(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Long.reverse((long)p.next());
        }

        private static final double registerFunctions$lambda$63(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Long.reverseBytes((long)p.next());
        }

        private static final double registerFunctions$lambda$64(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() == p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda$65(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return !(p.next() == p.next()) ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda$66(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() > p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda$67(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() < p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda$68(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() >= p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda$69(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() <= p.next() ? p.next() : p.next(3);
        }

        private static final boolean findFunction$lambda$73(String $lowerCaseName, String x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            String string = x;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return Intrinsics.areEqual((Object)$lowerCaseName, (Object)string2);
        }

        private static final boolean findFunction$lambda$74(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean findFunction$lambda$77$lambda$75(String $lowerCaseName, String x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            String string = x;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String fn = string2;
            return (StringsKt.contains$default((CharSequence)$lowerCaseName, (CharSequence)fn, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fn, (CharSequence)$lowerCaseName, (boolean)false, (int)2, null)) && Math.abs(fn.length() - $lowerCaseName.length()) < 2;
        }

        private static final boolean findFunction$lambda$77$lambda$76(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final String findFunction$lambda$77(String $lowerCaseName) {
            return FUNCTIONS.keySet().stream().filter(arg_0 -> Companion.findFunction$lambda$77$lambda$76(arg_0 -> Companion.findFunction$lambda$77$lambda$75($lowerCaseName, arg_0), arg_0)).findFirst().orElse(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExpr;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "value", "", "type", "Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;", "<init>", "(DLorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;)V", "getValue", "()D", "getType", "()Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;", "isConstant", "", "()Z", "eval", "variables", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "(Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;)Ljava/lang/Double;", "asString", "", "pretty", "toString", "core"})
    public static class ConstantExpr
    extends Expression {
        private final double value;
        @NotNull
        private final ConstantExprType type;
        private final boolean isConstant;

        public ConstantExpr(double value, @NotNull ConstantExprType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.value = value;
            this.type = type;
            this.isConstant = true;
        }

        public final double getValue() {
            return this.value;
        }

        @NotNull
        public final ConstantExprType getType() {
            return this.type;
        }

        @Override
        public boolean isConstant() {
            return this.isConstant;
        }

        @Override
        @NotNull
        public Double eval(@NotNull MathematicalVariableTranslator variables) {
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            return this.value;
        }

        @Override
        @NotNull
        public String asString(boolean pretty) {
            return String.valueOf(this.value);
        }

        @NotNull
        public String toString() {
            return "ConstantExpr(" + (this == DEFAULT_VALUE ? "DEFAULT" : Double.valueOf(this.value)) + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;", "", "<init>", "(Ljava/lang/String;I)V", "OPTIMIZED", "NUMBER", "STRING", "CONSTANT_VARIABLE", "TIME", "core"})
    public static final class ConstantExprType
    extends Enum<ConstantExprType> {
        public static final /* enum */ ConstantExprType OPTIMIZED = new ConstantExprType();
        public static final /* enum */ ConstantExprType NUMBER = new ConstantExprType();
        public static final /* enum */ ConstantExprType STRING = new ConstantExprType();
        public static final /* enum */ ConstantExprType CONSTANT_VARIABLE = new ConstantExprType();
        public static final /* enum */ ConstantExprType TIME = new ConstantExprType();
        private static final /* synthetic */ ConstantExprType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstantExprType[] values() {
            return (ConstantExprType[])$VALUES.clone();
        }

        public static ConstantExprType valueOf(String value) {
            return Enum.valueOf(ConstantExprType.class, value);
        }

        @NotNull
        public static EnumEntries<ConstantExprType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constantExprTypeArray = new ConstantExprType[]{ConstantExprType.OPTIMIZED, ConstantExprType.NUMBER, ConstantExprType.STRING, ConstantExprType.CONSTANT_VARIABLE, ConstantExprType.TIME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0005J,\u0010\u0018\u001a\u00020\u0010\"\b\b\u0000\u0010\u0019*\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001dR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "Lorg/kingdoms/utils/compilers/expressions/MathExpression;", "<init>", "()V", "originalString", "", "getOriginalString$core", "()Ljava/lang/String;", "setOriginalString$core", "(Ljava/lang/String;)V", "eval", "", "variables", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "(Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;)Ljava/lang/Double;", "isConstant", "", "()Z", "getVariables", "", "isDefault", "getOriginalString", "withOriginalString", "string", "contains", "T", "ofType", "Ljava/lang/Class;", "predicate", "Ljava/util/function/Predicate;", "core"})
    @SourceDebugExtension(value={"SMAP\nMathCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$Expression\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,965:1\n12567#2,2:966\n*S KotlinDebug\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$Expression\n*L\n554#1:966,2\n*E\n"})
    public static abstract class Expression
    implements MathExpression {
        @Nullable
        private String originalString;
        private final boolean isConstant;

        @Nullable
        public final String getOriginalString$core() {
            return this.originalString;
        }

        public final void setOriginalString$core(@Nullable String string) {
            this.originalString = string;
        }

        @Override
        @NotNull
        public abstract Double eval(@NotNull MathematicalVariableTranslator var1);

        @Override
        public boolean isConstant() {
            return this.isConstant;
        }

        @Override
        @NotNull
        public Set<String> getVariables() {
            return SetsKt.emptySet();
        }

        @Override
        public boolean isDefault() {
            return this == DEFAULT_VALUE;
        }

        @Override
        @Nullable
        public String getOriginalString() {
            return this.originalString;
        }

        @NotNull
        public final Expression withOriginalString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.originalString = string;
            return this;
        }

        public final <T extends Expression> boolean contains(@NotNull Class<T> ofType, @NotNull Predicate<T> predicate) {
            boolean bl;
            block7: {
                Expression expression;
                Intrinsics.checkNotNullParameter(ofType, (String)"ofType");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                if (ofType.isInstance(this)) {
                    Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type T of org.kingdoms.utils.compilers.MathCompiler.Expression.contains");
                    if (predicate.test(this)) {
                        return true;
                    }
                }
                if ((expression = this) instanceof BiOperation) {
                    bl = ((BiOperation)this).getLeft$core().contains(ofType, predicate) || ((BiOperation)this).getRight$core().contains(ofType, predicate);
                } else if (expression instanceof FunctionExpr) {
                    Expression[] $this$any$iv = ((FunctionExpr)this).getArgs$core();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Expression element$iv;
                        Expression x = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!x.contains(ofType, predicate)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u000bH\u0086\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$FnArgs;", "", "func", "Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;", "variables", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "<init>", "(Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;)V", "index", "", "next", "", "allArgs", "", "i", "core"})
    @SourceDebugExtension(value={"SMAP\nMathCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$FnArgs\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,965:1\n11158#2:966\n11493#2,3:967\n1#3:970\n*S KotlinDebug\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$FnArgs\n*L\n671#1:966\n671#1:967,3\n*E\n"})
    public static final class FnArgs {
        @NotNull
        private final FunctionExpr func;
        @NotNull
        private final MathematicalVariableTranslator variables;
        private int index;

        public FnArgs(@NotNull FunctionExpr func, @NotNull MathematicalVariableTranslator variables) {
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            this.func = func;
            this.variables = variables;
        }

        public final double next() {
            int n = this.index;
            this.index = n + 1;
            return this.func.getArgs$core()[n].eval(this.variables);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Double> allArgs() {
            void $this$mapTo$iv$iv;
            Expression[] $this$map$iv = this.func.getArgs$core();
            boolean $i$f$map = false;
            Expression[] expressionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void x;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.valueOf(x.eval(this.variables)));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final double next(int i) {
            void it;
            int n;
            int n2 = n = i;
            Expression[] expressionArray = this.func.getArgs$core();
            boolean bl = false;
            this.index = it;
            return expressionArray[n].eval(this.variables);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "", "function", "Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "optimizable", "", "argCount", "", "<init>", "(Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;ZI)V", "getFunction$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "getOptimizable$core", "()Z", "getArgCount", "()I", "core"})
    public static final class Function {
        @NotNull
        private final QuantumFunction function;
        private final boolean optimizable;
        private final int argCount;

        public Function(@NotNull QuantumFunction function, boolean optimizable, int argCount) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.function = function;
            this.optimizable = optimizable;
            this.argCount = argCount;
        }

        @NotNull
        public final QuantumFunction getFunction$core() {
            return this.function;
        }

        public final boolean getOptimizable$core() {
            return this.optimizable;
        }

        public final int getArgCount() {
            return this.argCount;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "name", "", "handler", "Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "args", "", "<init>", "(Ljava/lang/String;Lorg/kingdoms/utils/compilers/MathCompiler$Function;[Lorg/kingdoms/utils/compilers/MathCompiler$Expression;)V", "getName$core", "()Ljava/lang/String;", "getHandler$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "getArgs$core", "()[Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "[Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "eval", "", "variables", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "(Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;)Ljava/lang/Double;", "getVariables", "", "asString", "pretty", "", "toString", "core"})
    @SourceDebugExtension(value={"SMAP\nMathCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$FunctionExpr\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,965:1\n13402#2,2:966\n*S KotlinDebug\n*F\n+ 1 MathCompiler.kt\norg/kingdoms/utils/compilers/MathCompiler$FunctionExpr\n*L\n610#1:966,2\n*E\n"})
    public static final class FunctionExpr
    extends Expression {
        @NotNull
        private final String name;
        @NotNull
        private final Function handler;
        @NotNull
        private final Expression[] args;

        public FunctionExpr(@NotNull String name, @NotNull Function handler, @NotNull Expression[] args) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.name = name;
            this.handler = handler;
            this.args = args;
        }

        @NotNull
        public final String getName$core() {
            return this.name;
        }

        @NotNull
        public final Function getHandler$core() {
            return this.handler;
        }

        @NotNull
        public final Expression[] getArgs$core() {
            return this.args;
        }

        @Override
        @NotNull
        public Double eval(@NotNull MathematicalVariableTranslator variables) {
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            return this.handler.getFunction$core().apply(new FnArgs(this, variables));
        }

        @Override
        @NotNull
        public Set<String> getVariables() {
            Set vars = new HashSet();
            Expression[] $this$forEach$iv = this.args;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Expression element$iv;
                Expression it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                vars.addAll((Collection)it.getVariables());
            }
            return vars;
        }

        @Override
        @NotNull
        public String asString(boolean pretty) {
            return this.name + '(' + ArraysKt.joinToString$default((Object[])this.args, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
        }

        @NotNull
        public String toString() {
            A[] AArray = Arrays.stream(this.args).map(arg_0 -> FunctionExpr.toString$lambda$2(FunctionExpr::toString$lambda$1, arg_0)).toArray(FunctionExpr::toString$lambda$3);
            Intrinsics.checkNotNullExpressionValue(AArray, (String)"toArray(...)");
            Object[] argsStr = (String[])AArray;
            return this.name + '(' + (this.args.length == 0 ? "" : ArraysKt.joinToString$default((Object[])argsStr, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) + ')';
        }

        private static final String toString$lambda$1(Expression obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.toString();
        }

        private static final String toString$lambda$2(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String[] toString$lambda$3(int size) {
            return new String[size];
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$LexicalEnvironment;", "", "index", "", "function", "Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "<init>", "(ILorg/kingdoms/utils/compilers/MathCompiler$Function;)V", "getIndex", "()I", "getFunction", "()Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "isFunction", "", "toString", "", "core"})
    public static final class LexicalEnvironment {
        private final int index;
        @Nullable
        private final Function function;

        public LexicalEnvironment(int index, @Nullable Function function) {
            this.index = index;
            this.function = function;
        }

        public final int getIndex() {
            return this.index;
        }

        @Nullable
        public final Function getFunction() {
            return this.function;
        }

        public final boolean isFunction() {
            return this.function != null;
        }

        @NotNull
        public String toString() {
            return "LexicalEnvironment{index=" + this.index + ", function=" + this.isFunction() + '}';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$MathEvaluateException;", "Ljava/lang/RuntimeException;", "Lorg/kingdoms/libs/kotlin/RuntimeException;", "msg", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "core"})
    public static final class MathEvaluateException
    extends RuntimeException {
        public MathEvaluateException(@NotNull String msg, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg, cause);
        }

        public /* synthetic */ MathEvaluateException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB!\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0011B'\b\u0016\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0013J\b\u0010\"\u001a\u00020#H\u0016J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006("}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "", "symbol", "", "symbolAliases", "", "precedenceL", "", "precedenceR", "side", "Lorg/kingdoms/utils/compilers/MathCompiler$Side;", "function", "Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;", "<init>", "(C[Ljava/lang/Character;IILorg/kingdoms/utils/compilers/MathCompiler$Side;Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;)V", "sym", "precedence", "(CILorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;)V", "syms", "([Ljava/lang/Character;ILorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;)V", "getSymbol", "()C", "getSymbolAliases", "()[Ljava/lang/Character;", "[Ljava/lang/Character;", "precedenceLeft", "", "precedenceRight", "arity", "Lorg/kingdoms/utils/compilers/MathCompiler$Arity;", "getArity$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Arity;", "getFunction$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;", "toString", "", "hasPrecedenceOver", "", "op", "hasPrecedenceOver$core", "core"})
    public static final class Operator {
        private final char symbol;
        @NotNull
        private final Character[] symbolAliases;
        private final byte precedenceLeft;
        private final byte precedenceRight;
        @NotNull
        private final Side side;
        @NotNull
        private final Arity arity;
        @NotNull
        private final TriDoubleFn function;

        public Operator(char symbol, @NotNull Character[] symbolAliases, int precedenceL, int precedenceR, @NotNull Side side, @NotNull TriDoubleFn function) {
            Arity arity;
            Intrinsics.checkNotNullParameter((Object)symbolAliases, (String)"symbolAliases");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.symbol = symbol;
            this.symbolAliases = symbolAliases;
            this.precedenceLeft = (byte)precedenceL;
            this.precedenceRight = (byte)precedenceR;
            this.side = side;
            this.function = function;
            switch (this.symbol) {
                case '-': {
                    arity = Arity.UNARY_AND_BINARY;
                    break;
                }
                case '~': {
                    arity = Arity.UNARY;
                    break;
                }
                default: {
                    arity = Arity.BINARY;
                }
            }
            this.arity = arity;
        }

        public final char getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final Character[] getSymbolAliases() {
            return this.symbolAliases;
        }

        @NotNull
        public final Arity getArity$core() {
            return this.arity;
        }

        @NotNull
        public final TriDoubleFn getFunction$core() {
            return this.function;
        }

        public Operator(char sym, int precedence, @NotNull TriDoubleFn function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this(sym, new Character[0], precedence, precedence, Side.NONE, function);
        }

        public Operator(@NotNull Character[] syms, int precedence, @NotNull TriDoubleFn function) {
            Intrinsics.checkNotNullParameter((Object)syms, (String)"syms");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this(((Character)ArraysKt.first((Object[])syms)).charValue(), syms, precedence, precedence, Side.NONE, function);
        }

        @NotNull
        public String toString() {
            return "MathOperator(" + this.symbol + ')';
        }

        public final boolean hasPrecedenceOver$core(@NotNull Operator op) {
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            return this.precedenceLeft >= op.precedenceLeft;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "", "apply", "", "params", "Lorg/kingdoms/utils/compilers/MathCompiler$FnArgs;", "core"})
    public static interface QuantumFunction {
        public double apply(@NotNull FnArgs var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Side;", "", "<init>", "(Ljava/lang/String;I)V", "RIGHT", "LEFT", "NONE", "core"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side RIGHT = new Side();
        public static final /* enum */ Side LEFT = new Side();
        public static final /* enum */ Side NONE = new Side();
        private static final /* synthetic */ Side[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value) {
            return Enum.valueOf(Side.class, value);
        }

        @NotNull
        public static EnumEntries<Side> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sideArray = new Side[]{Side.RIGHT, Side.LEFT, Side.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$StringConstant;", "Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExpr;", "string", "", "<init>", "(Ljava/lang/String;)V", "getString$core", "()Ljava/lang/String;", "isConstant", "", "()Z", "toString", "asString", "pretty", "core"})
    public static final class StringConstant
    extends ConstantExpr {
        @NotNull
        private final String string;
        private final boolean isConstant;

        public StringConstant(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            super(string.hashCode(), ConstantExprType.STRING);
            this.string = string;
            this.isConstant = true;
        }

        @NotNull
        public final String getString$core() {
            return this.string;
        }

        @Override
        public boolean isConstant() {
            return this.isConstant;
        }

        @Override
        @NotNull
        public String toString() {
            return "StringConstant(\"" + this.string + "\")";
        }

        @Override
        @NotNull
        public String asString(boolean pretty) {
            return '\'' + this.string + '\'';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;", "", "apply", "", "a", "b", "core"})
    public static interface TriDoubleFn {
        public double apply(double var1, double var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Variable;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "name", "", "<init>", "(Ljava/lang/String;)V", "tryReplace", "", "variables", "Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;", "(Lorg/kingdoms/utils/compilers/translators/MathematicalVariableTranslator;)Ljava/lang/Double;", "getVariables", "", "eval", "asString", "pretty", "", "toString", "core"})
    private static final class Variable
    extends Expression {
        @NotNull
        private final String name;

        public Variable(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Nullable
        public final Double tryReplace(@NotNull MathematicalVariableTranslator variables) {
            Double d;
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            try {
                d = (Double)variables.apply(this.name);
            }
            catch (StackOverflowError ex) {
                throw new MathEvaluateException("Circular variable: '" + this.name + '\'', null, 2, null);
            }
            catch (MathEvaluateException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new MathEvaluateException("Error while translating variable: '" + this.name + '\'', ex);
            }
            return d;
        }

        @Override
        @NotNull
        public Set<String> getVariables() {
            Object[] objectArray = new String[]{this.name};
            return SetsKt.hashSetOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public Double eval(@NotNull MathematicalVariableTranslator variables) {
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            Double value = this.tryReplace(variables);
            if (value == null) {
                String guessFn = Companion.findFunction(this.name);
                String suggestion = "";
                if (guessFn != null) {
                    suggestion = "; Did you mean to invoke '" + guessFn + "' function? If so, put parentheses after the name like '" + guessFn + "(args)'";
                }
                throw new MathEvaluateException("Unknown variable: '" + this.name + '\'' + suggestion, null, 2, null);
            }
            return value;
        }

        @Override
        @NotNull
        public String asString(boolean pretty) {
            return this.name;
        }

        @NotNull
        public String toString() {
            return "MathVariable(" + this.name + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Arity.values().length];
            try {
                nArray[Arity.BINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arity.UNARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arity.UNARY_AND_BINARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

