/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.commands;

import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.commands.ConfigCommand;
import org.kingdoms.utils.commands.ConfigCommandExecuter;
import org.kingdoms.utils.conditions.ConditionBranch;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/commands/CommandConditionMixin;", "", "entries", "Lorg/kingdoms/utils/conditions/ConditionChain;", "", "Lorg/kingdoms/utils/commands/ConfigCommand;", "<init>", "(Lorg/kingdoms/utils/conditions/ConditionChain;)V", "getEntries", "()Lorg/kingdoms/utils/conditions/ConditionChain;", "execute", "", "settings", "Lorg/kingdoms/utils/commands/ConfigCommandExecuter;", "Companion", "core"})
public final class CommandConditionMixin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConditionChain<List<ConfigCommand>> entries;

    public CommandConditionMixin(@NotNull ConditionChain<List<ConfigCommand>> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
    }

    @NotNull
    public final ConditionChain<List<ConfigCommand>> getEntries() {
        return this.entries;
    }

    public final void execute(@NotNull ConfigCommandExecuter settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CommandConditionMixin.Companion.execute(this.entries, settings);
    }

    @JvmStatic
    @NotNull
    public static final CommandConditionMixin parse(@NotNull ConfigSection section) {
        return Companion.parse(section);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/utils/commands/CommandConditionMixin$Companion;", "", "<init>", "()V", "execute", "", "chain", "Lorg/kingdoms/utils/conditions/ConditionChain;", "settings", "Lorg/kingdoms/utils/commands/ConfigCommandExecuter;", "parse", "Lorg/kingdoms/utils/commands/CommandConditionMixin;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void execute(ConditionChain<?> chain, ConfigCommandExecuter settings) {
            MessagePlaceholderProvider scrutinee = settings.getSettings();
            for (ConditionBranch<?> conditionBranch : chain.getCases()) {
                if (!ConditionProcessor.process(conditionBranch.getCondition(), scrutinee)) continue;
                Object item = conditionBranch.getCase();
                if (item instanceof ConditionChain) {
                    this.execute((ConditionChain)item, settings);
                    continue;
                }
                if (item instanceof List) {
                    ConfigCommand.execute(settings.getPlayer(), (List)item, settings.getSettings(), settings.getIgnoreIfPlayerNull());
                    continue;
                }
                throw new IllegalStateException(("Unknown item: " + item).toString());
            }
        }

        @JvmStatic
        @NotNull
        public final CommandConditionMixin parse(@NotNull ConfigSection section) {
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            ConditionChain<Object> conditionChain = ConditionChain.Companion.parse(section, Companion::parse$lambda$0);
            Intrinsics.checkNotNull(conditionChain, (String)"null cannot be cast to non-null type org.kingdoms.utils.conditions.ConditionChain<kotlin.collections.List<org.kingdoms.utils.commands.ConfigCommand>>");
            return new CommandConditionMixin(conditionChain);
        }

        private static final Object parse$lambda$0(String x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            List<ConfigCommand> list = ConfigCommand.parse(CollectionsKt.listOf((Object)x));
            Intrinsics.checkNotNullExpressionValue(list, (String)"parse(...)");
            return CollectionsKt.first(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

