/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.single;

import java.util.Objects;
import java.util.function.Supplier;
import org.kingdoms.utils.cache.single.CachedObject;

public class CachedSupplier<T>
extends CachedObject<T> {
    protected final Supplier<T> supplier;

    public CachedSupplier(Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public static <T> CachedSupplier<T> of(Supplier<T> supplier) {
        if (supplier instanceof CachedSupplier) {
            return (CachedSupplier)supplier;
        }
        return new CachedSupplier<T>(supplier);
    }

    @Override
    public T get() {
        if (this.cached == null) {
            this.cached = this.supplier.get();
            this.present = this.cached != null;
        }
        return (T)this.cached;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.supplier + ')';
    }
}

