/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.caffeine;

import java.time.Duration;
import org.kingdoms.libs.caffeine.cache.Expiry;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.cache.caffeine.ExpirableObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/utils/cache/caffeine/ExpirableObjectExpiry;", "K", "", "V", "Lorg/kingdoms/utils/cache/caffeine/ExpirableObject;", "Lorg/kingdoms/libs/caffeine/cache/Expiry;", "<init>", "()V", "expireAfterCreate", "", "key", "value", "currentTime", "(Ljava/lang/Object;Lorg/kingdoms/utils/cache/caffeine/ExpirableObject;J)J", "expireAfterUpdate", "currentDuration", "(Ljava/lang/Object;Lorg/kingdoms/utils/cache/caffeine/ExpirableObject;JJ)J", "expireAfterRead", "shared"})
public final class ExpirableObjectExpiry<K, V extends ExpirableObject>
implements Expiry<K, V> {
    public long expireAfterCreate(@NotNull K key, @NotNull V value, long currentTime) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return value.getExpirationStrategy().getExpiryAfterCreate().toNanos();
    }

    public long expireAfterUpdate(@NotNull K key, @NotNull V value, long currentTime, long currentDuration) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Duration duration = value.getExpirationStrategy().getExpiryAfterUpdate();
        return duration != null ? duration.toNanos() : currentDuration;
    }

    public long expireAfterRead(@NotNull K key, @NotNull V value, long currentTime, long currentDuration) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Duration duration = value.getExpirationStrategy().getExpiryAfterRead();
        return duration != null ? duration.toNanos() : currentDuration;
    }
}

