/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.caffeine;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import org.kingdoms.libs.caffeine.cache.Caffeine;
import org.kingdoms.libs.caffeine.cache.Scheduler;
import org.kingdoms.utils.internal.reflection.Reflect;

public final class CacheHandler {
    private static final ForkJoinPool POOL = new ForkJoinPool();
    private static final Scheduler CACHE_SCHEDULER = Reflect.classExists("org.kingdoms.libs.caffeine.cache.Scheduler") ? Scheduler.forScheduledExecutorService((ScheduledExecutorService)CacheHandler.newScheduler()) : null;

    public static Caffeine<Object, Object> newBuilder() {
        return Caffeine.newBuilder().executor((Executor)POOL);
    }

    public static <K, V> Caffeine<K, V> typedBuilder() {
        return CacheHandler.newBuilder();
    }

    public static ForkJoinPool getPool() {
        return POOL;
    }

    public static Scheduler getCacheScheduler() {
        return CACHE_SCHEDULER;
    }

    public static ScheduledExecutorService newScheduler() {
        return Executors.newSingleThreadScheduledExecutor(Executors.defaultThreadFactory());
    }
}

