/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.bossbars;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.bossbars.BossBarSettings;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014J\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSession;", "", "settings", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "<init>", "(Lorg/kingdoms/utils/bossbars/BossBarSettings;)V", "bossBar", "Lorg/bukkit/boss/BossBar;", "setVisible", "", "visible", "", "setColor", "color", "Lorg/bukkit/boss/BarColor;", "removePlayer", "player", "Lorg/bukkit/entity/Player;", "addPlayer", "getPlayers", "", "removeAll", "setProgress", "progress", "", "updateTitle", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "Companion", "core"})
public class BossBarSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BossBarSettings settings;
    @NotNull
    private final BossBar bossBar;

    public BossBarSession(@NotNull BossBarSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        BarFlag[] barFlagArray = this.settings.getFlags$core();
        BossBar bossBar = Bukkit.createBossBar(null, (BarColor)this.settings.getColor$core(), (BarStyle)this.settings.getStyle$core(), (BarFlag[])Arrays.copyOf(barFlagArray, barFlagArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)bossBar, (String)"createBossBar(...)");
        this.bossBar = bossBar;
    }

    public final synchronized void setVisible(boolean visible) {
        this.bossBar.setVisible(visible);
    }

    public final synchronized void setColor(@NotNull BarColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.bossBar.setColor(color);
    }

    public final synchronized void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.bossBar.removePlayer(player);
    }

    public final synchronized void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.bossBar.addPlayer(player);
    }

    @NotNull
    public final synchronized List<Player> getPlayers() {
        List list = this.bossBar.getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        return list;
    }

    public final synchronized void removeAll() {
        this.bossBar.removeAll();
    }

    public final synchronized void setProgress(double progress) {
        this.bossBar.setProgress(progress);
    }

    public final synchronized void updateTitle(@Nullable MessagePlaceholderProvider settings) {
        this.bossBar.setTitle(this.settings.getTitle$core().buildPlain(settings));
    }

    @JvmStatic
    @Nullable
    public static final BossBarSession from(@Nullable ConfigSection section) {
        return Companion.from(section);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSession$Companion;", "", "<init>", "()V", "from", "Lorg/kingdoms/utils/bossbars/BossBarSession;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public final BossBarSession from(@Nullable ConfigSection section) {
            if (section == null) {
                return null;
            }
            if (section.isSet("enabled")) {
                String[] stringArray = new String[]{"enabled"};
                if (!section.getBoolean(stringArray)) {
                    return null;
                }
            }
            BossBarSession bossBarSession = new BossBarSession(BossBarSettings.Companion.fromSection(section));
            return bossBarSession;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

