/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.bossbars;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.internal.ArrayIteratorKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.bossbars.BossBarSettings;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.string.Strings;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\b\u0010\u0013\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarEditor;", "", "player", "Lorg/bukkit/entity/Player;", "bossbar", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "modifier", "Ljava/util/function/Consumer;", "Lorg/kingdoms/gui/InteractiveGUI;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/kingdoms/utils/bossbars/BossBarSettings;Ljava/util/function/Consumer;)V", "edits", "", "", "updateBossBarEdits", "", "openGUI", "openColorsGUI", "openStylesGUI", "openFlagsGUI", "core"})
@SourceDebugExtension(value={"SMAP\nBossBarEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BossBarEditor.kt\norg/kingdoms/utils/bossbars/BossBarEditor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,108:1\n37#2:109\n36#2,3:110\n*S KotlinDebug\n*F\n+ 1 BossBarEditor.kt\norg/kingdoms/utils/bossbars/BossBarEditor\n*L\n99#1:109\n99#1:110,3\n*E\n"})
public final class BossBarEditor {
    @NotNull
    private final Player player;
    @NotNull
    private final BossBarSettings bossbar;
    @NotNull
    private final Consumer<InteractiveGUI> modifier;
    @NotNull
    private Map<String, Object> edits;

    public BossBarEditor(@NotNull Player player, @NotNull BossBarSettings bossbar, @NotNull Consumer<InteractiveGUI> modifier) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bossbar, (String)"bossbar");
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        this.player = player;
        this.bossbar = bossbar;
        this.modifier = modifier;
        this.edits = new HashMap();
    }

    private final void updateBossBarEdits() {
        this.edits.put("bossbar-title", this.bossbar.getTitle$core().buildPlain(new MessagePlaceholderProvider()));
        this.edits.put("bossbar_color", this.bossbar.getColor$core().name());
        this.edits.put("bossbar_style", this.bossbar.getStyle$core().name());
        Iterator iterator = ArrayIteratorKt.iterator((Object[])EnumCache.BOSS_BAR_FLAGS);
        while (iterator.hasNext()) {
            BarFlag flag = (BarFlag)iterator.next();
            Map<String, Object> map = this.edits;
            StringBuilder stringBuilder = new StringBuilder().append("bossbar_flag_");
            String string = flag.name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = stringBuilder.append(string2).toString();
            String string3 = ArraysKt.contains((Object[])this.bossbar.getFlags$core(), (Object)flag) ? KingdomsLang.ENABLED.parse(new Object[0]) : KingdomsLang.DISABLED.parse(new Object[0]);
            map.put(string, string3);
        }
    }

    @Nullable
    public final InteractiveGUI openGUI() {
        this.updateBossBarEdits();
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_EDITOR);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        gui.getMessageContext().addAll((Map)this.edits);
        gui.option("title").onNormalClicks(BossBarEditor::openGUI$lambda$0).setConversation((arg_0, arg_1) -> BossBarEditor.openGUI$lambda$1(this, gui, arg_0, arg_1)).done();
        gui.option("colors").onNormalClicks(() -> BossBarEditor.openGUI$lambda$2(this)).done();
        gui.option("styles").onNormalClicks(() -> BossBarEditor.openGUI$lambda$3(this)).done();
        gui.option("flags").onNormalClicks(() -> BossBarEditor.openGUI$lambda$4(this)).done();
        this.modifier.accept(gui);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @Nullable
    public final InteractiveGUI openColorsGUI() {
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_COLORS);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])EnumCache.BOSS_BAR_COLORS);
        while (iterator.hasNext()) {
            BarColor color = (BarColor)iterator.next();
            String string = Strings.configOption((Enum)color);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(...)");
            gui.option(string).onNormalClicks(arg_0 -> BossBarEditor.openColorsGUI$lambda$5(this, color, arg_0)).done();
        }
        gui.push("back", () -> BossBarEditor.openColorsGUI$lambda$6(this), new Object[0]);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @Nullable
    public final InteractiveGUI openStylesGUI() {
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_STYLES);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])EnumCache.BOSS_BAR_STYLES);
        while (iterator.hasNext()) {
            BarStyle style = (BarStyle)iterator.next();
            gui.option(style.name()).onNormalClicks(arg_0 -> BossBarEditor.openStylesGUI$lambda$7(this, style, arg_0)).done();
        }
        gui.push("back", () -> BossBarEditor.openStylesGUI$lambda$8(this), new Object[0]);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @Nullable
    public final InteractiveGUI openFlagsGUI() {
        InteractiveGUI interactiveGUI = GUIAccessor.prepare(this.player, KingdomsGUI.BOSSBAR_FLAGS);
        if (interactiveGUI == null) {
            return null;
        }
        InteractiveGUI gui = interactiveGUI;
        Set flags = ArraysKt.toMutableSet((Object[])this.bossbar.getFlags$core());
        Iterator iterator = ArrayIteratorKt.iterator((Object[])EnumCache.BOSS_BAR_FLAGS);
        while (iterator.hasNext()) {
            BarFlag flag = (BarFlag)iterator.next();
            boolean enabled = flags.contains(flag);
            String string = Strings.configOption((Enum)flag);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(...)");
            Object[] objectArray = new Object[]{"enabled", enabled};
            gui.option(string).setEdits(objectArray).onNormalClicks(arg_0 -> BossBarEditor.openFlagsGUI$lambda$9(enabled, flags, flag, this, arg_0)).done();
        }
        gui.push("back", () -> BossBarEditor.openFlagsGUI$lambda$10(this), new Object[0]);
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    private static final void openGUI$lambda$0(OptionHandler context) {
        context.sendMessage((Messenger)KingdomsLang.BOSSBAR_EDITOR_TITLE_ENTER, new Object[0]);
        context.startConversation();
    }

    private static final void openGUI$lambda$1(BossBarEditor this$0, InteractiveGUI $gui, OptionHandler optionHandler, String input) {
        MessageCompiler compiled = new MessageCompiler(input);
        compiled.compile();
        this$0.bossbar.setTitle$core(compiled.compileObject());
        $gui.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda$2(BossBarEditor this$0) {
        this$0.openColorsGUI();
    }

    private static final void openGUI$lambda$3(BossBarEditor this$0) {
        this$0.openStylesGUI();
    }

    private static final void openGUI$lambda$4(BossBarEditor this$0) {
        this$0.openFlagsGUI();
    }

    private static final void openColorsGUI$lambda$5(BossBarEditor this$0, BarColor $color, OptionHandler optionHandler) {
        this$0.bossbar.setColor$core($color);
        this$0.openGUI();
    }

    private static final void openColorsGUI$lambda$6(BossBarEditor this$0) {
        this$0.openGUI();
    }

    private static final void openStylesGUI$lambda$7(BossBarEditor this$0, BarStyle $style, OptionHandler optionHandler) {
        this$0.bossbar.setStyle$core($style);
        this$0.openGUI();
    }

    private static final void openStylesGUI$lambda$8(BossBarEditor this$0) {
        this$0.openGUI();
    }

    private static final void openFlagsGUI$lambda$9(boolean $enabled, Set $flags, BarFlag $flag, BossBarEditor this$0, OptionHandler optionHandler) {
        boolean bl;
        if ($enabled) {
            bl = $flags.remove($flag);
        } else {
            Intrinsics.checkNotNull((Object)$flag);
            bl = $flags.add($flag);
        }
        Collection $this$toTypedArray$iv = $flags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this$0.bossbar.setFlags$core(thisCollection$iv.toArray(new BarFlag[0]));
        this$0.openFlagsGUI();
    }

    private static final void openFlagsGUI$lambda$10(BossBarEditor this$0) {
        this$0.openGUI();
    }
}

