/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.blocktransformation;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.blocktransformation.BlockTransformation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/blocktransformation/ChangeBlockMaterial;", "Lorg/kingdoms/utils/blocktransformation/BlockTransformation;", "location", "Lorg/bukkit/Location;", "from", "Lorg/kingdoms/libs/xseries/XMaterial;", "to", "<init>", "(Lorg/bukkit/Location;Lcom/cryptomorin/xseries/XMaterial;Lcom/cryptomorin/xseries/XMaterial;)V", "getFrom", "()Lcom/cryptomorin/xseries/XMaterial;", "setFrom", "(Lcom/cryptomorin/xseries/XMaterial;)V", "getTo", "setTo", "apply", "", "reverse", "", "core"})
public final class ChangeBlockMaterial
extends BlockTransformation {
    @NotNull
    private XMaterial from;
    @NotNull
    private XMaterial to;

    public ChangeBlockMaterial(@NotNull Location location, @NotNull XMaterial from, @NotNull XMaterial to) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        super(location);
        this.from = from;
        this.to = to;
    }

    @NotNull
    public final XMaterial getFrom() {
        return this.from;
    }

    public final void setFrom(@NotNull XMaterial xMaterial) {
        Intrinsics.checkNotNullParameter((Object)xMaterial, (String)"<set-?>");
        this.from = xMaterial;
    }

    @NotNull
    public final XMaterial getTo() {
        return this.to;
    }

    public final void setTo(@NotNull XMaterial xMaterial) {
        Intrinsics.checkNotNullParameter((Object)xMaterial, (String)"<set-?>");
        this.to = xMaterial;
    }

    @Override
    public void apply(boolean reverse) {
        Block block = this.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        Block block2 = block;
        XMaterial xMaterial = XMaterial.matchXMaterial((Material)block2.getType());
        Intrinsics.checkNotNullExpressionValue((Object)xMaterial, (String)"matchXMaterial(...)");
        XMaterial currentMaterial = xMaterial;
        if (reverse) {
            if (currentMaterial != this.to) {
                this.to = currentMaterial;
            }
        } else if (currentMaterial != this.from) {
            this.from = currentMaterial;
        }
        XBlock.setType((Block)block2, (XMaterial)(reverse ? this.from : this.to));
    }
}

