/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class TextureAtlas {
    private int rows;
    private int columns;
    private int width;
    private int height;
    private BufferedImage[][] spirites;
    private Map<String, BufferedImage> mappedSpirites;
    private final Map<BorderSide, Integer> offsets = new EnumMap<BorderSide, Integer>(BorderSide.class);
    private boolean processed;

    private void checkProcessed() {
        if (this.processed) {
            throw new IllegalStateException("Image atlas has already been processed and cannot be changed");
        }
    }

    public TextureAtlas rows(int rows) {
        if (rows <= 0) {
            throw new IllegalArgumentException("Number of rows must be positive: " + rows);
        }
        this.checkProcessed();
        this.rows = rows;
        return this;
    }

    public TextureAtlas columns(int columns) {
        if (columns <= 0) {
            throw new IllegalArgumentException("Number of columns must be positive: " + columns);
        }
        this.checkProcessed();
        this.columns = columns;
        return this;
    }

    public TextureAtlas offset(BorderSide side, int offset) {
        this.checkProcessed();
        this.offsets.put(side, offset);
        return this;
    }

    private int getOffset(BorderSide side) {
        return this.offsets.getOrDefault((Object)side, 0);
    }

    public int getAdjustedHeight() {
        return this.height - this.getOffset(BorderSide.BOTTOM);
    }

    public int getAdjustedWidth() {
        return this.width - this.getOffset(BorderSide.RIGHT);
    }

    public TextureAtlas withSheet(BufferedImage image) {
        this.checkProcessed();
        if (this.rows <= 0) {
            throw new IllegalStateException("No rows set: " + this.rows);
        }
        if (this.columns <= 0) {
            throw new IllegalStateException("No columns set: " + this.columns);
        }
        if (this.height == 0 && this.width == 0) {
            this.height = image.getHeight() / this.rows;
            this.width = image.getWidth() / this.columns;
        }
        this.spirites = new BufferedImage[this.rows][this.columns];
        this.mappedSpirites = new HashMap<String, BufferedImage>(this.rows * this.columns);
        Objects.requireNonNull(image, "Cannot load null image sheet");
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.columns; ++col) {
                int x = col * this.width + this.getOffset(BorderSide.LEFT);
                int y = row * this.height + this.getOffset(BorderSide.TOP);
                int width = this.getAdjustedWidth();
                int height = this.getAdjustedHeight();
                try {
                    BufferedImage spirite;
                    this.spirites[row][col] = spirite = image.getSubimage(x, y, width, height);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to load spirit: x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + " dims=" + image.getWidth() + ", " + image.getHeight(), ex);
                }
            }
        }
        this.processed = true;
        return this;
    }

    public BufferedImage get(int row, int column) {
        return this.spirites[row][column];
    }

    public BufferedImage get(String name) {
        return this.mappedSpirites.get(name);
    }

    public TextureAtlas map(String name, int row, int column) {
        this.mappedSpirites.put(name, this.get(row, column));
        return this;
    }

    public TextureAtlas mapRow(int row, String ... names) {
        int column = 0;
        for (String name : names) {
            this.map(name, row, column++);
        }
        return this;
    }

    public static enum BorderSide {
        RIGHT,
        LEFT,
        TOP,
        BOTTOM;

    }
}

