/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import com.google.common.base.Enums;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.plugin.Plugin;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.KingdomsItemDeserializer;
import org.kingdoms.utils.RecipeType;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kingdoms/utils/RecipeParser;", "", "<init>", "()V", "Companion", "core"})
public final class RecipeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void registerRecipe(@NotNull Recipe recipe) {
        Companion.registerRecipe(recipe);
    }

    @JvmStatic
    public static final void removeRecipe(@NotNull String name) {
        Companion.removeRecipe(name);
    }

    @JvmStatic
    @NotNull
    public static final Recipe parse(@NotNull String name, @NotNull ConfigSection section, @NotNull ItemStack result) {
        return Companion.parse(name, section, result);
    }

    @JvmStatic
    public static final void setCookingRecipeProperties(@NotNull CookingRecipe<?> recipe, @NotNull ConfigSection section) {
        Companion.setCookingRecipeProperties(recipe, section);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u001c\u0010\u0011\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/RecipeParser$Companion;", "", "<init>", "()V", "registerRecipe", "", "recipe", "Lorg/bukkit/inventory/Recipe;", "removeRecipe", "name", "", "deserialize", "Lorg/bukkit/inventory/ItemStack;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "parse", "result", "setCookingRecipeProperties", "Lorg/bukkit/inventory/CookingRecipe;", "core"})
    @SourceDebugExtension(value={"SMAP\nRecipeParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeParser.kt\norg/kingdoms/utils/RecipeParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void registerRecipe(@NotNull Recipe recipe) {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            Bukkit.addRecipe((Recipe)recipe);
        }

        @JvmStatic
        public final void removeRecipe(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey((Plugin)Kingdoms.get(), name));
        }

        private final ItemStack deserialize(ConfigSection section) {
            return new KingdomsItemDeserializer().withSection(section).deserialize();
        }

        @JvmStatic
        @NotNull
        public final Recipe parse(@NotNull String name, @NotNull ConfigSection section, @NotNull ItemStack result) {
            Recipe recipe;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            String typeStr = section.getString("type");
            String string = typeStr;
            if (string == null) {
                string = "SHAPELESS";
            }
            String string2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            Object object = Enums.getIfPresent(RecipeType.class, (String)string3).or((Object)RecipeType.SHAPELESS);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"or(...)");
            RecipeType type = (RecipeType)((Object)object);
            NamespacedKey ns = new NamespacedKey((Plugin)Kingdoms.get(), name);
            String group = section.getString("group");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    ShapedRecipe recipe2 = new ShapedRecipe(ns, result);
                    if (group != null) {
                        recipe2.setGroup(group);
                    }
                    String string4 = section.getString("shape");
                    Intrinsics.checkNotNull((Object)string4);
                    String shape = string4;
                    String[] stringArray = new String[]{StringsKt.replace$default((String)shape, (String)" ", (String)"", (boolean)false, (int)4, null)};
                    recipe2.shape(stringArray);
                    recipe2.setIngredient('-', Material.AIR);
                    Map<String, ConfigSection> map = section.getSections();
                    Intrinsics.checkNotNullExpressionValue(map, (String)"getSections(...)");
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        ConfigSection ingredient2 = (ConfigSection)entry.getValue();
                        Intrinsics.checkNotNull((Object)ingredient2);
                        ItemStack item2 = this.deserialize(ingredient2);
                        recipe2.setIngredient(key.charAt(0), (RecipeChoice)new RecipeChoice.ExactChoice(item2));
                    }
                    recipe = (Recipe)recipe2;
                    break;
                }
                case 2: {
                    ShapelessRecipe recipe3 = new ShapelessRecipe(ns, result);
                    if (group != null) {
                        recipe3.setGroup(group);
                    }
                    Map<String, ConfigSection> map = section.getSections();
                    Intrinsics.checkNotNullExpressionValue(map, (String)"getSections(...)");
                    Iterator<Map.Entry<String, ConfigSection>> shape = map.entrySet().iterator();
                    while (shape.hasNext()) {
                        ConfigSection configSection = shape.next().getValue();
                        Intrinsics.checkNotNull((Object)configSection);
                        ItemStack item = this.deserialize(configSection);
                        recipe3.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(item));
                    }
                    recipe = (Recipe)recipe3;
                    break;
                }
                case 3: {
                    String[] shape = new String[]{"uses"};
                    int uses = section.getInt(shape);
                    String[] stringArray = new String[]{"maxUses"};
                    int maxUses = section.getInt(stringArray);
                    String[] stringArray2 = new String[]{"villager-experience"};
                    int villagerExperience = section.getInt(stringArray2);
                    String[] item = new String[]{"demand"};
                    int n = section.getInt(item);
                    String[] ingredient2 = new String[]{"specialPrice"};
                    int specialPrice = section.getInt(ingredient2);
                    String[] item2 = new String[]{"price-multiplier"};
                    float priceMultiplier = section.getFloat(item2);
                    String[] stringArray22 = new String[]{"experience-reward"};
                    boolean experienceReward = section.getBoolean(stringArray22);
                    recipe = (Recipe)new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier, n, specialPrice);
                    break;
                }
                case 4: {
                    String[] villagerExperience = new String[]{"base"};
                    ConfigSection configSection = section.getSection(villagerExperience);
                    Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
                    ItemStack base = this.deserialize(configSection);
                    String[] stringArray = new String[]{"addition"};
                    ConfigSection configSection2 = section.getSection(stringArray);
                    Intrinsics.checkNotNullExpressionValue((Object)configSection2, (String)"getSection(...)");
                    ItemStack addition = this.deserialize(configSection2);
                    recipe = (Recipe)new SmithingRecipe(ns, result, (RecipeChoice)new RecipeChoice.ExactChoice(base), (RecipeChoice)new RecipeChoice.ExactChoice(addition));
                    break;
                }
                case 5: {
                    String[] villagerExperience = new String[]{"input"};
                    ConfigSection configSection = section.getSection(villagerExperience);
                    Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
                    ItemStack input = this.deserialize(configSection);
                    recipe = (Recipe)new StonecuttingRecipe(ns, result, (RecipeChoice)new RecipeChoice.ExactChoice(input));
                    break;
                }
                case 6: {
                    CampfireRecipe campfireRecipe;
                    CampfireRecipe $this$parse_u24lambda_u240 = campfireRecipe = new CampfireRecipe(ns, result, Material.DIRT, 0.0f, 0);
                    boolean bl = false;
                    Companion.setCookingRecipeProperties((CookingRecipe)$this$parse_u24lambda_u240, section);
                    recipe = (Recipe)campfireRecipe;
                    break;
                }
                case 7: {
                    BlastingRecipe blastingRecipe;
                    BlastingRecipe $this$parse_u24lambda_u241 = blastingRecipe = new BlastingRecipe(ns, result, Material.DIRT, 0.0f, 0);
                    boolean bl = false;
                    Companion.setCookingRecipeProperties((CookingRecipe)$this$parse_u24lambda_u241, section);
                    recipe = (Recipe)blastingRecipe;
                    break;
                }
                case 8: {
                    FurnaceRecipe furnaceRecipe;
                    FurnaceRecipe $this$parse_u24lambda_u242 = furnaceRecipe = new FurnaceRecipe(ns, result, Material.DIRT, 0.0f, 0);
                    boolean bl = false;
                    Companion.setCookingRecipeProperties((CookingRecipe)$this$parse_u24lambda_u242, section);
                    recipe = (Recipe)furnaceRecipe;
                    break;
                }
                case 9: {
                    SmokingRecipe smokingRecipe;
                    SmokingRecipe $this$parse_u24lambda_u243 = smokingRecipe = new SmokingRecipe(ns, result, Material.DIRT, 0.0f, 0);
                    boolean bl = false;
                    Companion.setCookingRecipeProperties((CookingRecipe)$this$parse_u24lambda_u243, section);
                    recipe = (Recipe)smokingRecipe;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return recipe;
        }

        @JvmStatic
        public final void setCookingRecipeProperties(@NotNull CookingRecipe<?> recipe, @NotNull ConfigSection section) {
            String it;
            Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            recipe.setCookingTime((int)TimeUtils.toTicks(section.getTime("cooking-time", PlaceholderProvider.EMPTY)));
            String[] stringArray = new String[]{"experience"};
            recipe.setExperience(section.getFloat(stringArray));
            String string = section.getString("group");
            if (string != null) {
                it = string;
                boolean bl = false;
                recipe.setGroup(it);
            }
            String string2 = section.getString("category");
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                recipe.setCategory(CookingBookCategory.valueOf((String)it));
            }
            String[] stringArray2 = new String[]{"input"};
            ConfigSection configSection = section.getSection(stringArray2);
            Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
            ItemStack input = this.deserialize(configSection);
            recipe.setInputChoice((RecipeChoice)new RecipeChoice.ExactChoice(input));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RecipeType.values().length];
                try {
                    nArray[RecipeType.SHAPED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.SHAPELESS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.MERCHANT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.SMITHING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.STONECUTTING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.CAMPFIRE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.BLASTING.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.FURNACE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RecipeType.SMOKING.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

