/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XAttribute;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.server.platform.Platform;
import org.kingdoms.utils.math.AverageStats;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class PlayerUtils {
    private static final Pattern USERNAME = Pattern.compile("[A-Za-z0-9_]{1,16}");
    public static final UUID CONSOLE_UUID = new UUID(0L, 0L);
    private static final AverageStats<UUID, Integer> AVG_PINGS = new AverageStats();
    private static final Map<String, org.kingdoms.platform.bukkit.entity.OfflinePlayer> PLAYER_BY_NAME;
    private static final boolean SUPPORTS_PING_API;

    public static void init() {
    }

    public static UUID getUniqueId(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getUniqueId();
        }
        return CONSOLE_UUID;
    }

    public static boolean isValidUsername(String username) {
        Objects.requireNonNull(username, "Username is null");
        if (Platform.BEDROCK.isAvailable() && username.startsWith(".")) {
            username = username.substring(1);
        }
        return !username.isEmpty() && USERNAME.matcher(username).matches();
    }

    public static void cachePlayer(Player player) {
        PLAYER_BY_NAME.put(player.getName(), new org.kingdoms.platform.bukkit.entity.OfflinePlayer(player.getUniqueId(), player.getName()));
    }

    public static String name(OfflinePlayer player) {
        String name = player.getName();
        if (com.google.common.base.Strings.isNullOrEmpty((String)name)) {
            return player.getUniqueId().toString();
        }
        return name;
    }

    public static double getMaxPlayerHealth(@NonNull LivingEntity entity2) {
        return entity2.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).getValue();
    }

    public static void damageArmor(LivingEntity entity2, int armorDamage) {
        ItemStack[] armors;
        if (armorDamage == 0) {
            return;
        }
        armorDamage = -armorDamage;
        for (ItemStack armor : armors = entity2.getEquipment().getArmorContents()) {
            if (armor == null || armor.getType() == Material.AIR) continue;
            VersionSupport.addDurability(armor, armorDamage);
        }
        entity2.getEquipment().setArmorContents(armors);
    }

    public static void sendBlockChange(@NonNull Player player, @NonNull Location loc, @NonNull XMaterial xMat) {
        Material mat = xMat.parseMaterial();
        if (XReflection.supports((int)13)) {
            BlockData blockData = mat.createBlockData();
            if (blockData instanceof Directional) {
                Directional direction = (Directional)blockData;
                direction.setFacing(player.getFacing().getOppositeFace());
            }
            player.sendBlockChange(loc, blockData);
        } else {
            player.sendBlockChange(loc, mat, xMat.getData());
        }
    }

    public static void sendBlockChange(@NonNull Player player, @NonNull Block block) {
        Location loc = block.getLocation();
        if (XReflection.supports((int)13)) {
            player.sendBlockChange(loc, block.getBlockData());
        } else {
            player.sendBlockChange(loc, block.getType(), block.getData());
        }
    }

    public static boolean invulnerableGameMode(@NonNull Player player) {
        GameMode gameMode = player.getGameMode();
        return gameMode == GameMode.CREATIVE || gameMode == GameMode.SPECTATOR;
    }

    private static boolean removeElytra(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack chestplate = inv.getChestplate();
        if (chestplate == null || !XMaterial.ELYTRA.isSimilar(chestplate)) {
            return false;
        }
        inv.setChestplate(null);
        XItemStack.giveOrDrop((Player)player, (ItemStack[])new ItemStack[]{chestplate});
        return true;
    }

    public static int findEmptyHotbarSlot(Player player) {
        PlayerInventory inv = player.getInventory();
        for (int slot = 0; slot < 8; ++slot) {
            if (inv.getItem(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getHotbarItem(Player player, int slot) {
        if ((slot < 0 || slot > 8) && slot != -1) {
            throw new IllegalArgumentException("Unknown hotbar slot: " + slot + " (from " + player.getName() + ')');
        }
        PlayerInventory inv = player.getInventory();
        if (slot == -1) {
            return inv.getItemInOffHand();
        }
        return inv.getItem(slot);
    }

    public static int getAveragePing(Player player) {
        return AVG_PINGS.getAverage(player.getUniqueId());
    }

    public static boolean hasGoodPing(Player player) {
        return PlayerUtils.getAveragePing(player) < 300;
    }

    public static int getPing(Player player) {
        Objects.requireNonNull(player, "Cannot get ping of null player");
        if (SUPPORTS_PING_API) {
            return player.getPing();
        }
        Object handle2 = MinecraftConnection.getHandle((Player)player);
        try {
            return handle2.getClass().getField("ping").getInt(handle2);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static OfflinePlayer getFirstPlayerThat(Predicate<OfflinePlayer> predicate) {
        Objects.requireNonNull(predicate);
        for (OfflinePlayer offlinePlayer : PLAYER_BY_NAME.values()) {
            if (!predicate.test(offlinePlayer)) continue;
            return offlinePlayer;
        }
        return null;
    }

    public static String getLocale(Player player) {
        if (XReflection.supports((int)12)) {
            return player.getLocale();
        }
        return null;
    }

    public static @Nullable OfflinePlayer findPlayer(@NotNull Player requester, @NotNull String username) {
        Objects.requireNonNull(username, "Player username is null");
        if (!PlayerUtils.isValidUsername(username)) {
            KingdomsLang.INVALID_USERNAME.sendError((CommandSender)requester, "name", username);
            return null;
        }
        OfflinePlayer player = PlayerUtils.getOfflinePlayer(username);
        if (player == null) {
            KingdomsLang.NOT_FOUND_PLAYER.sendError((CommandSender)requester, "name", username);
        }
        return player;
    }

    public static @Nullable OfflinePlayer getOfflinePlayer(@NonNull String name) {
        int len = name.length();
        if (len <= 16) {
            return PLAYER_BY_NAME.get(name);
        }
        return null;
    }

    public static OfflinePlayer getOfflinePlayerWarn(Player player, String name) {
        OfflinePlayer offline = PlayerUtils.getOfflinePlayer(name);
        if (offline == null) {
            KingdomsLang.NOT_FOUND_PLAYER.sendError((CommandSender)player, "name", name);
        }
        return offline;
    }

    public static @Nullable Player getPlayer(@NonNull String name, boolean exact) {
        Player player = Bukkit.getPlayerExact((String)name);
        if (exact || player != null) {
            return player;
        }
        String lowerName = Strings.toLatinLowerCase(name);
        int len = lowerName.length();
        if (len > 16) {
            return null;
        }
        int delta = Integer.MAX_VALUE;
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!Strings.toLatinLowerCase(online.getName()).startsWith(lowerName)) continue;
            int difference = Math.abs(online.getName().length() - len);
            if (difference < delta) {
                player = online;
                delta = difference;
            }
            if (difference != 0) continue;
            break;
        }
        return player;
    }

    public static boolean hasFullHealth(@NonNull LivingEntity entity2) {
        return entity2.getHealth() == PlayerUtils.getMaxPlayerHealth(entity2);
    }

    public static boolean isEffectivelyInvisible(Player player) {
        if (!player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return false;
        }
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            if (armor == null) continue;
            return false;
        }
        return true;
    }

    public static String validateOfflineName(OfflinePlayer player) {
        String name = player.getName();
        if (name == null) {
            KLogger.error("Unknown offline player " + player.getUniqueId() + " (" + player.getClass().getName() + ") due to corrupted data. This is not a kingdoms bug. Player with this UUID was never seen in the server before. Probably because a data reset. Attempting to fix...");
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
            if (kp.hasKingdom()) {
                kp.leaveKingdom(LeaveReason.CUSTOM);
            } else {
                KLogger.error(player.getUniqueId() + " failed. Player was not in a kingdom.");
            }
            throw new NullPointerException();
        }
        return name;
    }

    public static LivingEntity getTargetedEntity(Player player, double minRange) {
        double range = 20.0;
        LivingEntity target = null;
        BlockIterator bi = new BlockIterator((LivingEntity)player, (int)range);
        while (true) {
            double d = minRange;
            minRange = d - 1.0;
            if (!(d > 0.0) || !bi.hasNext()) break;
            bi.next();
        }
        while (bi.hasNext()) {
            Block b = bi.next();
            int bx = b.getX();
            int by = b.getY();
            int bz = b.getZ();
            for (Entity e : player.getNearbyEntities(range, range, range)) {
                if (!(e instanceof LivingEntity)) continue;
                Location l = e.getLocation();
                double ex = l.getX();
                double ey = l.getY();
                double ez = l.getZ();
                if (!((double)bx - 0.75 <= ex) || !(ex <= (double)bx + 1.75) || !((double)bz - 0.75 <= ez) || !(ez <= (double)bz + 1.75) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                return target;
            }
        }
        return null;
    }

    static {
        OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
        PLAYER_BY_NAME = new HashMap<String, org.kingdoms.platform.bukkit.entity.OfflinePlayer>(offlinePlayers.length);
        for (OfflinePlayer player : offlinePlayers) {
            if (player.getName() == null) continue;
            PLAYER_BY_NAME.put(player.getName(), new org.kingdoms.platform.bukkit.entity.OfflinePlayer(player.getUniqueId(), player.getName()));
        }
        boolean supportsPingAPI = false;
        try {
            Player.class.getDeclaredMethod("getPing", new Class[0]);
            supportsPingAPI = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SUPPORTS_PING_API = supportsPingAPI;
        Kingdoms.taskScheduler().async().repeating(Duration.ofSeconds(30L), Duration.ofSeconds(10L), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                int ping = PlayerUtils.getPing(player);
                AVG_PINGS.addData(player.getUniqueId(), ping);
            }
        });
    }
}

