/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.MathExpression;

public final class MathUtils {
    public static final double TRUE = 1.0;
    public static final double FALSE = 0.0;
    private static final int INT_MAX_LENGTH = 11;
    private static final int LONG_MAX_LENGTH = 20;
    private static final int DECIMAL_SYSTEM_RADIX = 10;
    private static final String[] LARGE_NUMBER_CHARS = new String[]{"K", "M", "B", "T", "Quadrillion", "Quintillion", "Sextillion", "Septillion", "Octillion", "Nonillion", "Decillion", "Undecillion", "Duodecillion", "Tredecillion", "Quattuordecillion", "Quindecillion", "Sexdecillion", "Septendecillion", "Octodecillion", "Novemdecillion", "Vigintillion", "Unvigintillion", "Duovigintillion", "Tresvigintillion", "Quattuor\u00advigint\u00adillion", "Quinvigintillion", "Sesvigintillion", "Septemvigintillion", "Octovigintillion", "Novemvigintillion", "Trigintillion", "Untrigintillion", "Duotrigintillion", "Trestrigintillion", "Quattuor\u00adtrigint\u00adillion", "Quintrigintillion", "Sestrigintillion", "Septentrigintillion", "Octotrigintillion", "Noventrigintillion", "Quadragintillion"};
    private static final DecimalFormat EXPANDED_FORMAT = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public static long adjustBetween(long min, long value, long max) {
        return Math.min(max, Math.max(min, value));
    }

    public static int getPageNumbers(int items, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size is zero or negative: " + size);
        }
        if (items < 0) {
            throw new IllegalArgumentException("Item count is negative: " + items);
        }
        return Math.max(1, items % size != 0 ? items / size + 1 : items / size);
    }

    public static int getMiddleNumber(double first, double second) {
        return (int)Math.round((first + second) / 2.0);
    }

    public static double evaluateEquation(String eqn, Object ... edits) {
        return MathUtils.eval(eqn, new PlaceholderContextBuilder().raws(edits));
    }

    public static double eval(String eqn, OfflinePlayer placeholder, Object ... edits) {
        return MathUtils.eval(eqn, new PlaceholderContextBuilder().raws(edits).withContext(placeholder));
    }

    public static double getFractionalPart(double number) {
        return number - (double)((int)number);
    }

    public static double eval(String eqn, PlaceholderContextBuilder settings) {
        if (Strings.isNullOrEmpty((String)eqn)) {
            return 0.0;
        }
        return MathUtils.eval(MathCompiler.compile(eqn), (PlaceholderProvider)settings);
    }

    public static double eval(MathExpression eqn, PlaceholderProvider context) {
        return eqn.eval(id -> MathUtils.expectDouble(id, context.providePlaceholder((String)id)));
    }

    public static MathExpression partialEval(MathExpression eqn, PlaceholderProvider context) {
        return MathCompiler.partiallyReplace(eqn, id -> MathUtils.expectDouble(id, context.providePlaceholder((String)id)));
    }

    public static double eval(String eqn, MessagePlaceholderProvider builder) {
        return MathUtils.eval(MathCompiler.compile(eqn), (PlaceholderProvider)builder);
    }

    public static Double expectDouble(String id, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof PlaceholderTranslationContext && (data = ((PlaceholderTranslationContext)data).getValue()) instanceof String) {
            try {
                data = Double.parseDouble(data.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        if (data instanceof Duration) {
            return ((Duration)data).toMillis();
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? 1.0 : 0.0;
        }
        if (data instanceof String) {
            return data.hashCode();
        }
        throw new IllegalArgumentException("Expected an arithmetic placeholder for '" + id + "' instead got '" + data + "' (" + data.getClass().getName() + ')');
    }

    public static Double parseDouble(String str) {
        try {
            double num = Double.parseDouble(str);
            if (Double.isNaN(num) || num == Double.NEGATIVE_INFINITY || num == Double.POSITIVE_INFINITY) {
                return null;
            }
            return num;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Float parseFloat(String str) {
        try {
            float num = Float.parseFloat(str);
            if (Float.isNaN(num) || num == Float.NEGATIVE_INFINITY || num == Float.POSITIVE_INFINITY) {
                return null;
            }
            return Float.valueOf(num);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static double eval(String eqn, Kingdom placeholder, Object ... edits) {
        return MathUtils.eval(eqn, new PlaceholderContextBuilder().raws(edits).withContext(placeholder));
    }

    public static double eval(String eqn, Nation placeholder, Object ... edits) {
        return MathUtils.eval(eqn, new PlaceholderContextBuilder().raws(edits).withContext(placeholder));
    }

    public static Integer parseInt(CharSequence str) {
        return MathUtils.parseInt(str, true);
    }

    public static Integer parseInt(CharSequence str, boolean signed) {
        int len = str.length();
        if (len == 0 || len > 11) {
            return null;
        }
        int i = 0;
        if (signed) {
            if (str.charAt(0) != '-') {
                signed = false;
            } else {
                if (len == 1) {
                    return null;
                }
                ++i;
            }
        }
        int limit = signed ? Integer.MIN_VALUE : -2147483647;
        int multmin = limit / 10;
        int result = 0;
        while (i < len) {
            int digit;
            if ((digit = MathUtils.digit(str.charAt(i++))) < 0 || result < multmin) {
                return null;
            }
            if ((result *= 10) < limit + digit) {
                return null;
            }
            result -= digit;
        }
        return signed ? result : -result;
    }

    public static Integer parseIntUnchecked(CharSequence str, boolean signed) {
        int i = 0;
        if (signed) {
            if (str.charAt(0) != '-') {
                signed = false;
            } else {
                ++i;
            }
        }
        int len = str.length();
        int result = 0;
        while (i < len) {
            result *= 10;
            result -= str.charAt(i++) - 48;
        }
        return signed ? result : -result;
    }

    public static Long parseLong(CharSequence str) {
        return MathUtils.parseLong(str, true);
    }

    public static Long parseLong(CharSequence str, boolean signed) {
        int len = str.length();
        if (len == 0 || len > 20) {
            return null;
        }
        int i = 0;
        if (signed) {
            if (str.charAt(0) != '-') {
                signed = false;
            } else {
                ++i;
            }
        }
        long limit = signed ? Long.MIN_VALUE : -9223372036854775807L;
        long multmin = limit / 10L;
        long result = 0L;
        while (i < len) {
            int digit;
            if ((digit = MathUtils.digit(str.charAt(i++))) < 0 || result < multmin) {
                return null;
            }
            if ((result *= 10L) < limit + (long)digit) {
                return null;
            }
            result -= (long)digit;
        }
        return signed ? result : -result;
    }

    private static int digit(int ch) {
        int digit = ch - 48;
        return digit >= 0 && digit < 10 ? digit : -1;
    }

    public static long averageOf(long ... longs) {
        return Arrays.stream(longs).sum() / (long)longs.length;
    }

    public static boolean hasChance(double percent) {
        return ThreadLocalRandom.current().nextDouble(0.0, 100.0) <= percent;
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static double getPercent(double amount, double max) {
        return MathUtils.getAmountFromAmount(amount, max, 100.0);
    }

    public static double percentOfAmount(double percent, double amount) {
        return amount * percent / 100.0;
    }

    public static int percentOfPercent(int ... percents) {
        int finalPercent = 1;
        for (int percent : percents) {
            finalPercent = (int)((double)finalPercent * ((double)percent / 100.0));
        }
        return finalPercent;
    }

    public static double getAmountFromAmount(double current, double max, double amount) {
        return current / max * amount;
    }

    public static double roundToDigits(double value, int precision) {
        if (precision <= 0) {
            return Math.round(value);
        }
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static String getShortNumber(Number number) {
        String name;
        double asDouble = number.doubleValue();
        String str = EXPANDED_FORMAT.format(asDouble);
        if (asDouble < 1000.0) {
            return str;
        }
        try {
            name = LARGE_NUMBER_CHARS[(str.length() - 1) / 3 - 1];
        }
        catch (IndexOutOfBoundsException ex) {
            return str.substring(0, 2) + 'e' + (str.length() - 2);
        }
        int candiv = str.length() % 3;
        if (candiv == 0) {
            candiv = 3;
        }
        return str.substring(0, candiv) + '.' + str.charAt(candiv) + name;
    }

    public static int increasingRandInt(int min, int max) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = min; i < max; ++i) {
            for (int j = i; j >= 0; --j) {
                numbers.add(j);
            }
        }
        int randInt = MathUtils.randInt(0, numbers.size() - 1);
        return (Integer)numbers.get(randInt);
    }

    public static int decreasingRandInt(int min, int max) {
        Validate.isTrue(min > 0, "Minimum number cannot be less than 1");
        Validate.isTrue(max > min, "Maximum number cannot be less than the minimum number");
        int[] numbers = new int[MathUtils.naturalSum(max - min)];
        int q = 0;
        for (int i = min; i < max; ++i) {
            int j = max - i + 1;
            while (j >= 0) {
                numbers[q++] = j--;
            }
        }
        int randomIndex = MathUtils.randInt(0, numbers.length - 1);
        return numbers[randomIndex];
    }

    public static int naturalSum(int n) {
        return n * (n + 1) / 2;
    }

    public static double factorial(int n) {
        double result = n;
        while (n > 1) {
            result *= (double)(--n);
        }
        return result;
    }

    public static boolean isPrime(int number) {
        if (number < 2) {
            return false;
        }
        if (number == 2) {
            return true;
        }
        if (number % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= number) {
            if (number % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public static int[] generatePrimes(int until) {
        if (until < 2) {
            return new int[0];
        }
        if (until == 2) {
            return new int[]{2};
        }
        int[] primes = new int[until / 2];
        int count = 1;
        primes[0] = 2;
        int i = 3;
        while (i * i <= until) {
            if (until % i == 0) {
                primes[count++] = i;
            }
            i += 2;
        }
        return Arrays.copyOf(primes, count);
    }

    public static double sqrtn(double num, int n) {
        return Math.round(Math.pow(num, 1.0 / (double)n));
    }

    public static boolean isEven(int number) {
        return (number & 1) == 0;
    }

    public static boolean isOdd(int number) {
        return (number & 1) == 1;
    }
}

