/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import org.kingdoms.libs.xseries.reflection.XAccessFlag;

public final class LoggerLevelInjector {
    public static void setLevel(Object logger, Level level) {
        Optional<Field> delegate;
        Class<?> clazz = logger.getClass();
        while ((delegate = Arrays.stream(clazz.getDeclaredFields()).filter(x -> x.getName().equals("logger")).filter(x -> x.getType().getSimpleName().contains("Logger")).findFirst()).isPresent()) {
            try {
                Field field = delegate.get();
                field.setAccessible(true);
                logger = field.get(logger);
                clazz = logger.getClass();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<Method> foundSetLevels = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals("setLevel")) continue;
            foundSetLevels.add(method);
            if (method.getParameterCount() != 1) continue;
            Parameter lvlParameter = method.getParameters()[0];
            Class<?> type = lvlParameter.getType();
            Optional<Field> translatedLogLevel = Arrays.stream(type.getDeclaredFields()).filter(x -> XAccessFlag.STATIC.isSet(x.getModifiers())).filter(x -> LoggerLevelInjector.tryNames(x.getName(), level)).findFirst();
            if (translatedLogLevel.isPresent()) {
                try {
                    method.invoke(logger, translatedLogLevel.get().get(null));
                    continue;
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Cannot set log level of " + LoggerLevelInjector.loggerString(logger) + " to " + level + " for method " + method, ex);
                }
            }
            throw new UnsupportedOperationException("Cannot find any logging levels for " + LoggerLevelInjector.loggerString(logger) + " for " + level + " for method " + method);
        }
        throw new UnsupportedOperationException("Cannot find any logging methods for " + LoggerLevelInjector.loggerString(logger) + " for " + level + (foundSetLevels.isEmpty() ? "" : " possible matches: " + foundSetLevels));
    }

    private static String loggerString(Object logger) {
        return logger.getClass().getName() + '(' + logger + ')';
    }

    private static boolean tryNames(String name, Level level) {
        if (name.equals(level.getName())) {
            return true;
        }
        return !(level != Level.FINE && level != Level.FINER && level != Level.FINEST || !name.equals("DEBUG") && !name.equals("TRACE"));
    }
}

