/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.string.Strings;

public final class ItemUtil {
    private ItemUtil() {
    }

    public static boolean notNull(ItemStack item) {
        return !ItemUtil.isNull(item);
    }

    public static boolean isNull(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static String getName(ItemStack item) {
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                return meta.getDisplayName();
            }
            if (meta.hasItemName()) {
                return meta.getItemName();
            }
            return Strings.capitalize(item.getType().name());
        }
        return Strings.capitalize(item.getType().name());
    }

    public static void translate(ItemMeta meta, MessageObject[] lore, MessagePlaceholderProvider settings) {
        ArrayList translatedLores = new ArrayList(lore.length);
        MessageObject lastColor = null;
        for (MessageObject messageObject : lore) {
            MessageObject loreLine = messageObject.evaluateDynamicPieces(settings);
            if (loreLine.isNull()) continue;
            MessageObject newLastColors = loreLine.findLastColors();
            if (lastColor != null) {
                loreLine = lastColor.merge(loreLine);
            }
            if (newLastColors != null) {
                lastColor = newLastColors;
            }
            List<MessageObject> subLoreLines = loreLine.splitLines();
            subLoreLines.forEach(x -> translatedLores.add(x.buildPlain(settings)));
        }
        meta.setLore(translatedLores);
    }

    public static void translate(ItemMeta meta, MessagePlaceholderProvider settings) {
        if (meta.hasDisplayName()) {
            MessageObject itemTitle = MessageCompiler.compile(meta.getDisplayName());
            meta.setDisplayName(itemTitle.buildPlain(settings));
        }
        if (meta.hasLore()) {
            List lores = meta.getLore();
            ArrayList newLores = new ArrayList();
            MessageObject lastColor = null;
            for (String lore : lores) {
                MessageObject loreLine = MessageCompiler.compile(lore);
                if ((loreLine = loreLine.evaluateDynamicPieces(settings)).isNull()) continue;
                MessageObject newLastColors = loreLine.findLastColors();
                if (lastColor != null) {
                    loreLine = lastColor.merge(loreLine);
                }
                if (newLastColors != null) {
                    lastColor = newLastColors;
                }
                List<MessageObject> subLoreLines = loreLine.splitLines();
                subLoreLines.forEach(x -> newLores.add(x.buildPlain(settings)));
            }
            meta.setLore(newLores);
        }
    }
}

