/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.libs.xseries.XMaterial;

public final class Banners {
    private Banners() {
    }

    public static List<Pattern> getBannerPatterns(ItemStack item) {
        if (!item.hasItemMeta()) {
            throw new IllegalArgumentException("Banner has no data: " + item);
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof BannerMeta)) {
            throw new IllegalArgumentException("Not a banner: " + item);
        }
        BannerMeta banner = (BannerMeta)meta;
        return banner.getPatterns();
    }

    public static boolean isBanner(ItemStack item) {
        return Banners.getBannerMaterialColor(XMaterial.matchXMaterial((ItemStack)item)) != null;
    }

    public static DyeColor getBannerMaterialColor(XMaterial banner) {
        switch (banner) {
            case BROWN_BANNER: 
            case BROWN_WALL_BANNER: {
                return DyeColor.BROWN;
            }
            case RED_BANNER: 
            case RED_WALL_BANNER: {
                return DyeColor.RED;
            }
            case BLUE_BANNER: 
            case BLUE_WALL_BANNER: {
                return DyeColor.BLUE;
            }
            case CYAN_BANNER: 
            case CYAN_WALL_BANNER: {
                return DyeColor.CYAN;
            }
            case GRAY_BANNER: 
            case GRAY_WALL_BANNER: {
                return DyeColor.GRAY;
            }
            case LIME_BANNER: 
            case LIME_WALL_BANNER: {
                return DyeColor.LIME;
            }
            case BLACK_BANNER: 
            case BLACK_WALL_BANNER: {
                return DyeColor.BLACK;
            }
            case PINK_BANNER: 
            case PINK_WALL_BANNER: {
                return DyeColor.PINK;
            }
            case GREEN_BANNER: 
            case GREEN_WALL_BANNER: {
                return DyeColor.GREEN;
            }
            case WHITE_BANNER: 
            case WHITE_WALL_BANNER: {
                return DyeColor.WHITE;
            }
            case ORANGE_BANNER: 
            case ORANGE_WALL_BANNER: {
                return DyeColor.ORANGE;
            }
            case YELLOW_BANNER: 
            case YELLOW_WALL_BANNER: {
                return DyeColor.YELLOW;
            }
            case PURPLE_BANNER: 
            case PURPLE_WALL_BANNER: {
                return DyeColor.PURPLE;
            }
            case MAGENTA_BANNER: 
            case MAGENTA_WALL_BANNER: {
                return DyeColor.MAGENTA;
            }
            case LIGHT_GRAY_BANNER: 
            case LIGHT_GRAY_WALL_BANNER: {
                return DyeColor.LIGHT_GRAY;
            }
            case LIGHT_BLUE_BANNER: 
            case LIGHT_BLUE_WALL_BANNER: {
                return DyeColor.LIGHT_BLUE;
            }
        }
        return null;
    }
}

