/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.tasks.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmOverloads;
import org.kingdoms.libs.kotlin.jvm.internal.ArrayIteratorKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.tasks.AbstractParentTask;
import org.kingdoms.tasks.AbstractTask;
import org.kingdoms.tasks.DefaultTaskSessionConstructor;
import org.kingdoms.tasks.ParentTask;
import org.kingdoms.tasks.TaskState;
import org.kingdoms.tasks.annotations.AcceptedTaskStates;
import org.kingdoms.tasks.annotations.After;
import org.kingdoms.tasks.annotations.Before;
import org.kingdoms.tasks.annotations.GroupedTask;
import org.kingdoms.tasks.annotations.NumberedPriority;
import org.kingdoms.tasks.annotations.Priority;
import org.kingdoms.tasks.annotations.Replace;
import org.kingdoms.tasks.annotations.ReturnTaskState;
import org.kingdoms.tasks.annotations.Task;
import org.kingdoms.tasks.annotations.TaskSessionConstructor;
import org.kingdoms.tasks.container.ConditionalLocalTaskSession;
import org.kingdoms.tasks.container.LocalTaskSession;
import org.kingdoms.tasks.context.IOTaskContext;
import org.kingdoms.tasks.context.InputTaskContext;
import org.kingdoms.tasks.context.OutputTaskContext;
import org.kingdoms.tasks.context.TaskContext;
import org.kingdoms.tasks.priority.EnumPriority;
import org.kingdoms.tasks.priority.PriorityPhase;
import org.kingdoms.tasks.priority.RelativePriority;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.internal.reflection.annotations.AnnotationContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0013\u0014\u0015B9\b\u0007\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u000e\u0018\u00010\u000eR\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0004\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0011R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor;", "C", "Lorg/kingdoms/tasks/context/TaskContext;", "", "container", "Ljava/lang/Class;", "Lorg/kingdoms/tasks/container/LocalTaskSession;", "constructor", "Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;", "parentTask", "Lorg/kingdoms/tasks/ParentTask;", "<init>", "(Ljava/lang/Class;Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;Lorg/kingdoms/tasks/ParentTask;)V", "processAnnotation", "Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ProcessedTaskAnnotations;", "Lorg/kingdoms/utils/internal/reflection/annotations/AnnotationContainer;", "generate", "", "Lorg/kingdoms/tasks/Task;", "ProcessedTaskAnnotations", "ReflectionParentTask", "ReflectionTask", "shared"})
@SourceDebugExtension(value={"SMAP\nTaskAnnotationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskAnnotationProcessor.kt\norg/kingdoms/tasks/annotations/TaskAnnotationProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1863#2,2:176\n*S KotlinDebug\n*F\n+ 1 TaskAnnotationProcessor.kt\norg/kingdoms/tasks/annotations/TaskAnnotationProcessor\n*L\n107#1:176,2\n*E\n"})
public final class TaskAnnotationProcessor<C extends TaskContext> {
    @NotNull
    private final Class<? extends LocalTaskSession> container;
    @NotNull
    private final TaskSessionConstructor<C> constructor;
    @Nullable
    private final ParentTask<C> parentTask;

    @JvmOverloads
    public TaskAnnotationProcessor(@NotNull Class<? extends LocalTaskSession> container, @NotNull TaskSessionConstructor<C> constructor, @Nullable ParentTask<C> parentTask) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        this.container = container;
        this.constructor = constructor;
        this.parentTask = parentTask;
    }

    public /* synthetic */ TaskAnnotationProcessor(Class clazz, TaskSessionConstructor taskSessionConstructor, ParentTask parentTask, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            parentTask = null;
        }
        this(clazz, taskSessionConstructor, parentTask);
    }

    private final ProcessedTaskAnnotations processAnnotation(AnnotationContainer container) {
        org.kingdoms.tasks.priority.Priority priority;
        List<Annotation> priorityAnnotations;
        Object implicitReturnState;
        Object object;
        Class[] it;
        Task task = container.getAnnotation(Task.class);
        if (task == null) {
            return null;
        }
        Task task2 = task;
        GroupedTask grouped = AnnotationContainer.Companion.of(container.getDeclaringClass()).getAnnotation(GroupedTask.class);
        String groupedNs = grouped == null ? "" : grouped.namespace() + ':';
        Namespace namespace = Namespace.fromString(groupedNs + task2.key());
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace namespace2 = namespace;
        if (container instanceof AnnotationContainer.Executable && ((AnnotationContainer.Executable)container).getJavaObject().getParameterCount() > 1) {
            throw new IllegalStateException("Task has more than one parameter: " + ((AnnotationContainer.Executable)container).getJavaObject());
        }
        boolean taskStatesInclude = false;
        taskStatesInclude = true;
        QuickEnumSet taskStates = null;
        Class[] classArray = container.getAnnotation(AcceptedTaskStates.class);
        if (classArray != null) {
            it = classArray;
            boolean bl = false;
            taskStatesInclude = it.include();
            taskStates = new QuickEnumSet((Enum[])TaskState.values());
            CollectionsKt.addAll((Collection)taskStates, (Object[])it.states());
        }
        if ((object = container.getAnnotation(ReturnTaskState.class)) == null || (object = object.state()) == null) {
            object = implicitReturnState = TaskState.CONTINUE;
        }
        if ((priorityAnnotations = container.findAll(it = new Class[]{Priority.class, NumberedPriority.class, Before.class, After.class, Replace.class})).size() > 1) {
            throw new IllegalStateException("Task cannot have more than one priority annotation. Found " + priorityAnnotations + " for " + container);
        }
        Annotation priorityAnn = (Annotation)CollectionsKt.first(priorityAnnotations);
        if (priorityAnn instanceof Priority) {
            priority = new EnumPriority(((Priority)priorityAnn).priority());
        } else if (priorityAnn instanceof NumberedPriority) {
            priority = new org.kingdoms.tasks.priority.NumberedPriority(((NumberedPriority)priorityAnn).order());
        } else if (priorityAnn instanceof Before) {
            Namespace namespace3 = Namespace.fromString(((Before)priorityAnn).other());
            Intrinsics.checkNotNullExpressionValue((Object)namespace3, (String)"fromString(...)");
            priority = new RelativePriority(RelativePriority.Type.BEFORE, namespace3);
        } else if (priorityAnn instanceof After) {
            Namespace namespace4 = Namespace.fromString(((After)priorityAnn).other());
            Intrinsics.checkNotNullExpressionValue((Object)namespace4, (String)"fromString(...)");
            priority = new RelativePriority(RelativePriority.Type.AFTER, namespace4);
        } else if (priorityAnn instanceof Replace) {
            Namespace namespace5 = Namespace.fromString(((Replace)priorityAnn).other());
            Intrinsics.checkNotNullExpressionValue((Object)namespace5, (String)"fromString(...)");
            priority = new RelativePriority(RelativePriority.Type.REPLACE, namespace5);
        } else {
            priority = new EnumPriority(PriorityPhase.NORMAL);
        }
        org.kingdoms.tasks.priority.Priority priority2 = priority;
        return new ProcessedTaskAnnotations((TaskState)((Object)implicitReturnState), taskStatesInclude, taskStates, priority2, namespace2);
    }

    @NotNull
    public final List<org.kingdoms.tasks.Task<C>> generate() {
        ProcessedTaskAnnotations settings;
        List tasks = new ArrayList();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])this.container.getDeclaredMethods());
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            method.setAccessible(true);
            Intrinsics.checkNotNull((Object)method);
            settings = this.processAnnotation(AnnotationContainer.Companion.of(method));
            if (settings == null) continue;
            tasks.add(new ReflectionTask<C>(this.constructor, settings, method, this.parentTask));
        }
        iterator = ArrayIteratorKt.iterator((Object[])this.container.getDeclaredClasses());
        while (iterator.hasNext()) {
            Class innerClass = (Class)iterator.next();
            if (!LocalTaskSession.class.isAssignableFrom(innerClass)) continue;
            if (!ConditionalLocalTaskSession.class.isAssignableFrom(innerClass)) {
                throw new RuntimeException("Only ConditionalLocalTaskSession are supported for parent tasks: " + innerClass);
            }
            Intrinsics.checkNotNull((Object)innerClass);
            settings = this.processAnnotation(AnnotationContainer.Companion.of(innerClass));
            if (settings == null) continue;
            Class genericClass = innerClass;
            DefaultTaskSessionConstructor constructor = new DefaultTaskSessionConstructor(genericClass);
            ReflectionParentTask<C> parentTask = new ReflectionParentTask<C>(constructor, settings, this.parentTask);
            TaskAnnotationProcessor<C> innerProcessor = new TaskAnnotationProcessor<C>(genericClass, constructor, (ParentTask)parentTask);
            List<org.kingdoms.tasks.Task<C>> subTasks = innerProcessor.generate();
            Iterable $this$forEach$iv = subTasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                org.kingdoms.tasks.Task it = (org.kingdoms.tasks.Task)element$iv;
                boolean bl = false;
                parentTask.getSubTasks().register(it);
            }
            tasks.add(parentTask);
        }
        return tasks;
    }

    @JvmOverloads
    public TaskAnnotationProcessor(@NotNull Class<? extends LocalTaskSession> container, @NotNull TaskSessionConstructor<C> constructor) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        this(container, constructor, null, 4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0082\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ProcessedTaskAnnotations;", "", "implicitReturnState", "Lorg/kingdoms/tasks/TaskState;", "taskStatesInclude", "", "taskStates", "", "priority", "Lorg/kingdoms/tasks/priority/Priority;", "namespace", "Lorg/kingdoms/constants/namespace/Namespace;", "<init>", "(Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor;Lorg/kingdoms/tasks/TaskState;ZLjava/util/Set;Lorg/kingdoms/tasks/priority/Priority;Lorg/kingdoms/constants/namespace/Namespace;)V", "getImplicitReturnState", "()Lorg/kingdoms/tasks/TaskState;", "getTaskStatesInclude", "()Z", "getTaskStates", "()Ljava/util/Set;", "getPriority", "()Lorg/kingdoms/tasks/priority/Priority;", "getNamespace", "()Lorg/kingdoms/constants/namespace/Namespace;", "shared"})
    private final class ProcessedTaskAnnotations {
        @NotNull
        private final TaskState implicitReturnState;
        private final boolean taskStatesInclude;
        @Nullable
        private final Set<TaskState> taskStates;
        @NotNull
        private final org.kingdoms.tasks.priority.Priority priority;
        @NotNull
        private final Namespace namespace;

        public ProcessedTaskAnnotations(TaskState implicitReturnState, @Nullable boolean taskStatesInclude, @NotNull Set<TaskState> taskStates, @NotNull org.kingdoms.tasks.priority.Priority priority, Namespace namespace) {
            Intrinsics.checkNotNullParameter((Object)((Object)implicitReturnState), (String)"implicitReturnState");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            this.implicitReturnState = implicitReturnState;
            this.taskStatesInclude = taskStatesInclude;
            this.taskStates = taskStates;
            this.priority = priority;
            this.namespace = namespace;
        }

        @NotNull
        public final TaskState getImplicitReturnState() {
            return this.implicitReturnState;
        }

        public final boolean getTaskStatesInclude() {
            return this.taskStatesInclude;
        }

        @Nullable
        public final Set<TaskState> getTaskStates() {
            return this.taskStates;
        }

        @NotNull
        public final org.kingdoms.tasks.priority.Priority getPriority() {
            return this.priority;
        }

        @NotNull
        public final Namespace getNamespace() {
            return this.namespace;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ReflectionParentTask;", "T", "Lorg/kingdoms/tasks/context/TaskContext;", "Lorg/kingdoms/tasks/AbstractParentTask;", "constructor", "Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;", "settings", "Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ProcessedTaskAnnotations;", "Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor;", "parentTask", "Lorg/kingdoms/tasks/ParentTask;", "<init>", "(Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ProcessedTaskAnnotations;Lorg/kingdoms/tasks/ParentTask;)V", "run", "", "context", "(Lorg/kingdoms/tasks/context/TaskContext;)V", "shared"})
    private static final class ReflectionParentTask<T extends TaskContext>
    extends AbstractParentTask<T> {
        @NotNull
        private final TaskSessionConstructor<T> constructor;
        @NotNull
        private final ProcessedTaskAnnotations settings;

        public ReflectionParentTask(@NotNull TaskSessionConstructor<T> constructor, @NotNull ProcessedTaskAnnotations settings, @Nullable ParentTask<T> parentTask) {
            Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            super(settings.getPriority(), settings.getNamespace(), parentTask);
            this.constructor = constructor;
            this.settings = settings;
        }

        @Override
        public void run(@NotNull T context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            if (this.settings.getTaskStates() == null ? context.getState() == TaskState.SHOULD_STOP || context.getState() == TaskState.MUST_STOP : this.settings.getTaskStatesInclude() != this.settings.getTaskStates().contains((Object)context.getState())) {
                return;
            }
            LocalTaskSession localTaskSession = this.constructor.createSession(context);
            Intrinsics.checkNotNull((Object)localTaskSession, (String)"null cannot be cast to non-null type org.kingdoms.tasks.container.ConditionalLocalTaskSession<T of org.kingdoms.tasks.annotations.TaskAnnotationProcessor.ReflectionParentTask>");
            ConditionalLocalTaskSession instance = (ConditionalLocalTaskSession)localTaskSession;
            if (!instance.shouldExecute(context)) {
                return;
            }
            Ref.ObjectRef lastOutput = new Ref.ObjectRef();
            this.getSubTasks().executeDefinedTasks((IOTaskContext)context, arg_0 -> ReflectionParentTask.run$lambda$0(lastOutput, arg_0));
            if (lastOutput.element != null && context instanceof OutputTaskContext) {
                ((OutputTaskContext)context).setOutput(lastOutput.element);
            }
        }

        private static final void run$lambda$0(Ref.ObjectRef $lastOutput, Object it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $lastOutput.element = it;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0010\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ReflectionTask;", "T", "Lorg/kingdoms/tasks/context/TaskContext;", "Lorg/kingdoms/tasks/AbstractTask;", "constructor", "Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;", "settings", "Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ProcessedTaskAnnotations;", "Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor;", "method", "Ljava/lang/reflect/Method;", "parentTask", "Lorg/kingdoms/tasks/ParentTask;", "<init>", "(Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;Lorg/kingdoms/tasks/annotations/TaskAnnotationProcessor$ProcessedTaskAnnotations;Ljava/lang/reflect/Method;Lorg/kingdoms/tasks/ParentTask;)V", "needsArg", "", "directInputArg", "hasReturnValue", "run", "", "context", "(Lorg/kingdoms/tasks/context/TaskContext;)V", "shared"})
    private static final class ReflectionTask<T extends TaskContext>
    extends AbstractTask<T> {
        @NotNull
        private final TaskSessionConstructor<T> constructor;
        @NotNull
        private final ProcessedTaskAnnotations settings;
        @NotNull
        private final Method method;
        private final boolean needsArg;
        private final boolean directInputArg;
        private final boolean hasReturnValue;

        public ReflectionTask(@NotNull TaskSessionConstructor<T> constructor, @NotNull ProcessedTaskAnnotations settings, @NotNull Method method, @Nullable ParentTask<T> parentTask) {
            Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            super(settings.getPriority(), settings.getNamespace(), parentTask);
            this.constructor = constructor;
            this.settings = settings;
            this.method = method;
            this.needsArg = this.method.getParameterCount() != 0;
            this.directInputArg = this.needsArg && !TaskContext.class.isAssignableFrom(this.method.getParameterTypes()[0]);
            this.hasReturnValue = !Intrinsics.areEqual(this.method.getReturnType(), Void.class);
        }

        @Override
        public void run(@NotNull T context) {
            Object result;
            Object object;
            Intrinsics.checkNotNullParameter(context, (String)"context");
            if (this.settings.getTaskStates() == null ? context.getState().shouldStop() : this.settings.getTaskStatesInclude() != this.settings.getTaskStates().contains((Object)context.getState())) {
                return;
            }
            LocalTaskSession instance = this.constructor.createSession(context);
            if (this.needsArg) {
                Object[] objectArray;
                if (this.directInputArg) {
                    objectArray = new Object[]{((InputTaskContext)context).getInput()};
                    object = this.method.invoke((Object)instance, objectArray);
                } else {
                    objectArray = new Object[]{context};
                    object = this.method.invoke((Object)instance, objectArray);
                }
            } else {
                object = result = this.method.invoke((Object)instance, new Object[0]);
            }
            if (result != null && context instanceof OutputTaskContext) {
                ((OutputTaskContext)context).setOutput(result);
            }
            if (this.hasReturnValue && result != null) {
                context.setState(this.settings.getImplicitReturnState());
            }
        }
    }
}

