/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.tasks;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.constants.namespace.NamespacedRegistry;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.tasks.DefaultTaskSessionConstructor;
import org.kingdoms.tasks.DefinedTaskSessionConstructor;
import org.kingdoms.tasks.ParentTask;
import org.kingdoms.tasks.Task;
import org.kingdoms.tasks.TaskState;
import org.kingdoms.tasks.annotations.TaskAnnotationProcessor;
import org.kingdoms.tasks.annotations.TaskSessionConstructor;
import org.kingdoms.tasks.container.AbstractTaskSession;
import org.kingdoms.tasks.container.LocalTaskSession;
import org.kingdoms.tasks.container.TaskSession;
import org.kingdoms.tasks.context.AbstractIOTaskContext;
import org.kingdoms.tasks.context.IOTaskContext;
import org.kingdoms.tasks.context.TaskContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001$B\u0019\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010\u0012\u001a\r\u0012\u0004\u0012\u00028\u00010\u0013\u00a2\u0006\u0002\b\u0014J-\u0010\u0015\u001a\u00020\u0002\"\u0004\b\u0002\u0010\u0016\"\u0004\b\u0003\u0010\u00172\u0006\u0010\u0018\u001a\u0002H\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a\u00a2\u0006\u0002\u0010\u001bJ6\u0010\u001c\u001a\u00020\u000f\"\u0004\b\u0002\u0010\u0016\"\u0004\b\u0003\u0010\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 J$\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/kingdoms/tasks/TaskRegistry;", "C", "Lorg/kingdoms/tasks/context/TaskContext;", "T", "Lorg/kingdoms/tasks/Task;", "Lorg/kingdoms/constants/namespace/NamespacedRegistry;", "parentTask", "Lorg/kingdoms/tasks/ParentTask;", "<init>", "(Lorg/kingdoms/tasks/ParentTask;)V", "usableList", "Ljava/util/LinkedList;", "needsUpdating", "", "register", "", "task", "(Lorg/kingdoms/tasks/Task;)V", "getUsableList", "", "Lorg/kingdoms/libs/jetbrains/annotations/Unmodifiable;", "executeTasks", "I", "O", "input", "onOutput", "Ljava/util/function/Consumer;", "(Ljava/lang/Object;Ljava/util/function/Consumer;)Lorg/kingdoms/tasks/context/TaskContext;", "executeDefinedTasks", "context", "Lorg/kingdoms/tasks/context/IOTaskContext;", "container", "Ljava/lang/Class;", "Lorg/kingdoms/tasks/container/LocalTaskSession;", "constructor", "Lorg/kingdoms/tasks/annotations/TaskSessionConstructor;", "TaskComparator", "shared"})
@SourceDebugExtension(value={"SMAP\nTaskRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRegistry.kt\norg/kingdoms/tasks/TaskRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n1863#3,2:181\n*S KotlinDebug\n*F\n+ 1 TaskRegistry.kt\norg/kingdoms/tasks/TaskRegistry\n*L\n110#1:181,2\n*E\n"})
public final class TaskRegistry<C extends TaskContext, T extends Task<C>>
extends NamespacedRegistry<T> {
    @Nullable
    private final ParentTask<C> parentTask;
    @NotNull
    private final LinkedList<T> usableList;
    private boolean needsUpdating;

    public TaskRegistry(@Nullable ParentTask<C> parentTask) {
        this.parentTask = parentTask;
        this.usableList = new LinkedList();
        this.needsUpdating = true;
    }

    public /* synthetic */ TaskRegistry(ParentTask parentTask, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parentTask = null;
        }
        this(parentTask);
    }

    @Override
    public void register(@NotNull T task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Namespace namespace = ((Namespaced)task).getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"getNamespace(...)");
        Namespace namespace2 = namespace;
        Objects.requireNonNull(namespace2, "Cannot register task with null namespace");
        if (this.parentTask != null && !Intrinsics.areEqual(task.getParent(), this.parentTask)) {
            throw new IllegalArgumentException("Task parent mismatch: " + task + " not a child of " + this.parentTask);
        }
        Task prev = (Task)this.registry.putIfAbsent(namespace2, task);
        if (!(prev == null)) {
            boolean bl = false;
            String string = task + " was already registered";
            throw new IllegalArgumentException(string.toString());
        }
        this.usableList.add(task);
        this.needsUpdating = true;
    }

    @NotNull
    public final List<T> getUsableList() {
        if (this.needsUpdating) {
            CollectionsKt.sortWith((List)this.usableList, (Comparator)new TaskComparator());
            this.needsUpdating = false;
        }
        List list = Collections.unmodifiableList((List)this.usableList);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    @NotNull
    public final <I, O> TaskContext executeTasks(I input, @NotNull Consumer<O> onOutput) {
        Intrinsics.checkNotNullParameter(onOutput, (String)"onOutput");
        TaskSession session = new AbstractTaskSession();
        IOTaskContext context = new AbstractIOTaskContext(input, session);
        this.executeDefinedTasks(context, onOutput);
        return context;
    }

    @ApiStatus.Internal
    public final <I, O> void executeDefinedTasks(@NotNull IOTaskContext<I, O> context, @NotNull Consumer<O> onOutput) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(onOutput, (String)"onOutput");
        for (Task task : this.getUsableList()) {
            TaskContext taskContext = context.createNew();
            Intrinsics.checkNotNull((Object)taskContext, (String)"null cannot be cast to non-null type org.kingdoms.tasks.context.IOTaskContext<I of org.kingdoms.tasks.TaskRegistry.executeDefinedTasks, O of org.kingdoms.tasks.TaskRegistry.executeDefinedTasks>");
            IOTaskContext subContext = (IOTaskContext)taskContext;
            try {
                task.run((TaskContext)subContext);
            }
            catch (Throwable ex) {
                new RuntimeException("Error while running task " + task + " with context " + subContext, ex).printStackTrace();
                subContext.setState(TaskState.ERROR);
            }
            context.setState(subContext.getState());
            if (subContext.getState() == TaskState.MUST_STOP) {
                return;
            }
            if (subContext.getOutput() == null) continue;
            context.setOutput(subContext.getOutput());
            onOutput.accept(subContext.getOutput());
        }
    }

    @Override
    public final void register(@NotNull Class<? extends LocalTaskSession> container) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        this.register(container, new DefaultTaskSessionConstructor(container));
    }

    public final void register(@NotNull Class<? extends LocalTaskSession> container, @NotNull TaskSessionConstructor<C> constructor) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        DefinedTaskSessionConstructor<C> delegateConstructor = new DefinedTaskSessionConstructor<C>(constructor);
        List tasks = new TaskAnnotationProcessor(container, delegateConstructor, null, 4, null).generate();
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task it = (Task)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type T of org.kingdoms.tasks.TaskRegistry");
            this.register((T)it);
        }
    }

    public TaskRegistry() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/kingdoms/tasks/TaskRegistry$TaskComparator;", "Ljava/util/Comparator;", "Lorg/kingdoms/tasks/Task;", "<init>", "(Lorg/kingdoms/tasks/TaskRegistry;)V", "compare", "", "first", "second", "shared"})
    private final class TaskComparator
    implements Comparator<Task<C>> {
        @Override
        public int compare(@NotNull Task<C> first, @NotNull Task<C> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            return first.compareTo(second, TaskRegistry.this);
        }
    }
}

