/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.mythicmobs;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomKingdomEntity;
import org.kingdoms.services.mythicmobs.conditions.KingdomsMythicMobConditionListener;
import org.kingdoms.services.mythicmobs.conditions.MythicMobConditionRegistry;
import org.kingdoms.services.mythicmobs.conditions.SimpleRelationalChecker;

public final class SimpleRelationalMMCondition
implements SimpleRelationalChecker {
    private final KingdomRelation relation;

    public SimpleRelationalMMCondition(KingdomRelation relation) {
        this.relation = relation;
    }

    public static void registerAll() {
        for (KingdomRelation relation : KingdomRelation.VALUES) {
            MythicMobConditionRegistry.register("relation_" + relation.getConfigName(), new SimpleRelationalMMCondition(relation));
        }
        Bukkit.getPluginManager().registerEvents((Listener)new KingdomsMythicMobConditionListener(), (Plugin)Kingdoms.get());
    }

    private static Kingdom tryGetKingdom(Entity entity2) {
        KingdomEntity kingdomEntity;
        KingdomPlayer kp;
        KingdomPlayer kingdomPlayer = kp = entity2 instanceof Player ? KingdomPlayer.getKingdomPlayer(entity2.getUniqueId()) : null;
        if (kp == null && (kingdomEntity = KingdomEntityRegistry.get(entity2)) instanceof KingdomKingdomEntity) {
            return ((KingdomKingdomEntity)kingdomEntity).getKingdom();
        }
        return kp == null ? null : kp.getKingdom();
    }

    @Override
    public boolean check(Entity caster, Entity target) {
        Kingdom casterKingdom = SimpleRelationalMMCondition.tryGetKingdom(caster);
        Kingdom targetKingdom = SimpleRelationalMMCondition.tryGetKingdom(target);
        if (casterKingdom == null || targetKingdom == null) {
            return false;
        }
        return casterKingdom.getRelationWith(targetKingdom) == this.relation;
    }
}

