/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.managers;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.kotlin.jvm.functions.Function2;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.services.Service;
import org.kingdoms.services.ServiceProjectKorra;
import org.kingdoms.services.managers.EmptyService;
import org.kingdoms.services.mythicmobs.SimpleRelationalMMCondition;
import org.kingdoms.utils.internal.stacktrace.StackTraces;

public enum SoftService {
    CITIZENS("Citizens"),
    MY_PET("MyPet", "org.kingdoms.services.pets.ServiceMyPet"),
    MC_PETS("MCPets", "org.kingdoms.services.pets.ServiceMCPets"),
    COMBAT_PETS("CombatPets", "org.kingdoms.services.pets.ServiceCombatPets"),
    SIMPLE_PETS("SimplePets", "org.kingdoms.services.pets.ServiceSimplePet"),
    MVDWPLACEHOLDERAPI("MVdWPlaceholderAPI", "org.kingdoms.services.placeholders.ServiceMVdWPlaceholder"),
    PLACEHOLDERAPI("PlaceholderAPI", "org.kingdoms.services.placeholders.ServicePlaceholderAPI"),
    PROJECT_KORRA("ProjectKorra", () -> new ServiceProjectKorra((Function2<? super Player, ? super Location, Boolean>)((Function2)(player, location) -> {
        Boolean attr;
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return false;
        }
        SimpleLocation loc = SimpleLocation.of(location);
        Land land = Land.getLand(location);
        if (land == null || !land.isClaimed()) {
            return false;
        }
        if (land.isKingdomBlock(loc.toBlockVector())) {
            return false;
        }
        Kingdom kingdom = land.getKingdom();
        if (!ServiceProjectKorra.protectDuringInvasions() && !land.getInvasions().isEmpty() && land.getInvasions().values().stream().anyMatch(i -> i.getInvader().equals(kp))) {
            return false;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && (attr = regulator.hasAttribute(player.getUniqueId(), Regulator.Attribute.BUILD)) != null) {
            return attr == false;
        }
        return (!kingdom.isMember(kp) || !kp.hasPermission(StandardKingdomPermission.BUILD)) && !StandardRelationAttribute.BUILD.hasAttribute(kp.getKingdom(), kingdom);
    }))),
    WORLD_GUARD("WorldGuard"),
    VAULT("Vault", "org.kingdoms.services.ServiceVault"),
    AUTH_ME("AuthMe", "org.kingdoms.services.ServiceAuthMe"),
    DISCORDSRV("DiscordSRV", "org.kingdoms.services.ServiceDiscordSRV"),
    LUCKPERMS("LuckPerms", "org.kingdoms.services.ServiceLuckPerms"),
    MYTHIC_MOBS("MythicMobs", SimpleRelationalMMCondition::registerAll, "org.kingdoms.services.mythicmobs.ServiceMythicMobFive", "org.kingdoms.services.mythicmobs.ServiceMythicMobFour"),
    ESSENTIALS("Essentials", "org.kingdoms.services.vanish.ServiceEssentialsX"),
    CMI("CMI", "org.kingdoms.services.vanish.ServiceCMI"),
    SLIMEFUN("Slimefun", "org.kingdoms.services.ServiceSlimefun"),
    NOVA("Nova", "org.kingdoms.services.ServiceNova"),
    DYNMAP("dynmap"),
    BLUEMAP("BlueMap"),
    SQUAREMAP("squaremap"),
    PL3XMAP("Pl3xMap");

    private static boolean announcedStates;
    private final String name;
    private final Service service;
    private ServiceState state;

    private SoftService(String name) {
        this(name, () -> EmptyService.INSTANCE);
    }

    private SoftService(String name, Supplier<Service> service) {
        this.name = name;
        this.state = this.checkAvailability();
        if (this.state == ServiceState.UNAVAILABLE || this.state == ServiceState.DISABLED) {
            this.service = EmptyService.INSTANCE;
            return;
        }
        this.service = service.get();
        this.checkAvailability(null);
    }

    private SoftService(String name, String ... classes) {
        this(name, (Runnable)null, classes);
    }

    private SoftService(String name, Runnable additional, String ... classes) {
        this.name = name;
        this.state = this.checkAvailability();
        this.service = this.state.shouldImplement() ? this.getCompatibleServiceOf(classes) : null;
        this.checkAvailability(additional);
    }

    private void checkAvailability(Runnable additional) {
        if (this.service != null) {
            try {
                SoftService.checkAvailability(additional, this.service);
            }
            catch (Throwable throwable) {
                this.state = ServiceState.HOOK_FAILED;
                throwable.printStackTrace();
            }
        }
    }

    private static void checkAvailability(Runnable additional, Service service) {
        Throwable error = service.checkAvailability();
        if (error != null) {
            throw XReflection.throwCheckedException((Throwable)error);
        }
        try {
            if (additional != null) {
                additional.run();
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Additional checks has failed while loading service " + service.getServiceName(), ex);
        }
    }

    private Service getCompatibleServiceOf(String ... classes) {
        ServiceState lastState = this.state;
        Throwable errors = null;
        for (String service : classes) {
            try {
                Service instance = (Service)Class.forName(service).getConstructor(new Class[0]).newInstance(new Object[0]);
                SoftService.checkAvailability(null, instance);
                this.state = ServiceState.HOOKED;
                return instance;
            }
            catch (Throwable ex) {
                if (errors == null) {
                    errors = new IllegalStateException("Error while initializing service " + (Object)((Object)this) + " with class '" + service + "':");
                }
                errors.addSuppressed(ex);
                lastState = ServiceState.HOOK_FAILED;
            }
        }
        if (lastState == ServiceState.HOOK_FAILED) {
            errors.printStackTrace();
        }
        this.state = lastState;
        return null;
    }

    public Service getService() {
        return this.service;
    }

    public String getName() {
        return this.name;
    }

    public static void reportAllStates() {
        MessageHandler.sendConsolePluginMessage("&6&lIntegrations&8:");
        for (SoftService service : SoftService.values()) {
            service.reportState();
        }
        announcedStates = true;
    }

    private void reportState() {
        String stateString;
        switch (this.state.ordinal()) {
            case 3: {
                stateString = "&afound &2and hooked.";
                break;
            }
            case 4: {
                stateString = "&afound &4but hooking failed.";
                break;
            }
            case 1: {
                stateString = "&afound.";
                break;
            }
            case 2: {
                stateString = "&afound &ebut integration is disabled.";
                break;
            }
            case 0: {
                stateString = "&cnot found.";
                break;
            }
            default: {
                stateString = "&5" + (Object)((Object)this.state);
            }
        }
        MessageHandler.sendConsolePluginMessage("  &7| &6" + this.name + ' ' + stateString);
    }

    public static boolean anyAvailable(SoftService ... services) {
        return Arrays.stream(services).anyMatch(SoftService::isAvailable);
    }

    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin(this.name);
    }

    private boolean isPluginAvailable() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(this.name);
        return plugin != null && (Kingdoms.getServerX() == null || !Kingdoms.getServerX().isReady() || plugin.isEnabled());
    }

    public boolean isAvailable() {
        return this.state.shouldImplement() && this.state != ServiceState.HOOK_FAILED && this.isPluginAvailable();
    }

    public void hook(boolean successful) {
        if (!this.state.shouldImplement()) {
            KLogger.warn("Hooked into unusable service " + (Object)((Object)this) + " -> " + successful);
            if (KLogger.isDebugging()) {
                StackTraces.printStackTrace();
            }
        }
        ServiceState serviceState = this.state = successful ? ServiceState.HOOKED : ServiceState.HOOK_FAILED;
        if (announcedStates) {
            this.reportState();
        }
    }

    private ServiceState checkAvailability() {
        if (!this.isPluginAvailable()) {
            return ServiceState.UNAVAILABLE;
        }
        boolean disabled = KingdomsConfig.DISABLED_INTEGRATIONS.getManager().getStringList().stream().map(x -> x.replace("-", "").toUpperCase(Locale.ENGLISH)).anyMatch(x -> x.equals(this.name.toUpperCase(Locale.ENGLISH)) || x.equals(this.name()));
        if (disabled) {
            return ServiceState.DISABLED;
        }
        return ServiceState.AVAILABLE;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '(' + this.name + ", " + (Object)((Object)this.state) + ", " + this.service + ')';
    }

    static {
        announcedStates = false;
    }

    public static enum ServiceState {
        UNAVAILABLE,
        AVAILABLE,
        DISABLED,
        HOOKED,
        HOOK_FAILED;


        public boolean shouldImplement() {
            return this != UNAVAILABLE && this != DISABLED;
        }
    }
}

