/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import java.util.Optional;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import org.bukkit.entity.Player;
import org.kingdoms.services.Service;

public final class ServiceSkins
implements Service {
    private static final SkinsRestorer API = SkinsRestorerProvider.get();

    public void changeSkin(Player player, SkinValueType type, String value) {
        SkinProperty prop;
        try {
            PlayerStorage playerStorage = API.getPlayerStorage();
            Optional property = playerStorage.getSkinForPlayer(player.getUniqueId(), player.getName());
            SkinStorage skinStorage = API.getSkinStorage();
            prop = type == SkinValueType.URL ? ((InputDataResult)skinStorage.findOrCreateSkinData(value, SkinVariant.CLASSIC).get()).getProperty() : (SkinProperty)property.get();
        }
        catch (DataRequestException | MineSkinException e) {
            throw new RuntimeException("Error while attemptin gto change " + player + "'s skin to '" + value + "' value of " + (Object)((Object)type), e);
        }
        API.getSkinApplier(Player.class).applySkin((Object)player, prop);
    }

    public static enum SkinValueType {
        URL,
        NAME;

    }
}

