/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.NodeMap;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.services.Service;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.functional.Fn;

public final class ServiceLuckPerms
implements ContextCalculator<Player>,
Service {
    private static final String[] RELATIONS = (String[])Arrays.stream(KingdomRelation.VALUES).map(x -> x.name().toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
    private static final String WILDERNESS = "wilderness";

    @Override
    public void enable() {
        LuckPerms lp = ServiceLuckPerms.getProvider();
        ServiceLuckPerms instance = null;
        if (lp != null) {
            instance = new ServiceLuckPerms();
            lp.getContextManager().registerCalculator((ContextCalculator)instance);
            MessageHandler.sendConsolePluginMessage("&2Successfully registered LuckPerms context.");
        } else {
            MessageHandler.sendConsolePluginMessage("&cCould not register LuckPerms context.");
        }
    }

    public static CompletableFuture<Boolean> perform(Collection<UUID> players, Operation operation, Collection<Node> permissions) {
        LuckPerms lp = ServiceLuckPerms.getProvider();
        if (lp == null) {
            return CompletableFuture.completedFuture(false);
        }
        UserManager userManager = lp.getUserManager();
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>(players.size());
        for (UUID player : players) {
            CompletableFuture userFuture = userManager.loadUser(player);
            tasks.add(userFuture.thenApplyAsync(user -> {
                NodeMap data = user.data();
                boolean allSuccessful = true;
                block5: for (Node permission : permissions) {
                    switch (operation.ordinal()) {
                        case 0: {
                            if (data.add(permission).wasSuccessful()) continue block5;
                            allSuccessful = false;
                            continue block5;
                        }
                        case 1: {
                            if (data.remove(permission).wasSuccessful()) continue block5;
                            allSuccessful = false;
                            continue block5;
                        }
                        case 2: {
                            if (data.contains(permission, NodeEqualityPredicate.EXACT).asBoolean()) continue block5;
                            allSuccessful = false;
                            continue block5;
                        }
                    }
                    throw new AssertionError((Object)operation);
                }
                return allSuccessful;
            }));
        }
        return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(x -> true);
    }

    public static List<Node> toNodes(Collection<String> permissions) {
        return permissions.stream().map(x -> Node.builder((String)x).build()).collect(Collectors.toList());
    }

    public static CompletableFuture<Boolean> perform(Collection<UUID> players, Operation operation, org.kingdoms.libs.snakeyaml.nodes.Node node) {
        if (!(node instanceof SequenceNode)) {
            return CompletableFuture.completedFuture(null);
        }
        SequenceNode sequenceNode = (SequenceNode)node;
        ArrayList<Node> permissions = new ArrayList<Node>();
        for (org.kingdoms.libs.snakeyaml.nodes.Node element : sequenceNode.getValue()) {
            permissions.add(ServiceLuckPerms.buildNode(element));
        }
        return ServiceLuckPerms.perform(players, operation, permissions);
    }

    public static Node buildNode(org.kingdoms.libs.snakeyaml.nodes.Node node) {
        if (node instanceof ScalarNode) {
            return Node.builder((String)((ScalarNode)node).getValue()).build();
        }
        if (node instanceof MappingNode) {
            MappingNode map = (MappingNode)node;
            ConfigSection section = new ConfigSection(map);
            String permission = Objects.requireNonNull(section.getString("permission"), () -> "Permission is null " + node.getWholeMark());
            NodeBuilder builder = Node.builder((String)permission);
            if (section.isSet("value")) {
                builder.value(section.getBoolean("value"));
            }
            if (section.isSet("expiry")) {
                builder.expiry(section.getTime("expiry", new PlaceholderContextBuilder()).toMillis());
            }
            if (section.isSet("context")) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull ImmutableContextSet.Builder contextBuilder = ImmutableContextSet.builder();
                ConfigSection context = section.getSection("context");
                if (context != null) {
                    for (String key : context.getKeys()) {
                        contextBuilder.add(key, context.getString(key));
                    }
                }
                builder.context((ContextSet)contextBuilder.build());
            }
            if (section.isSet("metadata")) {
                ConfigSection metadata = section.getSection("metadata");
                try {
                    Class<?> clazz = Class.forName(metadata.getString("class"));
                    NodeMetadataKey key = NodeMetadataKey.of((String)metadata.getString("name"), clazz);
                    Object value = clazz.cast(metadata.get("value"));
                    builder.withMetadata(key, Fn.cast(value));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return builder.build();
        }
        throw new IllegalArgumentException("Unexpected permission type: " + node.getWholeMark());
    }

    private static LuckPerms getProvider() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        return provider == null ? null : (LuckPerms)provider.getProvider();
    }

    @Override
    public void disable() {
        LuckPerms lp = ServiceLuckPerms.getProvider();
        if (lp != null) {
            lp.getContextManager().unregisterCalculator((ContextCalculator)this);
        }
    }

    public void calculate(@NonNull Player player, @NonNull ContextConsumer contextConsumer) {
        Kingdom kingdom;
        String relation;
        Land land = Land.getLand(player.getLocation());
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        String string = relation = land == null || !land.isClaimed() ? WILDERNESS : null;
        if (relation == null && (kingdom = land.getKingdom()) != null) {
            relation = kingdom.getRelationWith(kp.getKingdom()).name().toLowerCase(Locale.ENGLISH);
        }
        if (relation != null) {
            contextConsumer.accept("territory", relation);
        }
        contextConsumer.accept("hasKingdom", Boolean.toString(kp.hasKingdom()));
    }

    @NotNull
    public ContextSet estimatePotentialContexts() {
        ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
        builder.add("hasKingdom", "true");
        builder.add("hasKingdom", "false");
        builder.add("territory", WILDERNESS);
        for (String relation : RELATIONS) {
            builder.add("territory", relation);
        }
        return builder.build();
    }

    public static enum Operation {
        ADD,
        REMOVE,
        CONTAINS;

    }
}

